<?php
// Data soal dan warna
$soal = [
    1 => "Warna darah segar",
    2 => "Warna daun muda",
    3 => "Warna langit cerah",
    4 => "Warna matahari",
    5 => "Warna bunga lavender"
];

$jawaban = [
    "Merah",
    "Hijau",
    "Biru",
    "Kuning",
    "Ungu"
];

$warna_kode = [
    "Merah" => "#FF0000",
    "Hijau" => "#00FF00",
    "Biru" => "#0000FF",
    "Kuning" => "#FFFF00",
    "Ungu" => "#800080"
];
?>

<!DOCTYPE html>
<html>
<head>
    <title>Simulasi ANBK - Menjodohkan Warna</title>
    <style>
        body { font-family: Arial; }
        .container { display: flex; justify-content: space-between; margin-top: 30px; }
        .kolom { width: 45%; }
        .item {
            padding: 10px;
            margin: 5px 0;
            border: 1px solid #aaa;
            cursor: pointer;
            border-radius: 5px;
            transition: 0.3s;
        }
        .item:hover { background-color: #f0f0f0; }
        .selected { background-color: #d0f0ff; }
        .kotak-warna { color: white; text-align: center; }
        .disabled {
            opacity: 0.5;
            pointer-events: none;
            text-decoration: line-through;
        }
        .submit-btn { margin-top: 20px; padding: 10px 20px; }
    </style>
</head>
<body>
    <h2>🧩 Simulasi ANBK: Soal Menjodohkan Warna</h2>
    <p>Klik satu pernyataan di kiri, lalu klik warna yang cocok di kanan.</p>

    <form method="post" id="formJawaban">
        <div class="container">
            <div class="kolom" id="kolom-soal">
                <h3>Pernyataan</h3>
                <?php foreach ($soal as $no => $teks): ?>
                    <div class="item" onclick="pilihSoal(<?= $no ?>)" id="soal-<?= $no ?>">
                        <?= $teks ?>
                    </div>
                <?php endforeach; ?>
            </div>
            <div class="kolom" id="kolom-jawaban">
                <h3>Warna</h3>
                <?php foreach ($jawaban as $warna): ?>
                    <div class="item kotak-warna" style="background-color: <?= $warna_kode[$warna] ?>;" onclick="pilihJawaban('<?= $warna ?>')" id="jawaban-<?= $warna ?>">
                        <?= $warna ?>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        <input type="hidden" name="jawaban" id="jawabanData">
        <button type="submit" class="submit-btn">Kirim Jawaban</button>
    </form>

    <script>
        let soalTerpilih = null;
        let jawabanSiswa = {};
        const warnaKode = {
            "Merah": "#FF0000",
            "Hijau": "#00FF00",
            "Biru": "#0000FF",
            "Kuning": "#FFFF00",
            "Ungu": "#800080"
        };

        function pilihSoal(no) {
            soalTerpilih = no;
            document.querySelectorAll('#kolom-soal .item').forEach(el => el.classList.remove('selected'));
            document.getElementById('soal-' + no).classList.add('selected');
        }

        function pilihJawaban(warna) {
            if (soalTerpilih === null) {
                alert("Pilih pernyataan dulu!");
                return;
            }

            // Simpan jawaban
            jawabanSiswa[soalTerpilih] = warna;
            document.getElementById('jawabanData').value = JSON.stringify(jawabanSiswa);

            // Ubah tampilan soal
            let soalBox = document.getElementById('soal-' + soalTerpilih);
            soalBox.innerText = soalBox.innerText + " → " + warna;
            soalBox.style.backgroundColor = warnaKode[warna];
            soalBox.style.color = "#fff";
            soalBox.classList.remove('selected');

            // Disable warna
            let warnaBox = document.getElementById('jawaban-' + warna);
            warnaBox.classList.add('disabled');

            // Reset pilihan soal
            soalTerpilih = null;
        }
    </script>

    <?php
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $jawaban_user = json_decode($_POST['jawaban'], true);
        $kunci = [
            1 => "Merah",
            2 => "Hijau",
            3 => "Biru",
            4 => "Kuning",
            5 => "Ungu"
        ];

        echo "<h3>🔍 Hasil Jawaban:</h3>";
        $benar = 0;
        foreach ($kunci as $no => $warna_benar) {
            $jawab = $jawaban_user[$no] ?? "(belum dijawab)";
            if ($jawab === $warna_benar) {
                echo "Soal $no: ✅ ($jawab)<br>";
                $benar++;
            } else {
                echo "Soal $no: ❌ ($jawab, seharusnya $warna_benar)<br>";
            }
        }
        echo "<p><strong>Skor akhir: $benar dari " . count($kunci) . "</strong></p>";
    }
    ?>
</body>
</html>