<?php
session_start();

// Koneksi ke database
$mysqli = new mysqli("localhost", "root", "", "kuis_online");
if ($mysqli->connect_error) {
    die("<div class='error'>Koneksi gagal: " . htmlspecialchars($mysqli->connect_error) . "</div>");
}

// Proses login jika form dikirim
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST["username"]) && isset($_POST["password"])) {
    $username = trim($_POST["username"]);
    $password = trim($_POST["password"]);

    // Cek apakah pengguna ada di database
    $stmt = $mysqli->prepare("SELECT password FROM users WHERE username = ?");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $stmt->bind_result($hashedPassword);
    
    if ($stmt->fetch() && password_verify($password, $hashedPassword)) {
        $_SESSION["user"] = $username;
        header("Location: index.php");
        exit();
    } else {
        $error = "Username atau password salah.";
    }
    $stmt->close();
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Login</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
<div class="container">
    <h2 style="font-size: 2.2em; margin-bottom: 18px;">Login</h2>
    <?php if (isset($error)): ?>
        <div class="error"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>
    <form method="POST" action="login.php">
        <label for="username">Username:</label>
        <input type="text" name="username" required>
        <br>
        <label for="password">Password:</label>
        <input type="password" name="password" required>
        <br>
        <div style="text-align: center;">
            <button type="submit" style="background: linear-gradient(90deg, #4e54c8, #8f94fb); color: #fff; border: none; padding: 10px 30px; border-radius: 25px; font-size: 1.1em; cursor: pointer; transition: background 0.3s; margin-top: 18px; margin-bottom: 8px; letter-spacing: 1px;">
            <span style="vertical-align: middle; margin-right: 8px;">🔒</span> Login
            </button>
        </div>
    </form>
</div>
</body>
</html>