<?php
session_start();

$servername = "localhost";
$username = "root";
$password = "";
$dbname = "kuis_online";

// Buat koneksi ke database
$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) {
    die("Koneksi gagal: " . $conn->connect_error);
}

$pesan = "";
// Proses pendaftaran user
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = trim($_POST["username"]);
    $password = password_hash(trim($_POST["password"]), PASSWORD_DEFAULT); // Enkripsi password

    // Cek apakah username sudah ada
    $stmt_check = $conn->prepare("SELECT id FROM users WHERE username = ?");
    $stmt_check->bindo_param("s", $username);
    $stmt_check->execute();
    $stmt_check->store_result();

    if ($stmt_check->num_rows > 0) {
        $pesan = "<p class='text-danger'>Username sudah terdaftar! Pilih yang lain.</p>";
    } else {
        // Simpan user baru
        $stmt = $conn->prepare("INSERT INTO users (username, password) VALUES (?, ?)");
        $stmt->bindo_param("ss", $username, $password);
        if ($stmt->execute()) {
            $pesan = "<p class='text-success'>Registrasi berhasil! Silakan login.</p>";
        } else {
            $pesan = "<p class='text-danger'>Terjadi kesalahan, coba lagi.</p>";
        }
        $stmt->close();
    }
    $stmt_check->close();
}

$conn->close();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Registrasi User</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
<div class="container">
    <h2>Registrasi User Baru</h2>
    <?php if (!empty($pesan)) echo $pesan; ?>
    <form method="POST" action="">
        <label>Username:</label><br>
        <input type="text" name="username" required><br><br>
        <label>Password:</label><br>
        <input type="password" name="password" required><br><br>
        <input type="submit" value="Daftar">
    </form>
    <a href="login.php" class="logout-button">Kembali ke Login</a>
</div>
</body>
</html>