<?php
session_start();

// Jika sudah login sebagai admin, tampilkan menu input soal
if (isset($_SESSION["user"]) && isset($_SESSION["level"]) && $_SESSION["level"] === "admin") {
    $user = htmlspecialchars($_SESSION["user"]);
    $is_admin = true;
} else {
    $is_admin = false;
}

// Proses login admin
$login_error = "";
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["login_admin"])) {
    $username = $_POST["username"];
    $password = $_POST["password"];

    // Ganti username dan password di bawah sesuai kebutuhan
    if ($username === "admin" && $password === "admin123") {
        $_SESSION["user"] = $username;
        $_SESSION["level"] = "admin";
        header("Location: admin.php");
        exit();
    } else {
        $login_error = "Username atau password salah!";
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Admin - Input Soal</title>
    <link rel="stylesheet" href="style.css">
    <style>
        .mapel-list {
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
            gap: 24px;
            margin-top: 36px;
        }
        .mapel-card {
            background: linear-gradient(120deg, #fffbe7 60%, #ffe082 100%);
            border-radius: 22px;
            box-shadow: 0 4px 18px #ffe08255;
            padding: 32px 24px;
            width: 220px;
            text-align: center;
            transition: transform 0.2s, box-shadow 0.2s;
            font-family: 'Comic Sans MS', 'Comic Sans', cursive, Arial, sans-serif;
            font-size: 1.18em;
            color: #ff7f50;
            border: 2.5px solid #ffb347;
        }
        .mapel-card:hover {
            transform: scale(1.05) rotate(-2deg);
            box-shadow: 0 8px 32px #ffb34755;
            background: linear-gradient(120deg, #ffe082 60%, #fffbe7 100%);
            color: #007bff;
        }
        .mapel-card a {
            text-decoration: none;
            font-size: 3.2em;
            color: inherit;
            font-weight: bold;
            display: block;
        }
        .emoji {
            font-size: 2.2em;
            margin-bottom: 10px;
            display: block;
        }
        .login-form {
            max-width: 340px;
            margin: 60px auto;
            background: #fffbe7;
            border-radius: 18px;
            padding: 28px 24px;
            box-shadow: 0 4px 18px #ffe08255;
            border: 2px solid #ffe082;
        }
        .login-form label {
            display: block;
            margin-top: 12px;
            font-weight: bold;
            color: #ff7f50;
        }
        .login-form input[type="text"], .login-form input[type="password"] {
            width: 100%;
            padding: 8px 10px;
            margin-top: 4px;
            border-radius: 8px;
            border: 1.5px solid #ffb347;
            font-size: 1em;
        }
        .login-form button {
            margin-top: 18px;
            padding: 10px 28px;
            background: linear-gradient(90deg, #ffb347 0%, #ffcc80 100%);
            color: #fff;
            border: none;
            border-radius: 22px;
            font-size: 1.1em;
            font-weight: bold;
            cursor: pointer;
        }
        .login-form button:hover {
            background: linear-gradient(90deg, #ffcc80 0%, #ffb347 100%);
            color: #ff7f50;
        }
        .error-msg {
            color: red;
            margin-top: 10px;
            text-align: center;
        }
    </style>
</head>
<body>
<?php if ($is_admin): ?>
    <h2 style="text-align:center;">Selamat datang, <?= $user ?>! 👋</h2>
    <h3 style="text-align:center;">Menu Input Soal Mapel:</h3>
    <div class="mapel-list">
        <div class="mapel-card">
            <span class="emoji">🔢</span>
            <a href="input_mat.php">Input Soal Matematika</a>
        </div>
        <div class="mapel-card">
            <span class="emoji">📖</span>
            <a href="input_bind.php">Input Soal Bahasa Indonesia</a>
        </div>
        <div class="mapel-card">
            <span class="emoji">🌏</span>
            <a href="input_pancasila.php">Input Soal Pancasila</a>
        </div>
        <div class="mapel-card">
            <span class="emoji">🔬</span>
            <a href="input_ipas.php">Input Soal IPAS</a>
        </div>
        <div class="mapel-card">
            <span class="emoji">🇬🇧</span>
            <a href="input_inggris.php">Input Soal Bahasa Inggris</a>
        </div>
        <div class="mapel-card">
            <span class="emoji">🎭</span>
            <a href="input_jawa.php">Input Soal Bahasa Jawa</a>
        </div>
        <div class="mapel-card">
            <span class="emoji">🎨</span>
            <a href="input_seni.php">Input Soal Seni Budaya</a>
        </div>
    </div>
    <div style="margin-top:32px;text-align:center;">
        <a href="logout.php" class="logout-button">Logout</a>
    </div>
<?php else: ?>
    <form method="post" class="login-form" autocomplete="off">
        <h2 style="text-align:center;">Login Admin</h2>
        <?php if ($login_error): ?>
            <div class="error-msg"><?= $login_error ?></div>
        <?php endif; ?>
        <label>Username:</label>
        <input type="text" name="username" required autofocus>
        <label>Password:</label>
        <input type="password" name="password" required>
        <button type="submit" name="login_admin">Login</button>
    </form>
<?php endif; ?>
</body>
</html>