<?php
// Koneksi database
$mysqli = new mysqli("localhost", "root", "", "kuis_online");
if ($mysqli->connect_error) {
    die("Koneksi gagal: " . $mysqli->connect_error);
}

$pesan = "";
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $pertanyaan = $_POST["pertanyaan"];
    $jawaban1 = $_POST["jawaban1"];
    $jawaban2 = $_POST["jawaban2"];
    $jawaban3 = $_POST["jawaban3"];
    $jawaban_benar = $_POST["jawaban_benar"]; // Akan berisi '1', '2', atau '3'

    // Upload gambar jika ada
    $gambar = "";
    if (isset($_FILES['gambar']) && $_FILES['gambar']['error'] == 0) {
        $target_dir = "uploads/";
        if (!is_dir($target_dir)) mkdir($target_dir, 0777, true);
        $ext = strtolower(pathinfo($_FILES["gambar"]["name"], PATHINFO_EXTENSION));
        $nama_file = uniqid("img_") . "." . $ext;
        $target_file = $target_dir . $nama_file;
        if (move_uploaded_file($_FILES["gambar"]["tmp_name"], $target_file)) {
            $gambar = $target_file;
        } else {
            $pesan = "<span style='color:red;'>Gagal upload gambar.</span>";
        }
    }

    // Pilih jawaban benar sesuai pilihan user
    if ($jawaban_benar == "1") $jawaban_benar_val = $jawaban1;
    elseif ($jawaban_benar == "2") $jawaban_benar_val = $jawaban2;
    elseif ($jawaban_benar == "3") $jawaban_benar_val = $jawaban3;
    else $jawaban_benar_val = "";

    // Simpan ke tabel inggris (tambahkan kolom gambar)
    $stmt = $mysqli->prepare("INSERT INTO inggris (mapel, pertanyaan, jawaban1, jawaban2, jawaban3, jawaban_benar, gambar) VALUES ('inggris', ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("ssssss", $pertanyaan, $jawaban1, $jawaban2, $jawaban3, $jawaban_benar_val, $gambar);
    if ($stmt->execute()) {
        $pesan = "<span style='color:green;'>Soal berhasil ditambahkan!</span>";
    } else {
        $pesan = "<span style='color:red;'>Gagal menambah soal: " . $stmt->error . "</span>";
    }
    $stmt->close();
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Input Soal Bahasa Inggris</title>
    <link rel="stylesheet" href="style.css">
    <style>
        .input-form {
            background: linear-gradient(135deg, #fffbe7 60%, #ffe082 100%);
            padding: 10px 3px;
            border-radius: 22px;
            max-width: auto;
            margin: 40px auto 24px auto;
            box-shadow: 0 12px 36px 0 rgba(44, 62, 80, 0.22), 0 2px 10px rgba(166,170,241,0.18);
            color: #353232;
            font-size: 1.15em;
            font-weight: 400;
            text-align: center;
            position: relative;
            overflow: hidden;
        }
        .input-form label {
            display: block;
            margin-top: 12px;
            font-weight: bold;
            color: #ff7f50;
        }
        .input-form input[type="text"], .input-form textarea {
            width: 100%;
            padding: 8px 10px;
            margin-top: 4px;
            border-radius: 8px;
            border: 1.5px solid #ffb347;
            font-size: 1em;
        }
        .input-form .opsi-jawaban {
            display: flex;
            align-items: center;
            margin-top: 6px;
        }
        .input-form .opsi-jawaban input[type="radio"] {
            margin-right: 8px;
        }
        .input-form button {
            margin-top: 18px;
            padding: 10px 28px;
            background: linear-gradient(90deg,rgb(245, 9, 9) 0%,rgb(239, 100, 100) 100%);
            color: #fff;
            border: none;
            border-radius: 22px;
            font-size: 1.1em;
            font-weight: bold;
            cursor: pointer;
        }
        .input-form button:hover {
            background: linear-gradient(90deg, #ffcc80 0%, #ffb347 100%);
            color: #ff7f50;
        }
        h2  {
            font-size: 1.5em;
        }
    </style>
</head>
<body>
<div class="input-form">
    <h2>Input Soal Bahasa Indonesia</h2>
    <?= $pesan ?>
    <form method="post" action="" enctype="multipart/form-data">
        <label>Pertanyaan:</label>
        <textarea name="pertanyaan" required rows="3">

        </textarea>


    <!-- Input untuk gambar yang menarik -->
    <label>Gambar (opsional):</label>
    <div style="margin: 10px 0 18px 0; text-align: center;">
        <input type="file" name="gambar" accept="image/*" id="gambar" style="display:none;">
        <label for="gambar" style="display:inline-block; padding:8px 18px; background:#ffb347; color:#fff; border-radius:16px; cursor:pointer; font-weight:bold; transition:background 0.2s;">
        Pilih Gambar
        </label>
        <span id="nama-gambar" style="margin-left:10px; color:#888; font-size:0.98em;">Belum ada file dipilih</span>
    </div>
    <script>
        document.getElementById('gambar').addEventListener('change', function(e) {
            var fileName = e.target.files.length ? e.target.files[0].name : 'Belum ada file dipilih';
            document.getElementById('nama-gambar').textContent = fileName;
        });
        </script>

        <!-- Input untuk jawaban dengan opsi radio -->
        <label>Jawaban 1:</label>
        <div class="opsi-jawaban">
            <input type="radio" name="jawaban_benar" value="1" required> 
            <input type="text" name="jawaban1" required>
            <span style="margin-left:8px;color:#888;">(Pilih jika ini jawaban benar)</span>
        </div>
        <label>Jawaban 2:</label>
        <div class="opsi-jawaban">
            <input type="radio" name="jawaban_benar" value="2" required>
            <input type="text" name="jawaban2" required>
            <span style="margin-left:8px;color:#888;">(Pilih jika ini jawaban benar)</span>
        </div>
        <label>Jawaban 3:</label>
        <div class="opsi-jawaban">
            <input type="radio" name="jawaban_benar" value="3" required>
            <input type="text" name="jawaban3" required>
            <span style="margin-left:8px;color:#888;">(Pilih jika ini jawaban benar)</span>
        </div>
        <button type="submit">Simpan Soal</button>
    </form>

    <div style="margin-top:18px;">
        <a href="home.php">
            <button type="button">Kembali ke Home</button>
        </a>
    </div>
</div>
</body>
</html>