<?php
// filepath: c:\xampp\htdocs\soal_online\hasil.php
session_start();

$servername = "localhost";
$username = "root";
$password = "";
$dbname = "kuis_online";

// Koneksi ke database
$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) {
    die("Koneksi gagal: " . $conn->connect_error);
}

// Ambil daftar user
$sql_users = "SELECT id, username FROM users ORDER BY username";
$result_users = $conn->query($sql_users);

$mapel_list = [
    'matematika' => 'Matematika',
    'bindo'      => 'Bahasa Indonesia',
    'pancasila'  => 'Pendidikan Pancasila',
    'ipas'       => 'IPAS',
    'inggris'    => 'Bahasa Inggris',
    'jawa'       => 'Bahasa Jawa',
    'seni'       => 'Seni Budaya'
];

// Cek apakah ada user
if ($result_users->num_rows == 0) {
    echo "<h2>Tidak ada peserta yang terdaftar.</h2>";
    exit;
}
// Ambil daftar mata pelajaran
// $mapel_list berisi daftar mata pelajaran yang akan ditampilkan
// $mapel_list = [
//     'matematika' => 'Matematika',
//     'bindo'      => 'Bahasa Indonesia',


// Misal tabel hasil: hasil_user (id, username, mapel, skor, total_soal, waktu)
//     'pancasila'  => 'Pendidikan Pancasila',
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Rekap Hasil Peserta</title>
    <link rel="stylesheet" href="style.css">
    <style>
        body { background: #fffbe7; font-family: 'Comic Neue', Arial, sans-serif; }
        table { border-collapse: collapse; width: 100%; background: #fff; margin: 24px 0; }
        th, td { border: 1.5px solid #ffb347; padding: 8px 10px; text-align: center; }
        th { background: #ffe082; color: #1a237e; }
        tr:nth-child(even) { background: #fffde7; }
        h2 { color: #1a237e; margin-top: 24px; }
        td { color: #424242; }
        td b { color: #d84315; }
        td[style="color:#bbb;"] { color: #bbb; font-style: italic; }
        @import url('https://fonts.googleapis.com/css2?family=Comic+Neue:wght@400;700&display=swap');
        body, h2, table, th, td { font-family: 'Comic Neue', Arial, sans-serif; }
        th, td { font-size: 16px; }
        th { font-weight: bold; }
        td { font-weight: normal; }
        tr:hover { background: #ffe0b2; }
        td b { font-weight: bold; }
        td[style="color:#bbb;"] { color: #bbb; font-style: italic; }
        @media (max-width: 600px) {
            table, th, td { font-size: 14px; }
            th, td { padding: 6px; }
        }
        @media (max-width: 400px) {
            table, th, td { font-size: 12px; }
            th, td { padding: 4px; }
        }
        @media (max-width: 300px) {
            table, th, td { font-size: 10px; }
            th, td { padding: 2px; }
        }
       
        h2 { font-size: 1.5em; text-align: center; }
        @media (max-width: 800px) {
            h2 { font-size: 1.3em; }
            table, th, td { font-size: 15px; }
        }
        @media (max-width: 600px) {
            h2 { font-size: 1.25em; }
            table, th, td { font-size: 14px; }
        }
        @media (max-width: 400px) {
            h2 { font-size: 1.1em; }
            table, th, td { font-size: 12px; }
        }
        @media (max-width: 300px) {
            h2 { font-size: 1em; }
            table, th, td { font-size: 10px; }
        }

 
    </style>
</head>
<body>
    <h2>Rekap Hasil Pengerjaan Peserta</h2>
    <table>
        <thead>
            <tr>
                <th>No</th>
                <th>Nama Peserta</th>
                <?php foreach ($mapel_list as $kode => $nama): ?>
                    <th><?= htmlspecialchars($nama) ?></th>

                <?php endforeach; ?>

            </tr>
        </thead>
        <tbody>
        <?php
        $no = 1;
        while ($user = $result_users->fetch_assoc()):
            echo "<tr>";
            echo "<td>{$no}</td>";
            echo "<td>" . htmlspecialchars($user['username']) . "</td>";
            foreach ($mapel_list as $kode => $nama) {
                // Ambil hasil dari tabel hasil_user
                $stmt = $conn->prepare("SELECT skor, total_soal FROM hasil_user WHERE username=? AND mapel=? ORDER BY id DESC LIMIT 1");
                $stmt->bind_param("ss", $user['username'], $kode);
                $stmt->execute();
                $stmt->bind_result($skor, $total_soal);
                if ($stmt->fetch()) {
                    echo "<td><b>$skor</b> / $total_soal</td>";
                } else {
                    echo "<td style='color:#bbb;'>-</td>";
                }
                $stmt->close();
            }
            // Tutup baris
            if ($no % 2 == 0) {
                echo "<tr style='background: #fffde7;'>";
            } else {
                echo "<tr>";
            }

            echo "</tr>";
            $no++;
        endwhile;
        ?>
        </tbody>
    </table>
</body>
</html>