<?php
session_start();

// Jika sudah login sebagai admin, tampilkan menu input soal
if (isset($_SESSION["user"]) && isset($_SESSION["level"]) && $_SESSION["level"] === "admin") {
    $user = htmlspecialchars($_SESSION["user"]);
    $is_admin = true;
} else {
    $is_admin = false;
}

// Proses login admin
$login_error = "";
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["login_admin"])) {
    $username = $_POST["username"];
    $password = $_POST["password"];

    // Ganti username dan password di bawah sesuai kebutuhan
    if ($username === "admin" && $password === "admin123") {
        $_SESSION["user"] = $username;
        $_SESSION["level"] = "admin";
        header("Location: admin.php");
        exit();
    } else {
        $login_error = "Username atau password salah!";
        // Hapus session jika login gagal
        unset($_SESSION["user"]);
        unset($_SESSION["level"]);
        // Hapus cookie jika ada
        if (isset($_COOKIE["user"])) {
            setcookie("user", "", time() - 3600, "/");
        }
        if (isset($_COOKIE["level"])) {
            setcookie("level", "", time() - 3600, "/");
        }
        // Hapus session
        session_unset();
        session_destroy();
        // Redirect ke halaman login
        header("Location: admin.php");
        exit();
  
    }
    // Simpan username dan level di cookie jika login berhasil
    if ($is_admin) {
        setcookie("user", $username, time() + (86400 * 30), "/"); // 30 hari
        setcookie("level", "admin", time() + (86400 * 30), "/"); // 30 hari
    } else {
        // Hapus cookie jika login gagal
        setcookie("user", "", time() - 3600, "/");
        setcookie("level", "", time() - 3600, "/");
        // Hapus session
        session_unset();
        session_destroy();
        // Redirect ke halaman login
        header("Location: admin.php");
        exit();

    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
      <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin - Input Soal</title>
    <link rel="stylesheet" href="style.css">
    <style>
            
        .mapel-card {
            background: linear-gradient(120deg, #fffbe7 60%, #ffe082 100%);
            border-radius: 22px;
            box-shadow: 0 4px 18px #ffe08255;
            margin: 12px;
            cursor: pointer;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            text-align: center;
            transition: transform 0.2s, box-shadow 0.2s;
            font-family: 'Comic Sans MS', 'Comic Sans', cursive, Arial, sans-serif;
            font-size: 0.5em;
            color:rgb(106, 57, 39);
            border: 2.5px solid #ffb347;
        }
        .mapel-card:hover {
            transform: scale(1.05) rotate(-2deg);
            box-shadow: 0 8px 32px #ffb34755;
            background: linear-gradient(120deg, #ffe082 60%, #fffbe7 100%);
            color: #007bff;
        }
        .mapel-card a {
            text-decoration: none;
            font-size: 3.02em;
            color: inherit;
            font-weight: bold;
            display: block;
        }
        .emoji {
            font-size: 3.02em;
            margin-top: 12px;
            display: block;
            margin-bottom: 12px;
            transition: transform 0.2s;
            color: #ff7f50;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.2);
            margin-bottom: 0px; /* Reset margin for hover effect */

        }
        .mapel-card:hover .emoji {
            transform: scale(1.1) rotate(5deg);
            margin-bottom: 10px;
            display: block;
        }
        .login-form {
            max-width: 340px;
            margin: 60px auto;
            background: #fffbe7;
            border-radius: 18px;
            padding: 28px 24px;
            box-shadow: 0 4px 18px #ffe08255;
            border: 2px solid #ffe082;
        }
        .login-form label {
            display: block;
            margin-top: 12px;
            font-weight: bold;
            color: #ff7f50;
        }
        .login-form input[type="text"], .login-form input[type="password"] {
            width: 100%;
            padding: 8px 10px;
            margin-top: 1px;
            border-radius: 8px;
            border: 1.5px solid #ffb347;
            font-size: 1em;
        }
        .login-form button {
            margin-top: 18px;
            padding: 10px 28px;
            background: linear-gradient(90deg, #ffb347 0%, #ffcc80 100%);
            color: #fff;
            border: none;
            border-radius: 22px;
            font-size: 1.1em;
            font-weight: bold;
            cursor: pointer;
        }
        .login-form button:hover {
            background: linear-gradient(90deg, #ffcc80 0%, #ffb347 100%);
            color: #ff7f50;
        }
        .error-msg {
            color: red;
            margin-top: 10px;
            text-align: center;
        }
        body {
            background: linear-gradient(135deg, #f0f8ff, #e6e6fa);
            font-family: 'Comic Sans MS', 'Comic Sans', cursive, Arial, sans-serif;
            color: #333;
            margin: 0;
            padding: 0;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            min-height: 100vh; /* Memastikan body setinggi viewport */
            background-image: url('https://i.postimg.cc/3x1f7j5H/bg-kuis.jpg'); /* Ganti dengan URL gambar yang diinginkan */
            background-color: #f0f0f0; /* Warna latar belakang default */   
            background-blend-mode: overlay; /* Menggabungkan gambar dengan warna latar belakang */
            background-attachment: fixed; /* Membuat gambar tetap saat scroll */

            overflow-x: hidden; /* Mencegah scroll horizontal */
            scroll-behavior: smooth; /* Animasi scroll yang halus */
            -webkit-font-smoothing: antialiased; /* Memperhalus font di Webkit */
            -moz-osx-font-smoothing: grayscale; /* Memperhalus font di Firefox */

        }

    @media screen and (max-width: 800px) {
            .mapel-card {
                width: 70%;
                padding: 40px 50px;
            }
        }
        @media screen and (max-width: 600px) {
            .mapel-card {
                width: 89%;
                padding: 30px 40px;

            }
        }
        @media screen and (max-width: 400px) {
            .mapel-card {
                width: 40%;
                padding: 20px 30px;

            }
        }
    </style>
</head>
<body>
<?php if ($is_admin): ?>
    <h2 style="text-align:center;">Selamat datang, <?= $user ?>! 👋</h2>
    <h3 style="text-align:center;">Menu Input Soal Mapel:</h3>
    <div class="mapel-list">
        <div class="mapel-card">
            <span class="emoji">🔢</span>
            <a href="input_mat.php">Matematika</a>
        </div>
        <div class="mapel-card">
            <span class="emoji">📖</span>
            <a href="input_bind.php">Bahasa Indonesia</a>
        </div>
        <div class="mapel-card">
            <span class="emoji">🌏</span>
            <a href="input_pancasila.php">Pancasila</a>
        </div>
        <div class="mapel-card">
            <span class="emoji">🔬</span>
            <a href="input_ipas.php">IPAS</a>
        </div>
        <div class="mapel-card">
            <span class="emoji">🇬🇧</span>
            <a href="input_inggris.php">Bahasa Inggris</a>
        </div>
        <div class="mapel-card">
            <span class="emoji">🎭</span>
            <a href="input_jawa.php">Bahasa Jawa</a>
        </div>
        <div class="mapel-card">
            <span class="emoji">🎨</span>
            <a href="input_seni.php">Seni Budaya</a>
        </div>

        <div class="mapel-card">
            <span class="emoji">📊</span>
            <a href="hasil.php">Rekap Hasil Peserta</a>
                </div>
            
        <div class="mapel-card">
            <span class="emoji">📊</span>
            <a href="insert_user.php">Input Peserta</a>
                </div>
    </div>
    <style>
        body {
            background: linear-gradient(135deg, #f0f8ff, #e6e6fa);
            font-family: 'Comic Sans MS', 'Comic Sans', cursive, Arial, sans-serif;
        }
        h3 {
            color:rgb(46, 45, 44);
            font-size: 1.5em;
            text-align: center;
            margin-top: 24px;
        }
        h2 {
            font-family: 'Comic Sans MS', 'Comic Sans', cursive, Arial, sans-serif;
            color: #ff7f50;
            font-size: 2em;
            margin-top: 24px;
            text-align: center;
            margin-top: 2px;
        }

        p {
            font-family: 'Comic Sans MS', 'Comic Sans', cursive, Arial, sans-serif;
            color:rgb(46, 45, 44);
            font-size: 0.9em;
            text-align: center;
            margin: top 1px;
        }
       
        </style>
    <div style="margin-top:32px;margin-bottom: 32px;text-align:center;">
        <a href="logout.php" class="logout-button">Logout</a>
    </div>
    <style>
        .logout-button {
            background: linear-gradient(90deg, #ffb347, #ffcc80);
            color: #fff;
            padding: 10px 20px 10px 20px;
            border-radius: 22px;
            text-decoration: none;
            font-weight: bold;
            font-size: 1.1em;
            border: 2px solid #ff7f50;
            display: inline-block;
            cursor: pointer;
            transition: background 0.3s, color 0.3s;
            box-shadow: 0 4px 18px rgba(255, 165, 0, 0.5);
            font-family: 'Comic Sans MS', 'Comic Sans', cursive, Arial, sans-serif;

        }
        .logout-button:hover {
            background: linear-gradient(90deg, #ffcc80, #ffb347);
            color: #ff7f50;
            
            box-shadow: 0 6px 24px rgba(255, 165, 0, 0.7);

        }
    </style>
    <footer>
        <p>&copy; 2025 Kelas 5 Soal Online Kelas 5. All rights reserved.</p>
        <p>Dibuat dan dikembangkan oleh tim IT SDN Magetan 2</p>
<?php else: ?>
    <form method="post" class="login-form" autocomplete="off">
        <h2 style="text-align:center;">Login Admin</h2>
        <?php if ($login_error): ?>
            <div class="error-msg"><?= $login_error ?></div>
        <?php endif; ?>
        <label>Username:</label>
        <input type="text" name="username" required autofocus>
        <label>Password:</label>
        <input type="password" name="password" required>
        <button type="submit" name="login_admin">Login</button>
    </form>
    <div style="text-align:center; margin-top: 20px;">
        <a href="index.php">Kembali ke Halaman Utama</a>
    </div>
    <style>
        body {
            background: linear-gradient(135deg, #f0f8ff, #e6e6fa);
            font-family: 'Comic Sans MS', 'Comic Sans', cursive, Arial, sans-serif;

        }
        h2 {
            color: #ff7f50;
            text-align: center;
            margin-top: 24px;
            
        }
        .logout-button {
            background: linear-gradient(90deg, #ffb347, #ffcc80);
            color: #fff;
            padding: 10px 20px;
            border-radius: 22px;
            text-decoration: none;
            font-weight: bold;

        }
        .logout-button:hover {
            background: linear-gradient(90deg, #ffcc80, #ffb347);
            color: #ff7f50;
        }
    </style>
<?php endif; ?>
</body>

</footer>
</div>
</html>