<?php
// filepath: /opt/lampp/htdocs/soal_online/rekap_akm.php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!isset($_SESSION["user"])) {
    header("Location: login.php");
    exit();
}

$pesan_error = "";
$peserta = [];

// Koneksi database
$mysqli = new mysqli("localhost", "lnibbicy_kka4", "magetan#2", "lnibbicy_kka4");
if ($mysqli->connect_error) {
    $pesan_error = "Koneksi gagal: " . $mysqli->connect_error;
} else {
    // Ambil semua peserta unik
    $sql = "SELECT DISTINCT username FROM (
        SELECT username FROM hasil_ganda_b
        UNION
        SELECT username FROM hasil_komplek
        UNION
        SELECT username FROM hasil_jodoh
        UNION
        SELECT username FROM hasil_bs
    ) as all_user";
    $res = $mysqli->query($sql);
    if (!$res) {
        $pesan_error = "Gagal mengambil data peserta: " . $mysqli->error;
    } else {
        while ($row = $res->fetch_assoc()) {
            $peserta[] = $row['username'];
        }
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Rekap Skor Peserta AKM</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body { 
            font-family: Arial, sans-serif; 
            background: linear-gradient(135deg, #5763efff 0%, #071728ff 100%);
            color: #333;
            margin: 0;
            padding: 20px;
        }
        
        .container { 
            text-align: center;
            max-width: 900px; 
            margin: 40px auto; 
            background: #eae9eeff; 
            border-radius: 16px; box-shadow: 0 15px 16px #00000033; padding: 32px 24px; }
        h2 { color: #34067cff; text-align: center; margin-bottom: 24px; }
        .error { color: red; text-align: center; margin-bottom: 18px; font-weight: bold; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 24px; }
        th, td { border: 1px solid #b3c6e0; padding: 10px 8px; text-align: center; }
        th { background: #bbdefb; color: #1976d2; }
        tr:nth-child(even) { background: #f7fbff; }
        .btn-login {
            background: #d23e19ff;
    color: #fff;
    border: none;
    border-radius: 8px;
    padding: 10px 32px;
    font-size: 1.1em;
    cursor: pointer;
    margin-top: 18px;
        }
        .btn-login:hover { background: #1565c0; }
        @media (max-width: 600px) {
            .container { padding: 12px 2vw; }
            table, th, td { font-size: 0.95em; }
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Rekap Skor Peserta AKM</h2>
        <?php if ($pesan_error): ?>
            <div class="error"><?= htmlspecialchars($pesan_error) ?></div>
        <?php endif; ?>
        <table>
            <tr>
                <th>No</th>
                <th>Username</th>
                <th>Nama Mapel</th>
                <th>Skor Ganda B</th>
                <th>Skor Komplek</th>
                <th>Skor Jodoh</th>
                <th>Skor Benar/Salah</th>
                <th>Total Skor</th>
                <th>Skor Mak</th>
                <th>Nilai</th>
            </tr>
            <?php
            if (!$pesan_error && count($peserta) > 0) {
                $no = 1;
                foreach ($peserta as $user) {
                    // Skor tiap jenis
                    $skor_ganda = $mysqli->query("SELECT SUM(skor) FROM hasil_ganda_b WHERE username='$user'");
                    $skor_komplek = $mysqli->query("SELECT SUM(skor) FROM hasil_komplek WHERE username='$user'");
                    $skor_jodoh = $mysqli->query("SELECT SUM(skor) FROM hasil_jodoh WHERE username='$user'");
                    $skor_bs = $mysqli->query("SELECT SUM(skor) FROM hasil_bs WHERE username='$user'");

                    $row_ganda = $skor_ganda->fetch_row();
                    $row_komplek = $skor_komplek->fetch_row();
                    $row_jodoh = $skor_jodoh->fetch_row();
                    $row_bs = $skor_bs->fetch_row();

                    $sg = $row_ganda[0] ?? 0;
                    $sk = $row_komplek[0] ?? 0;
                    $sj = $row_jodoh[0] ?? 0;
                    $sb = $row_bs[0] ?? 0;
                    $total = $sg + $sk + $sj + $sb;

                    // Hitung skor maksimum
                    $qmax = $mysqli->query("
                        SELECT
                            (SELECT SUM(skor_b) FROM ganda_b) +
                            (SELECT SUM(skor_k) FROM komplek_soal) +
                            (SELECT SUM(skor_j) FROM jodoh_soal) +
                            (SELECT SUM(skor_bs) FROM benar_salah) AS total_skor_max
                    ");
                    $rowmax = $qmax ? $qmax->fetch_assoc() : ["total_skor_max"=>0];
                    $total_skor_max = $rowmax["total_skor_max"] ? $rowmax["total_skor_max"] : 0;
                    $nilai = $total_skor_max > 0 ? round(($total / $total_skor_max) * 100, 1) : 0;

                    $nama_mapel = 'Matematika';
                    echo "<tr>
                        <td>$no</td>
                        <td>".htmlspecialchars($user)."</td>
                        <td>$nama_mapel</td>
                        <td>$sg</td>
                        <td>$sk</td>
                        <td>$sj</td>
                        <td>$sb</td>
                        <td><b>$total</b></td>
                        <td><b>$total_skor_max</b></td>
                        <td><b>$nilai</b></td>
                    </tr>";
                    $no++;
                }
            } else if (!$pesan_error) {
                echo "<tr><td colspan='7'>Tidak ada data peserta.</td></tr>";
            }
            ?>
        </table>
        <div style="margin-bottom: 16px;">
    <form method="get" action="export_xls.php" style="display:inline-block; margin-right: 12px;">
        <button type="submit" class="btn-login" style="background-color: #28a745;">Export ke XLS</button>
    </form>
    <form method="get" action="login.php" style="display:inline-block;">
        <button type="submit" class="btn-login">Kembali ke Login</button>
    </form>
</div>


    </div>
</body>
</html>
