<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sistem Monitoring</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        .btn-hover {
            transition: all 0.3s ease;
            transform: translateY(0);
        }
        .btn-hover:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1);
        }
        .btn-animate:active {
            transform: translateY(1px);
        }
    </style>
</head>
<body class="bg-gray-100 min-h-screen">
    <div class="container mx-auto px-4 py-12">
        <div class="text-center mb-12">
            <h1 class="text-4xl font-bold text-gray-800 mb-2">SISTEM MONITORING</h1>
            <p class="text-lg text-gray-600">Pilih menu yang tersedia di bawah ini</p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            <!-- Tombol Ambil BS -->
            <a href="ambil_bs.php" class="block">
                <div class="btn-hover btn-animate bg-blue-600 hover:bg-blue-700 text-white rounded-lg p-8 shadow-md flex flex-col items-center justify-center h-full">
                    <div class="text-4xl mb-4">
                        <img src="https://storage.googleapis.com/workspace-0f70711f-8b4e-4d94-86f1-2a93ccde5887/image/d14d9969-957f-4bb5-8891-85e86a2ac470.png" alt="Icon dokumen dengan simbol BS di tengah, warna biru dan putih" style="border-radius: 50%;">
                    </div>
                    <h2 class="text-xl font-semibold">AMBIL BS</h2>
                    <p class="text-center mt-2 opacity-90">Klik untuk memproses data BS</p>
                </div>
            </a>

            <!-- Tombol Ambil Komplek -->
            <a href="ambil_komplek.php" class="block">
                <div class="btn-hover btn-animate bg-green-600 hover:bg-green-700 text-white rounded-lg p-8 shadow-md flex flex-col items-center justify-center h-full">
                    <div class="text-4xl mb-4">
                        <img src="https://storage.googleapis.com/workspace-0f70711f-8b4e-4d94-86f1-2a93ccde5887/image/e12827f5-20cb-445e-a080-90fb394c80ba.png" alt="Icon komplek perumahan dengan beberapa rumah kecil berwarna hijau" style="border-radius: 50%;">
                    </div>
                    <h2 class="text-xl font-semibold">AMBIL KOMPLEK</h2>
                    <p class="text-center mt-2 opacity-90">Klik untuk memproses data komplek</p>
                </div>
            </a>

            <!-- Tombol Ambil Jodoh -->
            <a href="ambil_jodoh.php" class="block">
                <div class="btn-hover btn-animate bg-purple-600 hover:bg-purple-700 text-white rounded-lg p-8 shadow-md flex flex-col items-center justify-center h-full">
                    <div class="text-4xl mb-4">
                        <img src="https://storage.googleapis.com/workspace-0f70711f-8b4e-4d94-86f1-2a93ccde5887/image/03a817ba-7268-4289-aec7-03c14085cfe5.png" alt="Icon dua orang bergandengan tangan dengan warna ungu" style="border-radius: 50%;">
                    </div>
                    <h2 class="text-xl font-semibold">AMBIL JODOH</h2>
                    <p class="text-center mt-2 opacity-90">Klik untuk memproses data jodoh</p>
                </div>
            </a>

            <!-- Tombol Ambil GB -->
            <a href="ambil_gb.php" class="block">
                <div class="btn-hover btn-animate bg-yellow-600 hover:bg-yellow-700 text-white rounded-lg p-8 shadow-md flex flex-col items-center justify-center h-full">
                    <div class="text-4xl mb-4">
                        <img src="https://storage.googleapis.com/workspace-0f70711f-8b4e-4d94-86f1-2a93ccde5887/image/5fec7232-b67c-4fc0-ba38-204563e68f52.png" alt="Icon papan tulis dengan tulisan GB berwarna kuning" style="border-radius: 50%;">
                    </div>
                    <h2 class="text-xl font-semibold">AMBIL GB</h2>
                    <p class="text-center mt-2 opacity-90">Klik untuk memproses data GB</p>
                </div>
            </a>
        </div>

        <div class="mt-12 text-center text-gray-500 text-sm">
            <p>© 2023 Sistem Monitoring. All rights reserved.</p>
        </div>
    </div>
</body>
</html>

