<?php
// Mulai sesi jika diperlukan (misalnya untuk otentikasi)
session_start();

// Konfigurasi database (sesuaikan dengan koneksi Anda)
$mysqli = new mysqli("localhost", "lnibbicy_kka4", "magetan#2", "lnibbicy_kka4");
if ($mysqli->connect_error) {
    die("<div style='color: #dc3545; padding: 10px; background-color: #343a40; border-radius: 5px;'>Koneksi gagal: " . htmlspecialchars($mysqli->connect_error) . "</div>");
}

// Fungsi untuk mengambil data hasil kuis dari database
function getQuizResults($mysqli) {
    $results = [];
    // Contoh query: Ambil nama pengguna, nomor soal, jawaban pengguna, dan status benar/salah
    // Anda perlu menyesuaikan query ini dengan struktur tabel database Anda
    // Asumsi: Ada tabel 'users', 'quizzes', 'user_answers'
    $query = "
        SELECT 
            u.username, 
            qa.question_number, 
            qa.user_answer, 
            qa.is_correct
        FROM 
            user_answers qa
        JOIN 
            users u ON qa.user_id = u.id
        ORDER BY 
            u.username, qa.question_number
    ";
    
    $stmt = $mysqli->prepare($query);
    if ($stmt) {
        $stmt->execute();
        $res = $stmt->get_result();
        
        while ($row = $res->fetch_assoc()) {
            $username = $row['username'];
            if (!isset($results[$username])) {
                $results[$username] = [
                    'nama' => $username,
                    'soal' => []
                ];
            }
            $results[$username]['soal'][] = [
                'nomor' => $row['question_number'],
                'jawaban' => $row['user_answer'],
                'benar' => (bool)$row['is_correct']
            ];
        }
        $stmt->close();
    }
    return $results;
}

// Ambil data hasil kuis
$peserta_data = getQuizResults($mysqli);

// Tutup koneksi database
$mysqli->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Laporan Hasil Kuis</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #1a1a1a; /* Dark background */
            color: #e0e0e0; /* Light text */
            margin: 0;
            padding: 20px;
            line-height: 1.6;
        }
        .container {
            max-width: 900px;
            margin: 20px auto;
            background-color: #2c2c2c; /* Slightly lighter dark background for container */
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.3);
        }
        h1, h2 {
            color: #4CAF50; /* Green accent for headings */
            text-align: center;
            margin-bottom: 25px;
        }
        .peserta-card {
            background-color: #3a3a3a;
            border-left: 5px solid #4CAF50;
            padding: 20px;
            margin-bottom: 20px;
            border-radius: 6px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
        }
        .peserta-card h3 {
            color: #e0e0e0;
            margin-top: 0;
            margin-bottom: 15px;
            border-bottom: 1px solid #555;
            padding-bottom: 10px;
        }
        .soal-item {
            margin-bottom: 8px;
            padding-left: 15px;
            position: relative;
        }
        .soal-item::before {
            content: '•';
            color: #4CAF50;
            position: absolute;
            left: 0;
        }
        .correct {
            color: #8bc34a; /* Light green for correct answers */
        }
        .incorrect {
            color: #ef5350; /* Red for incorrect answers */
        }
        .summary {
            margin-top: 15px;
            padding-top: 10px;
            border-top: 1px dashed #555;
            font-weight: bold;
        }
        .summary span {
            color: #4CAF50;
        }
        .no-data {
            text-align: center;
            color: #bbb;
            padding: 30px;
            background-color: #3a3a3a;
            border-radius: 8px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Laporan Hasil Kuis Ganda</h1>
        <h2>SD Negeri Magetan 2 - Tahun 2025</h2>

        <?php if (!empty($peserta_data)): ?>
            <?php foreach ($peserta_data as $p): ?>
                <div class="peserta-card">
                    <h3>Peserta: <?php echo htmlspecialchars($p['nama']); ?></h3>
                    <h4>Detail Jawaban:</h4>
                    <?php
                    $benar = 0;
                    $totalSoal = count($p['soal']);
                    if ($totalSoal > 0) {
                        foreach ($p['soal'] as $s) {
                            $status_class = $s['benar'] ? 'correct' : 'incorrect';
                            $status_text = $s['benar'] ? 'Benar' : 'Salah';
                            echo "<div class='soal-item'>Soal " . htmlspecialchars($s['nomor']) . ": Jawaban Anda " . htmlspecialchars($s['jawaban']) . " - <span class='" . $status_class . "'>" . $status_text . "</span></div>";
                            if ($s['benar']) {
                                $benar++;
                            }
                        }
                        $persentase = ($benar / $totalSoal) * 100;
                    } else {
                        $persentase = 0;
                    }
                    ?>
                    <div class="summary">
                        Jumlah Benar: <span><?php echo $benar; ?></span> dari <span><?php echo $totalSoal; ?></span> soal<br>
                        Persentase Akurasi: <span><?php echo number_format($persentase, 2); ?>%</span>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <div class="no-data">
                <p>Belum ada data hasil kuis yang tersedia.</p>
            </div>
        <?php endif; ?>
    </div>
</body>
</html>
