<?php
session_start();
if (!isset($_SESSION["user"])) {
    header("Location: login.php");
    exit;
}
$user = $_SESSION["user"];

// Koneksi ke database
$conn = new mysqli("localhost", "lnibbicy_kka4", "magetan#2", "lnibbicy_kka4");
if ($conn->connect_error) {
    die("Koneksi gagal: " . $conn->connect_error);
}

// Ambil soal dari tabel jodoh_soal berdasarkan ID
if (isset($_GET['id'])) {
    $id_soal = intval($_GET['id']);
} else {
    // Ambil id soal terakhir (soal terbaru)
    $sql_last = "SELECT id FROM jodoh_soal ORDER BY id DESC LIMIT 1";
    $result_last = $conn->query($sql_last);
    if ($result_last && $row_last = $result_last->fetch_assoc()) {
        $id_soal = $row_last['id'];
    } else {
        echo "Tidak ada soal tersedia.";
        exit;
    }
}

// Cek apakah user sudah mengerjakan soal ini
$sql_check = "SELECT skor FROM hasil_jodoh WHERE id_soal = ? AND username = ?";
$stmt_check = $conn->prepare($sql_check);
$stmt_check->bind_param("is", $id_soal, $user);
$stmt_check->execute();
$result_check = $stmt_check->get_result();

if ($result_check->num_rows > 0) {
    $row_check = $result_check->fetch_assoc();
    if ($row_check['skor'] > 0) {
        // Jika sudah mengerjakan dan skor > 0, redirect ke skor_akhir.php
        header("Location: skor_akhir.php");
        exit;
    }
    // Jika skor == 0, izinkan mengerjakan lagi (lanjutkan tanpa redirect)
    // Opsional: Hapus record lama jika ingin menghindari duplikasi
    // $sql_delete = "DELETE FROM hasil_jodoh WHERE id_soal = ? AND username = ?";
    // $stmt_delete = $conn->prepare($sql_delete);
    // $stmt_delete->bind_param("is", $id_soal, $user);
    // $stmt_delete->execute();
}

$sql = "SELECT * FROM jodoh_soal WHERE id = $id_soal";
$result = $conn->query($sql);

if ($result->num_rows != 1) {
    echo "Soal tidak ditemukan.";
    exit;
}

// ... (rest of your code remains unchanged)

$row = $result->fetch_assoc();
$judul = $row['judul'];
$gambar = $row['gambar'];
$pertanyaan = $row['pertanyaan'];
$kolom_kiri = json_decode($row['kolom_kiri'], true);
$kolom_kanan = json_decode($row['kolom_kanan'], true);
$jawaban_benar = json_decode($row['jawaban_benar'], true);

if (!is_array($kolom_kiri) || !is_array($kolom_kanan) || !is_array($jawaban_benar)) {
    echo "Format data soal tidak valid.";
    exit;
}

// Array warna unik untuk pasangan
$warna_pilihan = [
    "#ffd54f", "#4fc3f7", "#aed581", "#ff8a65", "#ba68c8",
    "#f06292", "#90a4ae", "#fff176", "#81d4fa", "#e57373"
];

// Proses kirim jawaban
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $jawaban_user = json_decode($_POST['jawaban'], true);
    $benar = 0;
    foreach ($kolom_kiri as $no => $teks) {
        $no_str = (string)$no;
        $jawab = isset($jawaban_user[$no_str]) ? trim(strtolower($jawaban_user[$no_str])) : "(belum dijawab)";
        $kunci = isset($jawaban_benar[$no_str]) ? trim(strtolower($jawaban_benar[$no_str])) : null;
        if ($jawab == $kunci && $kunci !== null && $jawab !== "(belum dijawab)") $benar++;
    }
    // Opsional: Hapus record lama sebelum insert baru (untuk menghindari duplikasi)
    $sql_delete = "DELETE FROM hasil_jodoh WHERE id_soal = ? AND username = ?";
    $stmt_delete = $conn->prepare($sql_delete);
    $stmt_delete->bind_param("is", $id_soal, $user);
    $stmt_delete->execute();
    
    // Simpan ke tabel hasil_jodoh
    $stmt = $conn->prepare("INSERT INTO hasil_jodoh (id_soal, username, jawaban_user, skor) VALUES (?, ?, ?, ?)");
    $jawaban_json = json_encode($jawaban_user);
    $stmt->bind_param("issi", $id_soal, $user, $jawaban_json, $benar);
    $stmt->execute();
    // Redirect ke skor_akhir.php setelah submit
    header("Location: bs.php");
    exit;
}
?>

<!DOCTYPE html>
<html>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<html lang="id">

<head>
    

    
    <title><?= htmlspecialchars($judul) ?></title>
    <style>
        body {
            font-family: 'Open Sans', 'Comic Sans MS', Arial, sans-serif;
            background: #00379cff 100%;
            margin: 0;
            padding: 0;
            min-height: 100vh;
        }
        h2 {
            text-align: center;
            font-size: 1.9em;
            color: #1976d2;
            margin-top: 32px;
            margin-bottom: 8px;
            letter-spacing: 1px;
        }
        .gambar-soal {
    display: block;
    width: 100%; /* Gambar memenuhi lebar kontainer */
    max-width: 900px; /* Batas maksimum lebar */
    height: auto; /* Menjaga rasio aspek gambar */
    border-radius: 8px;
    object-fit: cover; /* Opsional: potong gambar agar tetap proporsional */
}
        .user-info {
            text-align: center;
            font-size: 1.5em;
            color: #0d1d63ff;
            margin-bottom: 16px;
        }

        p {
            text-align: justify;
            font-size: 1.5em;
            color: #333;
            margin-bottom: 35px;
            margin-top: 0.015em;
            padding: 1px 1px;
        }
        .container {
        background-image: url('images/logo hp.png'); /* Path gambar latar */
        background-size: cover;
            display: flex;
            justify-content: center;
            align-items: flex-start;
            gap: 32px;
            margin: 0 auto;
            max-width: 900px;
            background: #fff;
            border-radius: 8px;
            padding: 32px 24px;
        }
        .kolom {
            width: 45%;
            padding: 18px 14px;
            border-radius: 12px;
            min-height: 320px;
        }
        .kolom.pernyataan {
            background: #e3f2fd;
        }
        .kolom.pasangan {
            background: #e3f2fd;
        }
        .kolom h3 {
            text-align: center;
            color: #1976d2;
            margin-bottom: 18px;
            letter-spacing: 1px;
        }
        .item {
            padding: 14px 12px;
            margin: 10px 0;
            border: 2px solid #90caf9;
            cursor: pointer;
            border-radius: 8px;
            transition: box-shadow 0.2s, background 0.2s, border 0.2s;
            font-weight: 500;
            font-size: 1.4em;
            background: #fff;
            position: relative;
        }
        .kolom.pasangan .item {
            background: inherit;
            border: 2px solid #ffe082;
                        font-size: 1.4em;
        }
        .item:hover:not(.disabled):not(.selected) {
            box-shadow: 0 2px 8px rgba(25, 118, 210, 0.13);
            background: #e3f2fd;
            border-color: #1976d2;
        }
        .selected {
            outline: 3px solid #1976d2;
            background: #bbdefb !important;
        }
        .disabled {
            opacity: 0.6;
            pointer-events: none;
            text-decoration: line-through;
            filter: grayscale(0.2);
        }
        .submit-btn {
            margin: 32px auto 0 auto;
            display: block;
            padding: 12px 36px;
            background: #1c8effff;
            color: #fff;
            border: none;
            border-radius: 8px;
            font-size: 1.1em;
            font-weight: bold;
            cursor: pointer;
        }
        .submit-btn:hover {
            background: #0072cfff;
        }
     
        @media (max-width: 400px) {
            .container {
                background-image: url('images/logo hp.png'); /* Path gambar latar */
        background-size: cover;
        background-repeat: no-repeat;
        -webkit-backdrop-filter: blur(9px); /* Dukungan Safari */
        
                padding: 8px 2vw;
                gap: 16px;

            }

            h2 {
            
            font-size: 1.4em;
            margin-top: 24px;
            margin-bottom: 4px;
            letter-spacing: 1px;
        }
            p {
            margin-top: 0.015em;
            margin-bottom: 10px;
            font-size: 1.2em;
            padding: 3px 3px 8px 3px;
        }

            .kolom {
                padding: 1px 1px;
            }
            .kolom h3 {
                font-size: 1.2em;
            }
            .item {
                font-size: 1em;
                padding: 10px 8px;
                margin: 8px 0;
            }
            .gambar-soal {
                max-width: 100%;
                height: auto;
                padding: 1px 1px;

            }
            .user-info {
                font-size: 0.9em;
                text-align: center;
                margin-bottom: 16px;
            }
            .submit-btn {
                padding: 10px 24px;
                font-size: 1em;
            }
            .kolom.pernyataan, .kolom.pasangan {
                width: 100%;
                margin-bottom: 16px;
            }
            .kolom.pernyataan {
                background: #8bcaf7ff;
            }
            .kolom.pasangan {
                background: #a5a29fff;
            }
            .kolom h3 {
                font-size: 1.1em;
            }
            .item {
                padding: 8px 6px;
                font-size: 1.3em;
            }
            .item:hover:not(.disabled):not(.selected) {
                box-shadow: 0 1px 4px rgba(25, 118, 210, 0.1);
                background: #e3f2fd;
                border-color: #1976d2;
            }
            .item.selected {
                outline: 2px solid #1976d2;
                background: #bbdefb !important;
            }
            .item.disabled {
                opacity: 0.5;
                pointer-events: none;
                text-decoration: line-through;
                filter: grayscale(0.3);
            }
            .kolom h3 {
                margin-bottom: 12px;
            }
            .user-info {
                margin-bottom: 12px;
                font-size: 1.7em;
                text-align: center;
            }
            .kolom.pernyataan, .kolom.pasangan {
                width: 100%;
                margin-bottom: 16px;
            }
            .kolom.pernyataan {
                 font-size: 1.2em;
                background: #e3f2fd;
            }
            .kolom.pasangan {
                background: #fffde7;
            }
            .kolom.pasangan .item {
                font-size: 1.2em;
        }
            .kolom h3 {
                font-size: 1.1em;
            }
            .item {
                padding: 8px 6px;
                font-size: 0.95em;
            }
            .item:hover:not(.disabled):not(.selected) {
                box-shadow: 0 1px 4px rgba(25, 118, 210, 0.1);
                background: #e3f2fd;
                border-color: #1976d2;
            }
            .item.selected {
                outline: 2px solid #1976d2;
                background: #bbdefb !important;
            }
            .item.disabled {
                opacity: 0.5;
                pointer-events: none;
                text-decoration: line-through;
                filter: grayscale(0.3);
            }
            .kolom h3 {
                margin-bottom: 12px;
            }
            .user-info {
                margin-bottom: 12px;
                font-size: 0.9em;
                text-align: center;
            }
            .kolom.pernyataan, .kolom.pasangan {
                width: 100%;
                margin-bottom: 16px;
            }
            .kolom.pernyataan {
                background: #e3f2fd;
            }
            .kolom.pasangan {
                background: #fffde7;
            }
            .kolom h3 {
                font-size: 1.1em;
            }
            .item {
                padding: 8px 6px;
                font-size: 0.95em;
            }
            .item:hover:not(.disabled):not(.selected) {
                box-shadow: 0 1px 4px rgba(25, 118, 210, 0.1);
                background: #e3f2fd;
                border-color: #1976d2;
            }
            .item.selected {
                outline: 2px solid #1976d2;
                background: #bbdefb !important;
            }
            .item.disabled {
                opacity: 0.5;
                pointer-events: none;
                text-decoration: line-through;
                filter: grayscale(0.3);
            }
            .kolom h3 {
                margin-bottom: 12px;
            }
            .user-info {
                margin-bottom: 12px;
                font-size: 0.9em;
                text-align: center;
            }
            .kolom.pernyataan, .kolom.pasangan {
                width: 100%;
                margin-bottom: 16px;
            }
            .kolom.pernyataan {
                background: #e3f2fd;
            }
            .kolom.pasangan {
                background: #fffde7;
            }
            .kolom h3 {
                font-size: 1.1em;
            }
            .item {
                padding: 8px 6px;
                font-size: 0.95em;
            }
            .kolom {
                padding: 10px 4px;
            }
            .submit-btn {
                width: 50%;
                font-size: 1em;
            }
        }
    </style>
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            document.getElementById("formJawaban").addEventListener("submit", function(event) {
                event.preventDefault();
                if (Object.keys(jawabanSiswa).length === 0) {
                    alert("Silakan pilih pasangan terlebih dahulu.");
                    return;
                }
                this.submit();
            });
        });
    </script>
</head>
<body>
    <div class="container">
        <div style="width:100%">
                    <div class="user-info">Soal Menjodohkan - User: <b><?= htmlspecialchars($user) ?></b></div>
        
        
            <h2><?= htmlspecialchars($judul) ?></h2>
            <br>
            <?php if (!empty($gambar)): ?>
                <img src="<?= htmlspecialchars($gambar) ?>" class="gambar-soal"><br>
            <?php endif; ?>
            <p><?= nl2br(htmlspecialchars($pertanyaan)) ?></p>
            <form method="post" id="formJawaban">
                <div style="display:flex;gap:32px;justify-content:center;">
                    <div class="kolom pernyataan" id="kolom-soal">
                        <h3>Pernyataan</h3>
                        <?php foreach ($kolom_kiri as $no => $teks): ?>
                            <div class="item"
                                onclick="pilihSoal('<?= $no ?>')"
                                id="soal-<?= $no ?>"
                                data-default="#fff"
                                style="background:#fff;">
                                <?= htmlspecialchars($teks) ?>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    <div class="kolom pasangan" id="kolom-jawaban">
                        <h3>Pasangan</h3>
                        <?php
                        $i = 0;
                        foreach ($kolom_kanan as $kode => $teks):
                            $warna = $warna_pilihan[$i % count($warna_pilihan)];
                        ?>
                            <div class="item"
                                onclick="pilihJawaban('<?= $kode ?>')"
                                id="jawaban-<?= $kode ?>"
                                data-warna="<?= $warna ?>"
                                style="background:<?= $warna ?>;">
                                <?= htmlspecialchars($teks) ?>
                            </div>
                        <?php $i++; endforeach; ?>
                    </div>
                </div>
                <input type="hidden" name="jawaban" id="jawabanData">
                <button type="submit" class="submit-btn">Kirim Jawaban</button>
                <button type="button" class="submit-btn" style="background:#fff;color:#1976d2;border:2px solid #1976d2;margin-top:12px;" onclick="resetJawaban()">Reset</button>
            </form>
        </div>
    </div>
    <script>
        let soalTerpilih = null;
        let jawabanSiswa = {};

        function pilihSoal(no) {
            soalTerpilih = no;
            document.querySelectorAll('#kolom-soal .item').forEach(el => el.classList.remove('selected'));
            document.getElementById('soal-' + no).classList.add('selected');
        }

        function pilihJawaban(kode) {
            if (soalTerpilih === null) {
                alert("Pilih pernyataan dulu!");
                return;
            }
            let warna = document.getElementById('jawaban-' + kode).getAttribute('data-warna');
            jawabanSiswa[soalTerpilih] = kode;
            document.getElementById('jawabanData').value = JSON.stringify(jawabanSiswa);

            let soalBox = document.getElementById('soal-' + soalTerpilih);
            soalBox.classList.remove('selected');
            soalBox.classList.add('disabled');
            soalBox.style.background = warna;

            let pasanganBox = document.getElementById('jawaban-' + kode);
            pasanganBox.classList.add('disabled');
            pasanganBox.style.background = warna;

            soalTerpilih = null;
        }

        function resetJawaban() {
            document.querySelectorAll('#kolom-soal .item').forEach(el => {
                el.classList.remove('selected', 'disabled');
                el.style.background = el.getAttribute('data-default') || '#fff';
            });
            document.querySelectorAll('#kolom-jawaban .item').forEach(el => {
                el.classList.remove('disabled');
                el.style.background = el.getAttribute('data-warna');
            });
            jawabanSiswa = {};
            document.getElementById('jawabanData').value = '';
            soalTerpilih = null;
        }
    </script>