<?php
session_start();
if (!isset($_SESSION["user"])) {
    header("Location: login.php");
    exit;
}
$user = $_SESSION["user"];

// Koneksi ke database
$conn = new mysqli("localhost", "lnibbicy_kka4", "magetan#2", "lnibbicy_kka4");
if ($conn->connect_error) {
    die("Koneksi gagal: " . $conn->connect_error);
}

// Fungsi untuk mendapatkan data soal dan jawaban dalam format yang mudah dibaca
function getSoalData($conn, $user) {
    $data = [];
    
    // 1. Soal Ganda B - Tampilkan pertanyaan dan semua pilihan
    $query_ganda = "SELECT sg.pertanyaan, sg.opsi_1, sg.opsi_2, sg.opsi_3, sg.opsi_4, 
                           sg.jawaban_benar, hg.jawaban_user 
                    FROM ganda_b sg 
                    LEFT JOIN hasil_ganda_b hg ON sg.id = hg.id_soal AND hg.username = '$user'";
    $result_ganda = $conn->query($query_ganda);
    if ($result_ganda) {
        $data['ganda'] = $result_ganda->fetch_all(MYSQLI_ASSOC);
    }
    
    // 2. Soal Komplek - Tampilkan pertanyaan dan jenis pilihan
    $query_komplek = "SELECT ks.pertanyaan, ks.jawaban_benar, hk.jawaban_user 
                      FROM komplek_soal ks 
                      LEFT JOIN hasil_komplek hk ON ks.id = hk.id_soal AND hk.username = '$user'";
    $result_komplek = $conn->query($query_komplek);
    if ($result_komplek) {
        $data['komplek'] = $result_komplek->fetch_all(MYSQLI_ASSOC);
    }
    
    // 3. Soal Jodoh - Tampilkan kolom kiri dan kanan
    $query_jodoh = "SELECT js.judul, js.kolom_kiri, js.kolom_kanan, js.jawaban_benar, hj.jawaban_user 
                    FROM jodoh_soal js 
                    LEFT JOIN hasil_jodoh hj ON js.id = hj.id_soal AND hj.username = '$user'";
    $result_jodoh = $conn->query($query_jodoh);
    if ($result_jodoh) {
        $data['jodoh'] = $result_jodoh->fetch_all(MYSQLI_ASSOC);
    }
    
    // 4. Soal Benar Salah - Tampilkan pernyataan
    $query_bs = "SELECT bs.pernyataan, bs.jawaban_benar, hbs.jawaban_user 
                 FROM benar_salah bs 
                 LEFT JOIN hasil_bs hbs ON bs.id = hbs.id_soal AND hbs.username = '$user'";
    $result_bs = $conn->query($query_bs);
    if ($result_bs) {
        $data['bs'] = $result_bs->fetch_all(MYSQLI_ASSOC);
    }
    
    return $data;
}

$soalData = getSoalData($conn, $user);
$conn->close();
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Jawaban Peserta - <?= htmlspecialchars($user) ?></title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Open Sans', 'Comic Sans MS', Arial;
            background: linear-gradient(135deg, #1e3c72 0%, #2a5298 100%);
            color: #333;
            line-height: 1.6;
            padding: 20px;
            min-height: 100vh;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            background: white;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
            overflow: hidden;
        }
        
        .header {
            background: linear-gradient(135deg, #138c19ff 0%, #020b14ff 100%);
            color: white;
            padding: 30px;
            text-align: center;
        }
        
        .header h1 {
            font-size: 2.5em;
            margin-bottom: 10px;
            font-weight: 300;
        }
        
        .header p {
            font-size: 1.2em;
            opacity: 0.9;
        }
        
        .content {
            padding: 30px;
        }
        
        .section {
            margin-bottom: 40px;
            border: 2px solid #e0e0e0;
            border-radius: 10px;
            overflow: hidden;
        }
        
        .section-header {
            background: linear-gradient(135deg, #3498db 0%, #2980b9 100%);
            color: white;
            padding: 20px;
            font-size: 1.3em;
            font-weight: 600;
        }
        
        .soal-item {
            padding: 25px;
            border-bottom: 1px solid #eee;
            background: #fafafa;
        }
        
        .soal-item:last-child {
            border-bottom: none;
        }
        
        .soal-item:hover {
            background: #f0f8ff;
        }
        
        .pertanyaan {
            font-size: 1.1em;
            font-weight: 500;
            margin-bottom: 15px;
            color: #2c3e50;
        }
        
        .pilihan {
            margin: 10px 0;
            padding-left: 20px;
        }
        
        .pilihan-item {
            margin: 5px 0;
            padding: 5px;
        }
        
        .jawaban-container {
            margin-top: 15px;
            padding: 15px;
            background: #f8f9fa;
            border-radius: 8px;
            border-left: 4px solid #007bff;
        }
        
        .jawaban-user {
            font-weight: 600;
            color: #28a745;
        }
        
        .jawaban-benar {
            font-weight: 600;
            color: #dc3545;
        }
        
        .status {
            display: inline-block;
            padding: 5px 10px;
            border-radius: 20px;
            font-weight: 600;
            margin-top: 10px;
        }
        
        .status-benar {
            background: #d4edda;
            color: #155724;
        }
        
        .status-salah {
            background: #f8d7da;
            color: #721c24;
        }
        
        .kolom-container {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
            margin-top: 15px;
        }
        
        .kolom {
            padding: 15px;
            background: #f8f9fa;
            border-radius: 8px;
            border: 1px solid #dee2e6;
        }
        
        .kolom-item {
            padding: 10px;
            margin: 8px 0;
            background: white;
            border: 1px solid #ddd;
            border-radius: 5px;
        }
        
        .empty-state {
            text-align: center;
            padding: 40px;
            color: #7f8c8d;
            font-style: italic;
        }
        
        @media (max-width: 768px) {
            .kolom-container {
                grid-template-columns: 1fr;
            }
            
            .header h1 {
                font-size: 2em;
            }
            
            .content {
                padding: 20px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>📝 SOAL</h1>
            <p>User: <strong><?= htmlspecialchars($user) ?></strong></p>
        </div>
        
        <div class="content">
            <!-- Soal Ganda B -->
            <div class="section">
                <div class="section-header">Soal Pilihan Ganda</div>
                <?php if (!empty($soalData['ganda'])): ?>
                    <?php foreach ($soalData['ganda'] as $index => $soal): ?>
                        <div class="soal-item">
                            <div class="pertanyaan"><?= ($index + 1) . '. ' . htmlspecialchars($soal['pertanyaan']) ?></div>
                                                 
                            
                            
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <div class="empty-state">Belum ada data soal pilihan ganda</div>
                <?php endif; ?>
            </div>

            <!-- Soal Komplek -->
    <div class="section-header">Soal Kompleks</div>

<?php if (!empty($soalData['komplek'])): ?>
    
    <?php foreach ($soalData['komplek'] as $index => $soal): ?>
        <div class="soal-item"> 
            <div class="pertanyaan"><?= ($index + 1) . '. ' . htmlspecialchars($soal['pertanyaan']) ?></div>
            
        </div>
    <?php endforeach; ?>
<?php else: ?>
    <div class="empty-state">Belum ada data soal kompleks</div>
<?php endif; ?>
            </div>


    
            <!-- Soal Jodoh -->
            <div class="section">
                <div class="section-header">Soal Menjodohkan</div>
                <?php if (!empty($soalData['jodoh'])): ?>
                    <?php foreach ($soalData['jodoh'] as $index => $soal): 
                        $kolom_kiri = json_decode($soal['kolom_kiri'], true);
                        $kolom_kanan = json_decode($soal['kolom_kanan'], true);
                        $jawaban_benar = json_decode($soal['jawaban_benar'], true);
                        $jawaban_user = json_decode($soal['jawaban_user'], true);
                    ?>
                        <div class="soal-item">
                            <div class="pertanyaan"><?= ($index + 1) . '. ' . htmlspecialchars($soal['judul']) ?></div>
                            
                            <div class="kolom-container">
                                <div class="kolom">
                                    <strong>Pernyataan:</strong>
                                    <?php if (is_array($kolom_kiri)): ?>
                                        <?php foreach ($kolom_kiri as $key => $value): ?>
                                            <div class="kolom-item"><?= $key . '. ' . htmlspecialchars($value) ?></div>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </div>
                                
                                <div class="kolom">
                                    <strong>Pasangan:</strong>
                                    <?php if (is_array($kolom_kanan)): ?>
                                        <?php foreach ($kolom_kanan as $key => $value): ?>
                                            <div class="kolom-item"><?= $key . '. ' . htmlspecialchars($value) ?></div>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </div>
                            </div>
                            
                            
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <div class="empty-state">Belum ada data soal menjodohkan</div>
                <?php endif; ?>
            </div>

            <!-- Soal Benar Salah -->
            <div class="section">
                <div class="section-header">Soal Benar Salah</div>
                <?php if (!empty($soalData['bs'])): ?>
                    <?php foreach ($soalData['bs'] as $index => $soal): ?>
                        <div class="soal-item">
                            <div class="pertanyaan"><?= ($index + 1) . '. ' . htmlspecialchars($soal['pernyataan']) ?></div>
                            
                            </div>
                    
                    <?php endforeach; ?>
                <?php else: ?>
                    <div class="empty-state">Belum ada data soal benar salah</div>
                <?php endif; ?>
            </div>
        

        <div style="margin-top:10px;margin-bottom:15px;text-align:center;">
    <a href="login.php" class="back-button" style="
        display: inline-flex;
        align-items: center;
        justify-content: center;
        padding: 13px 30px;
        background: linear-gradient(135deg, #1e2be2ff 0%, #2114d5ff 100%);
        color: white;
        text-decoration: none;
        border-radius: 8px;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        font-weight: 600;
        font-size: 15px;
        border: none;
        cursor: pointer;
        transition: all 0.3s ease;
        gap: 8px;
        box-shadow: 0 4px 15px rgba(1, 0, 2, 0.63);
        position: relative;
        overflow: hidden;
    ">
        <span style="position: relative; z-index: 2;">⮌ Kembali ke Login</span>
        <span style="
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
            transition: left 0.5s ease;
        "></span>
    </a>
    </div>
</div>

<script>
    // Tambahkan efek hover untuk animasi shine
    document.querySelector('.back-button').addEventListener('mouseenter', function() {
        this.style.transform = 'translateY(-2px)';
        this.style.boxShadow = '0 6px 20px rgba(66, 165, 245, 0.4)';
        this.querySelector('span:last-child').style.left = '100%';
    });
    
    document.querySelector('.back-button').addEventListener('mouseleave', function() {
        this.style.transform = 'translateY(0)';
        this.style.boxShadow = '0 4px 15px rgba(66, 165, 245, 0.3)';
        this.querySelector('span:last-child').style.left = '-100%';
    });
</script>

    </div>
</body>
</html>

