<?php
function tokenizeSentences($text) {
    // Pisahkan berdasarkan titik, tanda seru, atau tanda tanya
    return preg_split('/(?<=[.?!])\s+/', $text, -1, PREG_SPLIT_NO_EMPTY);
}

function calculateSimilarity($text1, $text2) {
    $words1 = explode(" ", strtolower($text1));
    $words2 = explode(" ", strtolower($text2));

    $allWords = array_unique(array_merge($words1, $words2));
    $vec1 = [];
    $vec2 = [];

    foreach ($allWords as $word) {
        $vec1[] = count(array_keys($words1, $word));
        $vec2[] = count(array_keys($words2, $word));
    }

    $dotProduct = array_sum(array_map(function($a, $b) {
        return $a * $b;
    }, $vec1, $vec2));

    $magnitude1 = sqrt(array_sum(array_map(function($a) {
        return $a * $a;
    }, $vec1)));

    $magnitude2 = sqrt(array_sum(array_map(function($b) {
        return $b * $b;
    }, $vec2)));

    if ($magnitude1 == 0 || $magnitude2 == 0) return 0;

    return round($dotProduct / ($magnitude1 * $magnitude2), 2);
}

function correctEssay($question, $answer) {
    $similarity = calculateSimilarity($question, $answer);
    $sentences = tokenizeSentences($answer);
    $words = explode(" ", $answer);
    $clarityScore = round(count($sentences) / max(count($words), 1), 2);

    // Penilaian akhir sederhana
    $finalScore = round(($similarity + $clarityScore) / 2 * 100, 2);

    echo "📋 Hasil Koreksi Esai:\n";
    echo "- Relevansi terhadap pertanyaan: $similarity (0–1)\n";
    echo "- Kejelasan (rasio kalimat/kata): $clarityScore\n";
    echo "✅ Skor Akhir: $finalScore / 100\n";
}

// Contoh penggunaan
$question = "Jelaskan dampak revolusi industri terhadap kehidupan masyarakat Eropa.";
$answer = "Revolusi industri membawa perubahan besar dalam kehidupan masyarakat Eropa. Banyak orang pindah ke kota untuk bekerja di pabrik, dan terjadi urbanisasi yang pesat. Namun, kondisi kerja sering buruk dan eksploitasi meningkat.";

correctEssay($question, $answer);
?>