<?php
// --- PROSES SIMPAN SOAL ---
$pesan = "";
$mysqli = new mysqli("localhost", "lnibbicy_kka4", "magetan#2", "lnibbicy_kka4");
if ($mysqli->connect_error) {
    die("Koneksi gagal: " . $mysqli->connect_error);
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (isset($_POST['hapus_semua'])) {
        // Hapus semua data komplek_soal
        $del = $mysqli->query("DELETE FROM komplek_soal");
        if ($del) {
            $pesan = "<span style='color:green;'>Seluruh data soal berhasil dihapus!</span>";
        } else {
            $pesan = "<span style='color:red;'>Gagal menghapus data: " . $mysqli->error . "</span>";
        }
    } else {
        // ...existing code...
        $judul = trim($_POST["judul"]);
        $pertanyaan = trim($_POST["pertanyaan"]);
        $tanya = trim($_POST["tanya"]);

        $opsi = [
            trim($_POST["jawaban1"]),
            trim($_POST["jawaban2"]),
            trim($_POST["jawaban3"]),
            trim($_POST["jawaban4"])
        ];

        $jawaban_benar = isset($_POST["jawaban_benar"]) ? $_POST["jawaban_benar"] : [];
        $jawaban_benar_str = implode(",", $jawaban_benar);

        // Pastikan skor adalah integer dan valid
        $skor1 = isset($_POST["skor1"]) ? intval($_POST["skor1"]) : 0;
        $skor2 = isset($_POST["skor2"]) ? intval($_POST["skor2"]) : 0;
        $skor3 = isset($_POST["skor3"]) ? intval($_POST["skor3"]) : 0;
        $skor4 = isset($_POST["skor4"]) ? intval($_POST["skor4"]) : 0;
        // Tambahkan input skor_k
        $skor_k = isset($_POST["skor_k"]) ? intval($_POST["skor_k"]) : 0;

        // Upload gambar jika ada
        $gambar = "";
        if (isset($_FILES['gambar']) && $_FILES['gambar']['error'] !== UPLOAD_ERR_NO_FILE) {
            if ($_FILES['gambar']['error'] !== 0) {
                die("Error upload file: " . $_FILES['gambar']['error']);
            }
            $target_dir = "uploads/";
            if (!is_dir($target_dir)) {
                mkdir($target_dir, 0777, true);
            }
            $ext = strtolower(pathinfo($_FILES['gambar']['name'], PATHINFO_EXTENSION));
            $allowed_ext = ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp'];
            if (!in_array($ext, $allowed_ext)) {
                die("Format file tidak diperbolehkan.");
            }
            $nama_file = "soal_" . time() . "_" . rand(100,999) . "." . $ext;
            $target_file = $target_dir . $nama_file;
            if (move_uploaded_file($_FILES['gambar']['tmp_name'], $target_file)) {
                $gambar = $target_file;
            } else {
                die("Gagal memindahkan file.");
            }
        }

        // Prepare dan bind parameter
        $stmt = $mysqli->prepare("INSERT INTO komplek_soal (judul, pertanyaan, tanya, gambar, jawaban1, jawaban2, jawaban3, jawaban4, jawaban_benar, skor1, skor2, skor3, skor4, skor_k) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        if ($stmt) {
            // Urutan dan tipe data: s=string, i=integer
            $stmt->bind_param(
                "ssssssssssiiii",
                $judul,
                $pertanyaan,
                $tanya,
                $gambar,
                $opsi[0],
                $opsi[1],
                $opsi[2],
                $opsi[3],
                $jawaban_benar_str,
                $skor1,
                $skor2,
                $skor3,
                $skor4,
                $skor_k
            );
            if ($stmt->execute()) {
                $pesan = "<span style='color:green;'>Soal berhasil ditambahkan!</span>";
            } else {
                $pesan = "<span style='color:red;'>Gagal menambah soal: " . htmlspecialchars($stmt->error) . "</span>";
            }
            $stmt->close();
        } else {
            $pesan = "<span style='color:red;'>Query error: " . htmlspecialchars($mysqli->error) . "</span>";
        }
    }
}
?>


<!DOCTYPE html>
<html lang="id">
<head>
    
    <meta charset="UTF-8">
    <title>Input Soal Pilihan Ganda Kompleks</title>
    <style>
        body {
            min-height: 100vh;
            margin: 0;
            padding: 0;
            font-family: 'Segoe UI', Arial, sans-serif;
            background: linear-gradient(120deg, #e0f7fa 0%, #80deea 100%);
            color: #333;
            display: flex;
            align-items: flex-start;
            justify-content: center;
        }
        .container-insert {
            background: #fff;
            width: 100%;
            max-width: 520px;
            margin: 40px 16px;
            border-radius: 18px;
            box-shadow: 0 8px 32px rgba(0,0,0,0.13);
            padding: 36px 24px 28px 24px;
            box-sizing: border-box;
            transition: box-shadow 0.2s;
        }
        .container-insert:hover {
            box-shadow: 0 12px 40px rgba(0,0,0,0.18);
        }
        h2 {
            color: #1976d2;
            text-align: center;
            margin-bottom: 22px;
            letter-spacing: 1px;
            font-size: 1.45em;
        }
        label {
            font-weight: 600;
            color: #1976d2;
            margin-top: 10px;
            margin-bottom: 6px;
            display: block;
        }
        .msg {
            text-align: center;
            margin-bottom: 20px;
            font-size: 1.1em;
            color: #333;
        }
        .msg span {
            font-weight: bold;
        }
        form {
            display: flex;
            flex-direction: column;
            align-items: stretch;
            width: 100%;
            box-sizing: border-box;
        }
        .opsi-row {
            display: flex;
            align-items: center;
            margin-bottom: 14px;
            background: #f7fbff;
            padding: 10px 8px;
            border-radius: 8px;
            box-shadow: 0 2px 8px #1976d21a;
        }
        .opsi-row input[type="checkbox"] {
            margin-right: 10px;
            accent-color: #1976d2;
        }
        .opsi-row input[type="text"], .opsi-row input[type="number"] {
            flex: 1;
            margin-right: 10px;
            padding: 8px 10px;
            border: 1px solid #b3c6e0;
            border-radius: 6px;
            font-size: 1em;
            background: #f7fbff;
            transition: border 0.2s;
            max-width: 180px;
            min-width: 0;
            box-sizing: border-box;
        }
        .opsi-row input[type="text"]:focus, .opsi-row input[type="number"]:focus {
            border: 1.5px solid #1976d2;
            outline: none;
        }
        .opsi-row span {
            margin-right: 10px;
            color: #1976d2;
            font-weight: 500;
        }
        button[type="submit"], button[type="button"] {
            background: linear-gradient(90deg, #1976d2 60%, #64b5f6 100%);
            color: #fff;
            border: none;
            border-radius: 8px;
            padding: 12px 20px;
            font-size: 1.1em;
            font-weight: 600;
            cursor: pointer;
            margin-top: 18px;
            box-shadow: 0 2px 8px #1976d233;
            transition: background 0.2s, box-shadow 0.2s;
        }
        button[type="submit"]:hover, button[type="button"]:hover {
            background: linear-gradient(90deg, #1565c0 60%, #1976d2 100%);
            box-shadow: 0 4px 16px #1976d244;
        }
        input[type="file"] {
            margin: 6px 0 12px 0;
        }
        @media (max-width: 600px) {
            .container-insert {
                padding: 18px 4vw 16px 4vw;
            }
            textarea, input[type="text"], input[type="number"], input[type="file"] {
                width: 100%;
            }
            .opsi-row input[type="text"], .opsi-row input[type="number"] {
                width: 100%;
                margin-right: 0;
            }
            button[type="submit"], button[type="button"] {
                width: 100%;
                padding: 12px;
            }
            .opsi-row {
                flex-direction: column;
                align-items: stretch;
                gap: 6px;
            }
        }
    </style>
</head>
<body>
    <div class="container-insert">
        <h2>Input Soal Pilihan Ganda (Jawaban Bisa Lebih dari Satu & Skor Berbeda)</h2>
        <div class="msg"><?= $pesan ?></div>
    <form method="post" enctype="multipart/form-data">
            <label>Judul:</label>
            <input type="text" name="judul" required placeholder="Masukkan Judul Soal">
            
            <label>Pertanyaan:</label>
            <textarea name="pertanyaan" required rows="3" placeholder="Masukkan Pertanyaan"></textarea>

            <label>Tanya:</label>
            <textarea name="tanya" required rows="3" placeholder="Masukkan Tanya"></textarea>
            
            <label>Gambar (opsional):</label>
            <input type="file" name="gambar" accept="image/*"><br>
            
            <div class="opsi-row">
                <input type="checkbox" name="jawaban_benar[]" value="1" id="benar1">
                <label for="benar1" style="margin:0;">Jawaban 1:</label>
                <input type="text" name="jawaban1" required placeholder="Jawaban 1">
                <span>Skor:</span>
                <input type="number" name="skor1" value="0" required>
            </div>
            
            <div class="opsi-row">
                <input type="checkbox" name="jawaban_benar[]" value="2" id="benar2">
                <label for="benar2" style="margin:0;">Jawaban 2:</label>
                <input type="text" name="jawaban2" required placeholder="Jawaban 2">
                <span>Skor:</span>
                <input type="number" name="skor2" value="0" required>
            </div>
            
            <div class="opsi-row">
                <input type="checkbox" name="jawaban_benar[]" value="3" id="benar3">
                <label for="benar3" style="margin:0;">Jawaban 3:</label>
                <input type="text" name="jawaban3" required placeholder="Jawaban 3">
                <span>Skor:</span>
                <input type="number" name="skor3" value="0" required>
            </div>
            
            <div class="opsi-row">
                <input type="checkbox" name="jawaban_benar[]" value="4" id="benar4">
                <label for="benar4" style="margin:0;">Jawaban 4:</label>
                <input type="text" name="jawaban4" required placeholder="Jawaban 4">
                <span>Skor:</span>
                <input type="number" name="skor4" value="0" required>
            </div>

            <label>Skor Komplek (skor_k):</label>
            <input type="number" name="skor_k" value="0" required>
            
            <button type="submit">Simpan Soal</button>
        </form>
        <form method="post" onsubmit="return confirm('Yakin ingin menghapus semua data soal?');" style="margin-top:18px; text-align:center;">
            <input type="hidden" name="hapus_semua" value="1">
            <button type="submit" style="background:#d32f2f; color:#fff; border:none; border-radius:8px; padding:10px 32px; font-size:1.1em; font-weight:500; cursor:pointer;">Hapus Semua Data</button>
        </form>
    </div>
</body>
</html>