<?php
    ?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>KKA</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            margin: 0;
            padding: 0;
            height: 100vh;
            overflow: hidden;
            font-family: 'Segoe UI', 'Open Sans', 'Comic Sans MS', Arial, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }

        .background {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 50%, #f093fb 100%);
            background-size: 400% 400%;
            animation: gradientShift 15s ease infinite;
            z-index: -1;
        }

        @keyframes gradientShift {
            0% {
                background-position: 0% 50%;
            }
            50% {
                background-position: 100% 50%;
            }
            100% {
                background-position: 0% 50%;
            }
        }

        .background::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-image: 
                radial-gradient(circle at 20% 80%, rgba(255, 255, 255, 0.1) 0%, transparent 50%),
                radial-gradient(circle at 80% 20%, rgba(255, 255, 255, 0.1) 0%, transparent 50%);
            animation: floatCircles 20s ease-in-out infinite;
        }

        @keyframes floatCircles {
            0%, 100% {
                transform: translate(0, 0);
            }
            25% {
                transform: translate(10px, -20px);
            }
            50% {
                transform: translate(-10px, 10px);
            }
            75% {
                transform: translate(20px, 5px);
            }
        }

        .home-menu {
            position: relative;
            z-index: 1;
            text-align: center;
            color: white;
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(50px);
            -webkit-backdrop-filter: blur(50px);
            padding: 50px;
            border-radius: 20px;
            box-shadow: 0 8px 32px rgba(31, 38, 135, 0.37);
            border: 1px solid rgba(255, 255, 255, 0.18);
            width: 100%;
            height: 100%;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            margin: 0;
            transition: all 0.4s ease;
        }

        h2 {
            color: #fff;
            text-align: center;
            margin-bottom: 10px;
            font-size: 1.5em;
            font-weight: 300;
            letter-spacing: 2px;
            text-transform: uppercase;
        }

        h1 {
            color: #fff;
            text-align: center;
            margin-bottom: 20px;
            font-size: 3em;
            font-weight: 700;
            text-shadow: 0 4px 15px rgba(0, 0, 0, 0.3);
            letter-spacing: 1px;
        }

        p {
            color: rgba(255, 255, 255, 0.9);
            font-size: 1.1em;
            margin-bottom: 30px;
            font-weight: 300;
        }

        .buttons-container {
            display: flex;
            gap: 15px;
            justify-content: center;
            flex-wrap: wrap;
            margin-bottom: 40px;
        }

        .login-btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            margin: 0;
            padding: 14px 35px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            text-decoration: none;
            border-radius: 50px;
            font-size: 1em;
            font-weight: 600;
            transition: all 0.4s ease;
            border: 2px solid rgba(255, 255, 255, 0.3);
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
            cursor: pointer;
        }

        .login-btn:hover {
            background: linear-gradient(135deg, #764ba2 0%, #667eea 100%);
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(102, 126, 234, 0.6);
            border-color: rgba(255, 255, 255, 0.6);
        }

        .login-btn:active {
            transform: translateY(-2px);
        }

        .footer-text {
            color: rgba(255, 255, 255, 0.8);
            font-size: 0.9em;
            margin-top: 20px;
            font-weight: 300;
        }

        .footer-text p {
            margin: 5px 0;
        }

        /* Desktop - 1024px dan lebih */
        @media (min-width: 1024px) {
            h1 {
                font-size: 3.5em;
            }

            h2 {
                font-size: 1.9em;
            }

            .home-menu {
                padding: 60px;
            }

            .buttons-container {
                gap: 20px;
            }

            .login-btn {
                padding: 16px 40px;
                font-size: 1.1em;
            }
        }

        /* Tablet - 768px sampai 1023px */
        @media (min-width: 768px) and (max-width: 1023px) {
            h1 {
                font-size: 2.8em;
            }

            h2 {
                font-size: 1.6em;
            }

            .home-menu {
                padding: 45px;
            }

            .buttons-container {
                gap: 15px;
            }

            .login-btn {
                padding: 12px 30px;
                font-size: 1em;
            }
        }

        /* Mobile - di bawah 768px */
        @media (max-width: 767px) {
            body {
                height: 100vh;
            }

            .background {
                filter: blur(8px) brightness(0.75);
            }

            .home-menu {
                padding: 30px 20px;
                width: 100%;
                height: 100%;
                margin: 0;
                border-radius: 0;
            }

            h1 {
                font-size: 2em;
                margin-bottom: 10px;
            }

            h2 {
                font-size: 1.2em;
                margin-bottom: 8px;
            }

            p {
                font-size: 0.95em;
                margin-bottom: 15px;
            }

            .buttons-container {
                flex-direction: column;
                gap: 10px;
                width: 100%;
            }

            .login-btn {
                display: flex;
                width: 100%;
                margin: 0;
                padding: 14px 15px;
                font-size: 1em;
            }

            .footer-text {
                font-size: 0.85em;
                margin-top: 15px;
            }
        }

        /* Smartphone kecil - di bawah 480px */
        @media (max-width: 479px) {
            .home-menu {
                padding: 20px 15px;
                width: 100%;
                height: 100%;
                margin: 0;
                border-radius: 0;
            }

            h1 {
                font-size: 1.6em;
                margin-bottom: 8px;
            }

            h2 {
                font-size: 1em;
                margin-bottom: 5px;
            }

            p {
                font-size: 0.9em;
                margin-bottom: 12px;
            }

            .buttons-container {
                flex-direction: column;
                gap: 8px;
                width: 100%;
            }

            .login-btn {
                display: flex;
                width: 100%;
                margin: 0;
                padding: 12px 10px;
                font-size: 0.95em;
            }

            .footer-text {
                font-size: 0.8em;
                margin-top: 12px;
            }
        }
    </style>
</head>
<body>
    <div class="background"></div>
    <div class="home-menu">
        <h2>SUMATIF SEMESTER I</h2>
        <h1>KODING DAN KECERDASAN ARTIFISIAL/ KKA</h1>
        <p>Silakan pilih login sebagai siswa atau admin</p>
        <div class="buttons-container">
            <a href="login.php" class="login-btn">👩‍🏫 Login Siswa</a>
            <a href="admin.php" class="login-btn">🔐 Login Admin</a>
        </div>
        <div class="footer-text">
            <p>Dibuat oleh TIM IT SD Negeri Magetan 2</p>
            <p>© Tahun 2025</p>
        </div>

    </div>
</body>
</html>
