<?php
// Template cetak laporan untuk generate_pdf.php
// Ambil variabel yang sama seperti di cetak.php
if (!isset($user)) $user = '';
if (!isset($user_data)) $user_data = [];
if (!isset($skor_ganda)) $skor_ganda = 0;
if (!isset($skor_komplek)) $skor_komplek = 0;
if (!isset($skor_jodoh)) $skor_jodoh = 0;
if (!isset($skor_bs)) $skor_bs = 0;
if (!isset($total_skor)) $total_skor = 0;
if (!isset($nilai_akhir)) $nilai_akhir = 0;
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Laporan AKM</title>
    <style>
        body { font-family: Arial, sans-serif; }
        h1, h2 { text-align: center; color: #1976d2; }
        .container { max-width: 900px; margin: 0 auto; background: #fff; padding: 20px; border-radius: 10px; }
        .rekap { width: 100%; margin: 20px auto; border: 1px solid #1976d2; border-collapse: collapse; border-radius: 8px; overflow: hidden; }
        .rekap th, .rekap td { padding: 12px; text-align: left; }
        .rekap th { background: #1976d2; color: #fff; }
        .rekap td { background: #f7fbff; }
        .rekap tr:nth-child(even) td { background: #e9f7ff; }
        .rekap-total { font-weight: bold; color: #1976d2; }
        .rekap-nilai { font-size: 1.3em; color: #388e3c; font-weight: bold; }
        table.result { width: 100%; margin: 20px 0; border-collapse: collapse; }
        table.result th, table.result td { padding: 10px; border: 1px solid #ccc; }
        table.result th { background: #ddd; }
        .section { margin-bottom: 40px; }
    </style>
</head>
<body>
    <div class="container">
        <h1>Laporan Detail Peserta</h1>
        <?php if ($user_data): ?>
            <table class="rekap" style="margin-bottom: 30px;">
                <tr><th>Nama</th><td><?= htmlspecialchars($user_data['nama']) ?></td></tr>
                <tr><th>Tempat Lahir</th><td><?= htmlspecialchars($user_data['tempat_lahir']) ?></td></tr>
                <tr><th>Tanggal Lahir</th><td><?= htmlspecialchars($user_data['tanggal_lahir']) ?></td></tr>
                <tr><th>Kelas</th><td><?= htmlspecialchars($user_data['kelas']) ?></td></tr>
                <tr><th>Absensi</th><td><?= htmlspecialchars($user_data['absensi']) ?></td></tr>
            </table>
        <?php else: ?>
            <p>Data pengguna tidak ditemukan.</p>
        <?php endif; ?>
        <h2>User / Pengguna: <?= htmlspecialchars($user) ?></h2>
        <table class="rekap">
            <tr><th>Kategori</th><th>Skor</th></tr>
            <tr><td>Pilihan Ganda Biasa</td><td><?= $skor_ganda ?></td></tr>
            <tr><td>Pilihan Ganda Komplek</td><td><?= $skor_komplek ?></td></tr>
            <tr><td>Menjodohkan</td><td><?= $skor_jodoh ?></td></tr>
            <tr><td>Pernyataan Benar/Salah</td><td><?= $skor_bs ?></td></tr>
            <tr class="rekap-total"><td>Jumlah Skor</td><td><?= $total_skor ?></td></tr>
            <tr class="rekap-nilai"><td>Nilai</td><td><?= $nilai_akhir ?></td></tr>
        </table>
        <!-- Laporan detail per kategori soal -->
        <div class="section">
            <h2>Pilihan Ganda Biasa</h2>
            <?php
            $sql = "SELECT h.skor, h.jawaban_user, h.waktu FROM hasil_ganda_b h WHERE h.username = '$user' ORDER BY h.waktu ASC";
            $result = $mysqli->query($sql);
            if($result && $result->num_rows > 0) {
                echo "<table class='result'>";
                echo "<tr><th>No</th><th>Jawaban Anda</th><th>Skor</th><th>Waktu</th></tr>";
                $no = 1;
                while($row = $result->fetch_assoc()){
                    echo "<tr>";
                    echo "<td>" . $no++ . "</td>";
                    echo "<td>" . htmlspecialchars($row['jawaban_user']) . "</td>";
                    echo "<td>" . $row['skor'] . "</td>";
                    echo "<td>" . $row['waktu'] . "</td>";
                    echo "</tr>";
                }
                echo "</table>";
            } else {
                echo "<p>Tidak ada data Pilihan Ganda Biasa.</p>";
            }
            ?>
        </div>
        <div class="section">
            <h2>Pilihan Ganda Komplek</h2>
            <?php
            $sql = "SELECT h.skor, h.jawaban_user, h.waktu FROM hasil_komplek h WHERE h.username = '$user' ORDER BY h.waktu ASC";
            $result = $mysqli->query($sql);
            if($result && $result->num_rows > 0) {
                echo "<table class='result'>";
                echo "<tr><th>No</th><th>Jawaban Anda</th><th>Skor</th><th>Waktu</th></tr>";
                $no = 1;
                while($row = $result->fetch_assoc()){
                    echo "<tr>";
                    echo "<td>" . $no++ . "</td>";
                    echo "<td>" . htmlspecialchars($row['jawaban_user']) . "</td>";
                    echo "<td>" . $row['skor'] . "</td>";
                    echo "<td>" . $row['waktu'] . "</td>";
                    echo "</tr>";
                }
                echo "</table>";
            } else {
                echo "<p>Tidak ada data Pilihan Ganda Komplek.</p>";
            }
            ?>
        </div>
        <div class="section">
            <h2>Menjodohkan</h2>
            <?php
            $sql = "SELECT h.skor, h.jawaban_user, h.waktu FROM hasil_jodoh h WHERE h.username = '$user' ORDER BY h.waktu ASC";
            $result = $mysqli->query($sql);
            if($result && $result->num_rows > 0) {
                echo "<table class='result'>";
                echo "<tr><th>No</th><th>Jawaban Anda</th><th>Skor</th><th>Waktu</th></tr>";
                $no = 1;
                while($row = $result->fetch_assoc()){
                    echo "<tr>";
                    echo "<td>" . $no++ . "</td>";
                    echo "<td>" . htmlspecialchars($row['jawaban_user']) . "</td>";
                    echo "<td>" . $row['skor'] . "</td>";
                    echo "<td>" . $row['waktu'] . "</td>";
                    echo "</tr>";
                }
                echo "</table>";
            } else {
                echo "<p>Tidak ada data Menjodohkan.</p>";
            }
            ?>
        </div>
        <div class="section">
            <h2>Benar/Salah</h2>
            <?php
            $sql = "SELECT h.skor, h.jawaban_user, h.waktu FROM hasil_bs h WHERE h.username = '$user' ORDER BY h.waktu ASC";
            $result = $mysqli->query($sql);
            if($result && $result->num_rows > 0) {
                echo "<table class='result'>";
                echo "<tr><th>No</th><th>Jawaban Anda</th><th>Skor</th><th>Waktu</th></tr>";
                $no = 1;
                while($row = $result->fetch_assoc()){
                    echo "<tr>";
                    echo "<td>" . $no++ . "</td>";
                    echo "<td>" . htmlspecialchars($row['jawaban_user']) . "</td>";
                    echo "<td>" . $row['skor'] . "</td>";
                    echo "<td>" . $row['waktu'] . "</td>";
                    echo "</tr>";
                }
                echo "</table>";
            } else {
                echo "<p>Tidak ada data Benar/Salah.</p>";
            }
            ?>
        </div>
    </div>
</body>
</html>
