<?php
// filepath: /opt/lampp/htdocs/soal_online/bs.php
session_start();
if (!isset($_SESSION["user"])) {
    header("Location: login.php");
    exit();
}
$user = $_SESSION["user"];

// Koneksi database
$mysqli = new mysqli("localhost", "lnibbicy_kka4", "magetan#2", "lnibbicy_kka4");
if ($mysqli->connect_error) {
    die("Koneksi gagal: " . $mysqli->connect_error);
}

// ================= PERUBAHAN BARU: CEK STATUS DAN SKOR DI AWAL UNTUK HANDLE ULANG JIKA SKOR 0 =================
// Pertama, ambil status dari tabel users
$stmt_status = $mysqli->prepare("SELECT status_kuis_bs FROM users WHERE username = ?");
$stmt_status->bind_param("s", $user);
$stmt_status->execute();
$result_status = $stmt_status->get_result();
$user_data = $result_status->fetch_assoc();
$stmt_status->close();

$status_kuis = $user_data['status_kuis_bs'] ?? ''; // Default kosong jika NULL

// Selalu hitung total skor dari hasil_bs untuk user ini (bahkan jika status selesai)
$stmt_total = $mysqli->prepare("SELECT SUM(skor) as total_skor FROM hasil_bs WHERE username = ?");
$stmt_total->bind_param("s", $user);
$stmt_total->execute();
$result_total = $stmt_total->get_result();
$total_data = $result_total->fetch_assoc();
$total_skor = $total_data['total_skor'] ?? 0; // Default 0 jika belum ada data
$stmt_total->close();

// Logika: Jika status 'selesai' DAN total_skor > 0, redirect ke skor_akhir
if ($status_kuis == 'selesai' && $total_skor > 0) {
    header("Location: skor_akhir.php?status=sudah_selesai&skor=" . $total_skor);
    exit();
}

// Jika status 'selesai' DAN total_skor == 0, reset untuk allow ulang
if ($status_kuis == 'selesai' && $total_skor == 0) {
    // Reset status
    $stmt_reset_status = $mysqli->prepare("UPDATE users SET status_kuis_bs = '' WHERE username = ?");
    $stmt_reset_status->bind_param("s", $user);
    $stmt_reset_status->execute();
    $stmt_reset_status->close();

    // Hapus semua hasil kuis untuk user ini
    $stmt_delete = $mysqli->prepare("DELETE FROM hasil_bs WHERE username = ?");
    $stmt_delete->bind_param("s", $user);
    $stmt_delete->execute();
    $stmt_delete->close();

    // Lanjut ke kuis (no=0), dengan pesan ulang
    $no = 0; // Force mulai dari awal
    header("Location: bs.php?no=0&ulang=ya"); // Redirect untuk trigger pesan
    exit();
}

// Jika status bukan 'selesai' (kosong atau belum), lanjut normal ke kuis
// ================= AKHIR PERUBAHAN BARU =================

// Ambil semua soal dari tabel benar_salah
$sql = "SELECT * FROM benar_salah ORDER BY id ASC";
$result = $mysqli->query($sql);
$semua_soal = [];
while ($row = $result->fetch_assoc()) {
    $semua_soal[] = $row;
}

// Tentukan soal yang aktif
$no = isset($_GET['no']) ? intval($_GET['no']) : 0;
if ($no < 0) $no = 0;
if ($no >= count($semua_soal)) $no = count($semua_soal) - 1;
$soal = $semua_soal[$no] ?? null; // Gunakan null coalescing untuk keamanan

// Proses kirim jawaban
if ($_SERVER["REQUEST_METHOD"] == "POST" && $soal) {
    $jawaban = isset($_POST['jawaban']) ? $_POST['jawaban'] : '';
    $jawaban_benar = $soal['jawaban_benar']; // 'Benar' atau 'Salah'
    
    // Perbarui skor. Hapus jawaban lama dan masukkan yang baru (UPSERT)
    $skor = (strtolower($jawaban) == strtolower($jawaban_benar)) ? 1 : 0;
    $stmt = $mysqli->prepare("INSERT INTO hasil_bs (username, id_soal, jawaban_user, skor, waktu) VALUES (?, ?, ?, ?, NOW()) ON DUPLICATE KEY UPDATE jawaban_user=VALUES(jawaban_user), skor=VALUES(skor), waktu=NOW()");
    $stmt->bind_param("sisi", $user, $soal['id'], $jawaban, $skor);
    $stmt->execute();
    $stmt->close();

    // Redirect ke soal berikutnya atau proses akhir
    if ($no < count($semua_soal) - 1) {
        header("Location: bs.php?no=" . ($no + 1));
        exit();
    } else {
        // ================= PERUBAHAN: HITUNG SKOR TOTAL DAN HANDLE ULANG JIKA 0 (UNTUK KASUS BARU) =================
        // Ini adalah soal terakhir. Hitung total skor dari tabel hasil_bs untuk user ini.
        $stmt_total_end = $mysqli->prepare("SELECT SUM(skor) as total_skor FROM hasil_bs WHERE username = ?");
        $stmt_total_end->bind_param("s", $user);
        $stmt_total_end->execute();
        $result_total_end = $stmt_total_end->get_result();
        $total_data_end = $result_total_end->fetch_assoc();
        $total_skor_end = $total_data_end['total_skor'] ?? 0;
        $stmt_total_end->close();

        if ($total_skor_end == 0) {
            // Jika skor total 0, reset status dan hapus hasil agar bisa ulang
            $stmt_reset_status = $mysqli->prepare("UPDATE users SET status_kuis_bs = '' WHERE username = ?");
            $stmt_reset_status->bind_param("s", $user);
            $stmt_reset_status->execute();
            $stmt_reset_status->close();

            // Hapus semua hasil kuis untuk user ini
            $stmt_delete = $mysqli->prepare("DELETE FROM hasil_bs WHERE username = ?");
            $stmt_delete->bind_param("s", $user);
            $stmt_delete->execute();
            $stmt_delete->close();

            // Redirect ke awal kuis untuk ulang
            header("Location: bs.php?no=0&ulang=ya");
            exit();
        } else {
            // Jika skor > 0, tandai kuis selesai
            $stmt_update = $mysqli->prepare("UPDATE users SET status_kuis_bs = 'selesai' WHERE username = ?");
            $stmt_update->bind_param("s", $user);
            $stmt_update->execute();
            $stmt_update->close();
            
            // Arahkan ke halaman skor akhir
            header("Location: skor_akhir.php?skor=" . $total_skor_end);
            exit();
        }
        // ================= AKHIR PERUBAHAN =================
    }
}

// Tambahan: Jika tidak ada soal sama sekali, beri pesan.
if (empty($semua_soal)) {
    die("Tidak ada soal Benar/Salah yang ditemukan di database.");
}

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Pernyataan Benar atau Salah</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <style>
        body {
            font-family: 'Open Sans', 'Comic Sans MS', Arial;
            background: linear-gradient(135deg, #0c3ab9ff 0%, #000279ff 100%);
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 800px;
            margin: 40px auto;
            background-image: url('images/logo hp.png'); /* Path gambar latar */
            background-size: cover;
            background-repeat: no-repeat;
            -webkit-backdrop-filter: blur(9px); /* Dukungan Safari */
            border-radius: 9px;
            box-shadow: 0 12px 24px rgba(0, 0, 0, 0.08);
            padding: 36px 24px;
            background-color: rgba(255, 255, 255, 0.85); /* Warna latar belakang dengan transparansi */
        }

        /* Optional: Hover effect for subtle interactivity */
        .container:hover {
            box-shadow: 0 16px 32px rgba(0, 0, 0, 0.12);
        }

        .pernyataan {
            margin-bottom: 18px;
            font-size: 1.4em;
            text-align: justify;
            line-height: 2;
            color: #333;
            padding: 0 30px 30px 20px;
        }

        h2 {
            color: #1976d2;
            text-align: center;
            margin-bottom: 24px;
            font-size: 1.9em;
        }
        .user-info {
            text-align: right;
            color: #1976d2;
            margin-bottom: 18px;
            font-size: 1em;
        }
        .gambar-soal {
            margin-bottom: 24px;
            text-align: center;
            display: flex;
            justify-content: center;
            align-items: center;
            flex-direction: column;
            gap: 12px;
        }

        .gambar-soal img {
            width: 100%;
            height: 500px;
            border-radius: 8px;
            box-shadow: 0 4px 16px #1976d233;
        }
        .opsi {
            margin: 18px 0;
            text-align: center;
        }
        label {
            display: inline-block;
            margin: 0 18px 0 0;
            font-size: 1.08em;
            background: #ebf0f7ff;
            border-radius: 8px;
            padding: 8px 18px;
            border: 1px solid #e9e9e9ff;
            cursor: pointer;
        }
        label:hover {
            background: #ff8513ff;
        }
        input[type="radio"] {
            margin-right: 8px;
        }
        button[type="submit"] {
            background: #3c75f1ff;
            color: #fff;
            border: none;
            border-radius: 8px;
            padding: 10px 32px;
            font-size: 1.1em;
            font-weight: 500;
            cursor: pointer;
            margin-top: 18px;
        }
        button[type="submit"]:hover {
            background: #0259bdff;
        }
        .center-button {
            display: flex;
            justify-content: center;
            margin-top: 20px;
        }
        @media (max-width: 400px) {
            body {
                background: #ffffffff;
            }
            .container {
                margin: 20px auto;
                padding: 15px 15px;
            }
            .pernyataan {
                font-size: 1.2em;
                line-height: 1.3;
                padding: 1px 1px 1px 1px;
            }
            .gambar-soal img {
                width: 350px;            /* lebar tetap 400px */
                height: auto;            /* tinggi menyesuaikan proporsi gambar */
                max-height: 500px;       /* batas maksimum tinggi */
                border-radius: 8px;
                box-shadow: 0 4px 16px #1976d233;
                object-fit: contain;     /* menjaga proporsi gambar */
            }
            h2 {
                font-size: 1.2em;
            }
            label {
                font-size: 1em;
                padding: 10px 14px;
            }
            button[type="submit"] {
                width: 50%;
                padding: 12px 0;
                font-size: 1.2em;
            }
            .user-info {
                font-size: 0.9em;
            }
        }
        h2 {
            font-size: 1.5em;
        }
            
        #timer {
            font-weight: bold;
            color: #d32f2f;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="user-info">:User    <b><?= htmlspecialchars($user) ?></b></div>

        <h2>Pernyataan Benar atau Salah (Soal <?= $no + 1 ?> dari <?= count($semua_soal) ?>)</h2>
        <?php if ($soal): ?>
            <form method="post" action="bs.php?no=<?= $no ?>">
                <?php if (!empty($soal['gambar'])): ?>
                    <div class="gambar-soal">
                        <img src="<?= htmlspecialchars($soal['gambar']) ?>" alt="Gambar Soal">
                    </div>
                <?php endif; ?>
                <div class="pernyataan">
                    <?= htmlspecialchars($soal['pernyataan']) ?>
                </div>

                <div class="opsi">
                    <label>
                        <input type="radio" name="jawaban" value="Benar" required> Benar
                    </label>
                    <label>
                        <input type="radio" name="jawaban" value="Salah" required> Salah
                    </label>
                </div>
    
                <div class="center-button">
                    <button type="submit">
                        <?= ($no < count($semua_soal) - 1) ? "Kirim" : "Kirim & Selesai" ?>
                    </button>
                </div>

            </form>
        <?php endif; ?>
        <!-- Pesan jika ulang karena skor 0 dihilangkan sesuai permintaan -->
    </div>
</body>
</html>
