<?php
// backup_and_clear_soal.php
// Script untuk backup data tabel 'soal' dan menghapus seluruh data pada tabel tersebut

include 'koneksi.php';

date_default_timezone_set('Asia/Jakarta');
$backupFile = 'backup_soal_' . date('Ymd_His') . '.sql';

// Backup data
$query = "SELECT * FROM soal";
$result = mysqli_query($koneksi, $query);

if (!$result) {
    die('Gagal mengambil data soal: ' . mysqli_error($koneksi));
}

$backupSql = "INSERT INTO soal VALUES\n";
$rows = [];
while ($row = mysqli_fetch_assoc($result)) {
    $escaped = array_map(function($v) use ($koneksi) {
        return isset($v) ? "'" . mysqli_real_escape_string($koneksi, $v) . "'" : 'NULL';
    }, $row);
    $rows[] = '(' . implode(',', $escaped) . ')';
}

if (count($rows) > 0) {
    $backupSql .= implode(",\n", $rows) . ";\n";
    file_put_contents($backupFile, $backupSql);
    echo "Backup berhasil ke file: $backupFile<br>";
} else {
    echo "Tidak ada data soal untuk di-backup.<br>";
}

// Hapus data
deleteSoal($koneksi);

echo "Seluruh data soal telah dihapus.";

function deleteSoal($koneksi) {
    $del = mysqli_query($koneksi, "DELETE FROM soal");
    if (!$del) {
        die('Gagal menghapus data soal: ' . mysqli_error($koneksi));
    }
}

?>
