<?php
// Koneksi database
$mysqli = new mysqli("localhost", "lnibbicy_kka4", "magetan#2", "lnibbicy_kka4");
if ($mysqli->connect_error) {
    die("Koneksi gagal: " . $mysqli->connect_error);
}

// Inisialisasi variabel pesan
$pesan = '';
$pesan_error = '';

// Logika untuk memproses permintaan RESET
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['reset_username'])) {
        // Reset status individual user
        $username_to_reset = $_POST['reset_username'];

        // Hapus semua hasil kuis untuk pengguna ini
        $tables = ['hasil_ganda_b', 'hasil_komplek', 'hasil_jodoh', 'hasil_bs'];
        foreach ($tables as $table) {
            $stmt = $mysqli->prepare("DELETE FROM $table WHERE username = ?");
            $stmt->bind_param("s", $username_to_reset);
            $stmt->execute();
            $stmt->close();
        }

        // Reset status di tabel users
        $stmt = $mysqli->prepare(
            "UPDATE users SET 
                status_kuis_komplek = 'belum_selesai', 
                status_kuis_jodoh = 'belum_selesai', 
                status_kuis_bs = 'belum_selesai',
                status_kuis_ganda = 'belum_selesai'
            WHERE username = ?"
        );
        $stmt->bind_param("s", $username_to_reset);
        
        if ($stmt->execute()) {
            $pesan = "Semua data untuk pengguna '{$username_to_reset}' berhasil direset.";
        } else {
            $pesan_error = "Gagal mereset data pengguna.";
        }
        $stmt->close();
    } elseif (isset($_POST['reset_all'])) {
        // Reset semua data untuk semua pengguna
        $tables = ['hasil_ganda_b', 'hasil_komplek', 'hasil_jodoh', 'hasil_bs'];
        foreach ($tables as $table) {
            $mysqli->query("DELETE FROM $table");
        }

        $update_query = "UPDATE users SET 
            status_kuis_komplek = 'belum_selesai', 
            status_kuis_jodoh = 'belum_selesai', 
            status_kuis_bs = 'belum_selesai',
            status_kuis_ganda = 'belum_selesai'";
        if ($mysqli->query($update_query)) {
            $pesan = "Semua data untuk semua pengguna berhasil direset.";
        } else {
            $pesan_error = "Gagal mereset semua data pengguna.";
        }
    }
}

// --- AUTO UPDATE STATUS KUIS GANDA DAN JODOH ---
// Update status_kuis_ganda ke 'selesai' jika user sudah mengerjakan semua soal ganda
$sql_users = "SELECT username FROM users";
$res_users = $mysqli->query($sql_users);
if ($res_users) {
    while ($user_row = $res_users->fetch_assoc()) {
        $username = $user_row['username'];

        // GANDA
        $sql_total_ganda = "SELECT COUNT(*) as total FROM ganda_b";
        $res_total_ganda = $mysqli->query($sql_total_ganda);
        $row_total_ganda = $res_total_ganda->fetch_assoc();
        $total_soal_ganda = $row_total_ganda['total'];

        $sql_jawab_ganda = "SELECT COUNT(*) as terjawab FROM hasil_ganda_b WHERE username = ?";
        $stmt_ganda = $mysqli->prepare($sql_jawab_ganda);
        $stmt_ganda->bind_param("s", $username);
        $stmt_ganda->execute();
        $res_jawab_ganda = $stmt_ganda->get_result();
        $row_jawab_ganda = $res_jawab_ganda->fetch_assoc();
        $terjawab_ganda = $row_jawab_ganda['terjawab'];
        $stmt_ganda->close();

        if ($terjawab_ganda >= $total_soal_ganda && $total_soal_ganda > 0) {
            $stmt_update_ganda = $mysqli->prepare("UPDATE users SET status_kuis_ganda = 'selesai' WHERE username = ?");
            $stmt_update_ganda->bind_param("s", $username);
            $stmt_update_ganda->execute();
            $stmt_update_ganda->close();
        } else {
            $stmt_update_ganda = $mysqli->prepare("UPDATE users SET status_kuis_ganda = 'belum_selesai' WHERE username = ?");
            $stmt_update_ganda->bind_param("s", $username);
            $stmt_update_ganda->execute();
            $stmt_update_ganda->close();
        }

        // JODOH
        $sql_total_jodoh = "SELECT COUNT(*) as total FROM jodoh_soal";
        $res_total_jodoh = $mysqli->query($sql_total_jodoh);
        $row_total_jodoh = $res_total_jodoh->fetch_assoc();
        $total_soal_jodoh = $row_total_jodoh['total'];

        $sql_jawab_jodoh = "SELECT COUNT(*) as terjawab FROM hasil_jodoh WHERE username = ?";
        $stmt_jodoh = $mysqli->prepare($sql_jawab_jodoh);
        $stmt_jodoh->bind_param("s", $username);
        $stmt_jodoh->execute();
        $res_jawab_jodoh = $stmt_jodoh->get_result();
        $row_jawab_jodoh = $res_jawab_jodoh->fetch_assoc();
        $terjawab_jodoh = $row_jawab_jodoh['terjawab'];
        $stmt_jodoh->close();

        if ($terjawab_jodoh >= $total_soal_jodoh && $total_soal_jodoh > 0) {
            $stmt_update_jodoh = $mysqli->prepare("UPDATE users SET status_kuis_jodoh = 'selesai' WHERE username = ?");
            $stmt_update_jodoh->bind_param("s", $username);
            $stmt_update_jodoh->execute();
            $stmt_update_jodoh->close();
        } else {
            $stmt_update_jodoh = $mysqli->prepare("UPDATE users SET status_kuis_jodoh = 'belum_selesai' WHERE username = ?");
            $stmt_update_jodoh->bind_param("s", $username);
            $stmt_update_jodoh->execute();
            $stmt_update_jodoh->close();
        }
    }
}
// --- END AUTO UPDATE ---

// Ambil semua data pengguna dan status kuis mereka untuk ditampilkan
$sql = "SELECT username, status_kuis_komplek, status_kuis_jodoh, status_kuis_bs, status_kuis_ganda FROM users ORDER BY username";
$result = $mysqli->query($sql);
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin - Kelola Status Kuis Peserta</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            font-size: 16px;
            background: linear-gradient(135deg, #5763efff 0%, #071728ff 100%);
            color: #333;
            margin: 0;
            padding: 20px;
        }
        .container {
            max-width: 1200px;
            margin: 20px auto;
            background-color: #fff;
            padding: 20px 30px;
            border-radius: 8px;
            box-shadow: 0 4px 10px rgba(0,0,0,0.05);
        }
        h1 {
            color: #1976d2;
            text-align: center;
            border-bottom: 2px solid #eee;
            padding-bottom: 10px;
            margin-bottom: 20px;
        }
        .pesan {
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 5px;
            text-align: center;
        }
        .sukses {
            background-color: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        .error {
            background-color: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
            font-size: 18px;
        }
        th, td {
            padding: 12px;
            border: 1px solid #ddd;
            text-align: center;
        }
        thead {
            background-color: #1976d2;
            color: #fff;
        }
        .status {
            padding: 6px 12px;
            border-radius: 20px;
            color: #fff;
            font-weight: bold;
            font-size: 0.85em;
            text-transform: uppercase;
            display: inline-block;
            min-width: 100px;
        }
        .status-selesai {
            background-color: #28a745;
        }
        .status-belum {
            background-color: #ffc107;
        }
        .btn-reset {
            background: linear-gradient(135deg, #dc3545, #ff6b6b, #b80000ff);
            color: #fff;
            border: none;
            padding: 8px 16px;
            border-radius: 15px;
            cursor: pointer;
            font-size: 0.9em;
            transition: background-color 0.3s;
        }
        .btn-reset:hover {
            background-color: #f53448ff;
            transform: translateY(-1px);
        }
        .btn-reset-all {
            background: linear-gradient(135deg, #dc3545, #ff6b6b, #b80000ff);
            color: #fff;
            border: none;
            padding: 12px 20px;
            border-radius: 15px;
            cursor: pointer;
            font-size: 1em;
            transition: background-color 0.3s;
            margin-left: 10px;
        }
        .btn-reset-all:hover {
            background-color: #f53448ff;
            transform: translateY(-1px);
        }
        .btn-home {
            background-color: #0ea03a;
            color: #fff;
            border: none;
            padding: 12px 20px;
            border-radius: 5px;
            cursor: pointer;
            font-size: 1em;
            text-decoration: none;
            display: inline-block;
            transition: background-color 0.3s;
        }
        .btn-home:hover {
            background-color: #08832d;
            transform: translateY(-1px);
            color: #fff;
        }
        @media (max-width: 768px) {
            .container {
                padding: 15px;
                margin: 10px;
            }
            table {
                font-size: 12px;
            }
            th, td {
                padding: 8px;
            }
            .btn-home {
                width: 100%;
                text-align: center;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Kelola Status Peserta Kuis</h1>

        <?php if (!empty($pesan)): ?>
            <div class="pesan sukses"><?= htmlspecialchars($pesan) ?></div>
        <?php endif; ?>
        <?php if (!empty($pesan_error)): ?>
            <div class="pesan error"><?= htmlspecialchars($pesan_error) ?></div>
        <?php endif; ?>

        <a href="admin.php" class="btn-home">Kembali ke Admin Home</a>
        <form method="POST" action="" style="display: inline;" onsubmit="return confirm('Anda yakin ingin menghapus semua data kuis untuk SEMUA pengguna? Tindakan ini tidak dapat dibatalkan.');">
            <button type="submit" name="reset_all" class="btn-reset-all">Reset All</button>
        </form>

        <table>
            <thead>
                <tr>
                    <th>Username</th>
                    <th>Status Ganda</th>
                    <th>Status Jodoh</th>
                    <th>Status B/S</th>
                    <th>Status Komplek</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($result->num_rows > 0): ?>
                    <?php while($row = $result->fetch_assoc()): ?>
                        <tr>
                            <td><?= htmlspecialchars($row['username']) ?></td>
                            <td>
                                <?php 
                                    $status_ganda = !empty($row['status_kuis_ganda']) ? $row['status_kuis_ganda'] : 'belum_selesai';
                                    $class_ganda = ($status_ganda == 'selesai') ? 'status-selesai' : 'status-belum';
                                    echo "<span class='status {$class_ganda}'>" . str_replace('_', ' ', $status_ganda) . "</span>";
                                ?>
                            </td>
                            <td>
                                <?php 
                                    $status_jodoh = !empty($row['status_kuis_jodoh']) ? $row['status_kuis_jodoh'] : 'belum_selesai';
                                    $class_jodoh = ($status_jodoh == 'selesai') ? 'status-selesai' : 'status-belum';
                                    echo "<span class='status {$class_jodoh}'>" . str_replace('_', ' ', $status_jodoh) . "</span>";
                                ?>
                            </td>
                            <td>
                                <?php 
                                    $status_bs = !empty($row['status_kuis_bs']) ? $row['status_kuis_bs'] : 'belum_selesai';
                                    $class_bs = ($status_bs == 'selesai') ? 'status-selesai' : 'status-belum';
                                    echo "<span class='status {$class_bs}'>" . str_replace('_', ' ', $status_bs) . "</span>";
                                ?>
                            </td>
                            <td>
                                <?php 
                                    $status_komplek = !empty($row['status_kuis_komplek']) ? $row['status_kuis_komplek'] : 'belum_selesai';
                                    $class_komplek = ($status_komplek == 'selesai') ? 'status-selesai' : 'status-belum';
                                    echo "<span class='status {$class_komplek}'>" . str_replace('_', ' ', $status_komplek) . "</span>";
                                ?>
                            </td>
                            <td>
                                <form method="POST" action="" onsubmit="return confirm('Anda yakin ingin menghapus semua data kuis untuk pengguna <?= htmlspecialchars($row['username']) ?>?');">
                                    <input type="hidden" name="reset_username" value="<?= htmlspecialchars($row['username']) ?>">
                                    <button type="submit" class="btn-reset">Reset</button>
                                </form>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="6" style="text-align: center; padding: 20px;">Tidak ada data pengguna.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</body>
</html>
<?php
$mysqli->close();
?>
