<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!isset($_SESSION["user"])) {
    header("Location: login.php");
    exit();
}
$user = $_SESSION["user"];

// Koneksi database
$mysqli = new mysqli("localhost", "lnibbicy_kka5", "magetan#2", "lnibbicy_kka5");
if ($mysqli->connect_error) {
    die("Koneksi gagal: " . $mysqli->connect_error);
}

// Inisialisasi variabel skor
$skor_ganda_b = 0;
$skor_komplek = 0;
$skor_jodoh = 0;
$skor_bs = 0;

$total_soal_ganda_b = 0;
$total_soal_komplek = 0;
$total_soal_jodoh = 0;
$total_soal_bs = 0;

// Ambil skor dari hasil_ganda_b (hindari duplikat jawaban)
$sql = "SELECT SUM(skor) as total FROM (
    SELECT MAX(skor) as skor FROM hasil_ganda_b WHERE username='$user' GROUP BY id_soal
) as sub";
$result = $mysqli->query($sql);
if ($result && $row = $result->fetch_assoc()) {
    $skor_ganda_b = $row['total'] ? $row['total'] : 0;
}

// Ambil skor dari hasil_komplek (hindari duplikat jawaban)
$sql = "SELECT SUM(skor) as total FROM (
    SELECT MAX(skor) as skor FROM hasil_komplek WHERE username='$user' GROUP BY id_soal
) as sub";
$result = $mysqli->query($sql);
if ($result && $row = $result->fetch_assoc()) {
    $skor_komplek = $row['total'] ? $row['total'] : 0;
}

// Ambil skor dari hasil_jodoh (hindari duplikat jawaban)
$sql = "SELECT SUM(skor) as total FROM (
    SELECT MAX(skor) as skor FROM hasil_jodoh WHERE username='$user' GROUP BY id_soal
) as sub";
$result = $mysqli->query($sql);
if ($result && $row = $result->fetch_assoc()) {
    $skor_jodoh = $row['total'] ? $row['total'] : 0;
}

// Ambil skor dari hasil_bs (hindari duplikat jawaban)
$sql = "SELECT SUM(skor) as total FROM (
    SELECT MAX(skor) as skor FROM hasil_bs WHERE username='$user' GROUP BY id_soal
) as sub";
$result = $mysqli->query($sql);
if ($result && $row = $result->fetch_assoc()) {
    $skor_bs = $row['total'] ? $row['total'] : 0;
}

// Hitung total soal
$sql = "SELECT COUNT(*) as total FROM ganda_b";
$result = $mysqli->query($sql);
if ($result && $row = $result->fetch_assoc()) {
    $total_soal_ganda_b = $row['total'];
}

$sql = "SELECT COUNT(*) as total FROM komplek_soal";
$result = $mysqli->query($sql);
if ($result && $row = $result->fetch_assoc()) {
    $total_soal_komplek = $row['total'];
}

$sql = "SELECT COUNT(*) as total FROM jodoh_soal";
$result = $mysqli->query($sql);
if ($result && $row = $result->fetch_assoc()) {
    $total_soal_jodoh = $row['total'];
}

$sql = "SELECT COUNT(*) as total FROM benar_salah";
$result = $mysqli->query($sql);
if ($result && $row = $result->fetch_assoc()) {
    $total_soal_bs = $row['total'];
}

$total_skor = $skor_ganda_b + $skor_komplek + $skor_jodoh + $skor_bs;
$total_semua_soal = $total_soal_ganda_b + $total_soal_komplek + $total_soal_jodoh + $total_soal_bs;
if (!isset($total_semua_soal)) {
    $total_semua_soal = 0;
}

// Hitung total skor maksimum berdasarkan jumlah soal (bukan SUM skor) agar persentase tidak lebih dari 100%
// ...existing code...

// Hitung total skor maksimum berdasarkan SUM skor_b, skor_k, skor_j, skor_bs
$sql = "
    SELECT
        (SELECT SUM(skor_b) FROM ganda_b) +
        (SELECT SUM(skor_k) FROM komplek_soal) +
        (SELECT SUM(skor_j) FROM jodoh_soal) +
        (SELECT SUM(skor_bs) FROM benar_salah) AS total_skor_max
";
$result = $mysqli->query($sql);
if ($result && $row = $result->fetch_assoc()) {
    $total_skor_max = $row['total_skor_max'] ? $row['total_skor_max'] : 0;
} else {
    $total_skor_max = 0;
}

// ...existing code...
// Hitung persentase
$persentase = $total_skor_max > 0 ? round(($total_skor / $total_skor_max) * 100, 1) : 0;

// Validasi persentase
if ($persentase > 100) {
    $valid = false;
    $pesan = "Jawaban tidak valid: nilai skor melebihi 100%.";
} else {
    $valid = true;
    $pesan = "Jawaban valid.";
}

// Cek status ujian
$sudah_ganda_b = ($skor_ganda_b > 0);
$sudah_komplek = ($skor_komplek > 0);
$sudah_jodoh = ($skor_jodoh > 0);
$sudah_bs = ($skor_bs > 0);

$mysqli->close();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Skor Akhir AKM</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body {
            font-family: 'Open Sans', 'Comic Sans MS', Arial;
            background: linear-gradient(135deg, #3240d3ff 0%, #071728ff 100%);
            margin: 0;
            padding: 0;
            min-height: 100vh;
        }
        .container {
            max-width: 800px;
            margin: 40px auto;
            background: #fff;
            border-radius: 16px;
            box-shadow: 0 8px 32px 0 rgba(44, 62, 80, 0.18);
            padding: 32px 24px;
        }
        .header {
            text-align: center;
            margin-bottom: 32px;
        }
        .header h1 {
            color: #1976d2;
            margin-bottom: 8px;
            font-size: 2.2em;
            font-weight: 600;
        }
        .user-info {
            background: #e3f2fd;
            padding: 16px;
            border-radius: 12px;
            text-align: center;
            margin-bottom: 24px;
            border: 2px solid #bbdefb;
        }
        .user-name {
            font-size: 1.3em;
            color: #1976d2;
            font-weight: 600;
        }
        .total-score {
            background: linear-gradient(135deg, #4caf50 0%, #66bb6a 100%);
            color: white;
            padding: 24px;
            border-radius: 16px;
            text-align: center;
            margin-bottom: 32px;
            box-shadow: 0 4px 16px rgba(76, 175, 80, 0.3);
        }
        .total-score h2 {
            margin: 0 0 12px 0;
            font-size: 1.8em;
        }
        .score-number {
            font-size: 3em;
            font-weight: bold;
            margin: 8px 0;
        }
        .percentage {
            font-size: 1.2em;
            opacity: 0.9;
        }
        .detail-scores {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 16px;
            margin-bottom: 32px;
        }
        .score-card {
            background: #f8f9fa;
            border: 2px solid #e9ecef;
            border-radius: 12px;
            padding: 20px;
            text-align: center;
            transition: transform 0.2s, box-shadow 0.2s;
        }
        .score-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 16px rgba(0, 0, 0, 0.1);
        }
        .score-card.completed {
            border-color: #4caf50;
            background: #f1f8e9;
        }
        .score-card.pending {
            border-color: #ff9800;
            background: #fff3e0;
        }
        .score-card h3 {
            color: #333;
            margin: 0 0 12px 0;
            font-size: 1.1em;
        }
        .score-value {
            font-size: 2em;
            font-weight: bold;
            color: #1976d2;
            margin: 8px 0;
        }
        .score-details {
            font-size: 0.9em;
            color: #666;
        }
        .status-badge {
            display: inline-block;
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 0.8em;
            font-weight: 500;
            margin-top: 8px;
        }
        .completed-badge {
            background: #e8f5e8;
            color: #2e7d32;
        }
        .pending-badge {
            background: #fff3e0;
            color: #f57c00;
        }
        .action-buttons {
            display: flex;
            gap: 16px;
            justify-content: center;
            flex-wrap: wrap;
            margin-top: 32px;
        }
        .btn {
            padding: 12px 24px;
            border: none;
            border-radius: 8px;
            font-size: 1.1em;
            font-weight: 500;
            cursor: pointer;
            text-decoration: none;
            text-align: center;
            transition: all 0.2s;
            min-width: 140px;
            display: inline-block;
        }
        .btn-primary {
            background: #1976d2;
            color: white;
        }
        .btn-primary:hover {
            background: #1565c0;
            transform: translateY(-1px);
        }
        .btn-success {
            background: #4caf50;
            color: white;
        }
        .btn-success:hover {
            background: #45a049;
            transform: translateY(-1px);
        }
        .btn-warning {
            background: #ff9800;
            color: white;
        }
        .btn-warning:hover {
            background: #4a9ce0ff;
            transform: translateY(-1px);
        }
        .btn-secondary {
            background: #ff0000ff;
            color: white;
        }
        .btn-secondary-jwb {
            background: #130fe9ff;
            color: white;
        }

        .btn-secondary:hover {
            background: #d32a2aff;
            transform: translateY(-1px);
        }
        .progress-section {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 12px;
            margin-bottom: 24px;
        }
        .progress-title {
            color: #333;
            margin-bottom: 16px;
            font-weight: 600;
        }
        .progress-items {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 12px;
        }
        .progress-item {
            display: flex;
            align-items: center;
            gap: 8px;
        }
        .progress-icon {
            width: 20px;
            height: 20px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 12px;
            font-weight: bold;
        }
        .progress-icon.completed {
            background: #4caf50;
            color: white;
        }
        .progress-icon.pending {
            background: #ff9800;
            color: white;
        }
        .congratulation {
            text-align: center;
            margin-top: 24px;
            padding: 16px;
            border-radius: 8px;
        }
        .congratulation.excellent {
            background: #e8f5e8;
            color: #2e7d32;
        }
        .congratulation.good {
            background: #e3f2fd;
            color: #1976d2;
        }
        .congratulation.improve {
            background: #fff3e0;
            color: #f57c00;
        }
        @media (max-width: 400px) {
            .container {
                margin: 20px;
                padding: 20px 16px;
            }
            .header h1 {
                font-size: 1.8em;
            }
            .score-number {
                font-size: 2.5em;
            }
            .detail-scores {
                grid-template-columns: 1fr;
            }
            .action-buttons {
                flex-direction: column;
                align-items: center;
            }
            .btn {
                width: 70%;
                max-width: 300px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Hasil Asesmen Kompetensi Minimum</h1>
            <div class="user-info">
                <div class="user-name">Peserta: <?= htmlspecialchars($user) ?></div>
            </div>
        

        <div class="total-score">
    <h2>Total Skor <?= htmlspecialchars($user) ?></h2>
    <div class="score-number"><?= htmlspecialchars($total_skor) ?></div>
    Dari <?= htmlspecialchars($total_semua_soal) ?> Soal<br>
    Skor Maksimum: <?= htmlspecialchars($total_skor_max) ?><br>
    Persentase Nilai: <?= htmlspecialchars($persentase) ?>%
</div>



        <div class="progress-section">
            <h3 class="progress-title">Status Pengerjaan</h3>
            <div class="progress-items">
                <div class="progress-item">
                    <div class="progress-icon <?= $sudah_ganda_b ? 'completed' : 'pending' ?>">
                        <?= $sudah_ganda_b ? '✓' : '!' ?>
                        
                    </div>
                    <span>Pilihan Ganda Biasa <?= $sudah_ganda_b ? '(Selesai)' : '(Belum)' ?></span>
                </div>
                <div class="progress-item">
                    <div class="progress-icon <?= $sudah_komplek ? 'completed' : 'pending' ?>">
                        <?= $sudah_komplek ? '✓' : '!' ?>
                    </div>
                    <span>Pilihan Ganda Komplek <?= $sudah_komplek ? '(Selesai)' : '(Belum)' ?></span>
                </div>
                <div class="progress-item">
                    <div class="progress-icon <?= $sudah_jodoh ? 'completed' : 'pending' ?>">
                        <?= $sudah_jodoh ? '✓' : '!' ?>
                    </div>
                    <span>Menjodohkan <?= $sudah_jodoh ? '(Selesai)' : '(Belum)' ?></span>
                </div>
                <div class="progress-item">
                    <div class="progress-icon <?= $sudah_bs ? 'completed' : 'pending' ?>">
                        <?= $sudah_bs ? '✓' : '!' ?>
                    </div>
                    <span>Benar/Salah <?= $sudah_bs ? '(Selesai)' : '(Belum)' ?></span>
                </div>
            </div>
        </div>

        <div class="detail-scores">
            <div class="score-card <?= $sudah_ganda_b ? 'completed' : 'pending' ?>">
                <h3>Skor Pilihan Ganda Biasa</h3>
                <div class="score-value"><?= $skor_ganda_b ?></div>
                dari <?= $total_soal_ganda_b ?> Soal
                <span class="status-badge <?= $sudah_ganda_b ? 'completed-badge' : 'pending-badge' ?>">
                </span>
            </div>

            <div class="score-card <?= $sudah_komplek ? 'completed' : 'pending' ?>">
                <h3>Skor Pilihan Ganda Komplek</h3>
                <div class="score-value"><?= $skor_komplek ?></div>
                dari <?= $total_soal_komplek ?> Soal
                <span class="status-badge <?= $sudah_komplek ? 'completed-badge' : 'pending-badge' ?>">
                </span>
            </div>

            <div class="score-card <?= $sudah_jodoh ? 'completed' : 'pending' ?>">
                <h3>Skor Menjodohkan</h3>
                <div class="score-value"><?= $skor_jodoh ?></div>
                dari <?= $total_soal_jodoh ?> Soal
                <span class="status-badge <?= $sudah_jodoh ? 'completed-badge' : 'pending-badge' ?>">
                </span>
            </div>

            <div class="score-card <?= $sudah_bs ? 'completed' : 'pending' ?>">
                <h3>Skor Benar/Salah</h3>
                <div class="score-value"><?= $skor_bs ?></div>
                dari <?= $total_soal_bs ?> Soal
                <span class="status-badge <?= $sudah_bs ? 'completed-badge' : 'pending-badge' ?>">
                </span>
            </div>
        </div>

        <div class="action-buttons">
            <?php
            $boleh_ulang = ($skor_ganda_b < 5 || $skor_komplek < 5 || $skor_jodoh < 5 || $skor_bs < 5);
            ?>
            <?php if ($total_skor == 0 || $boleh_ulang): ?>
                <a href="reset_ujian.php" class="btn btn-success">Ulangi Ujian</a>
            <?php endif; ?>
            <?php if (!$sudah_ganda_b): ?>
                <a href="ganda_B.php" class="btn btn-warning">Mulai Pilihan Ganda Biasa</a>
            <?php endif; ?>
            <?php if (!$sudah_komplek): ?>
                <a href="komplek.php" class="btn btn-warning">Mulai Pilihan Ganda Komplek</a>
            <?php endif; ?>
            <?php if (!$sudah_jodoh): ?>
                <a href="jodoh.php" class="btn btn-warning">Mulai Menjodohkan</a>
            <?php endif; ?>
            <?php if (!$sudah_bs): ?>
                <a href="bs.php" class="btn btn-warning">Mulai Benar/Salah</a>
            <?php endif; ?>
            <a href="cetak.php" class="btn btn-secondary-jwb">Cetak Skor kamu!</a>
            <a href="login.php" class="btn btn-secondary">Logout</a>
        </div>

        <?php if ($total_skor > 0): ?>
            <div class="congratulation <?php
                if ($persentase >= 80) echo 'excellent';
                elseif ($persentase >= 60) echo 'good';
                else echo 'improve';
            ?>">
                <p style="font-weight: 500; margin: 0;">
                    <?php if ($persentase >= 80): ?>
                        Selamat! Hasil yang sangat baik!
                    <?php elseif ($persentase >= 60): ?>
                        Hasil yang cukup baik, terus tingkatkan!
                    <?php else: ?>
                        Terus belajar dan berlatih untuk hasil yang lebih baik!
                    <?php endif; ?>
                </p>
            </div>
        <?php endif; ?>
    </div>
</body>
</html>