<?php
session_start();
if (!isset($_SESSION["user"])) {
    header("Location: login.php");
    exit();
}

// Koneksi database
$mysqli = new mysqli("localhost", "root", "", "kuis_online");
if ($mysqli->connect_error) {
    die("Koneksi gagal: " . $mysqli->connect_error);
}

$pesan = "";
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $pertanyaan = $_POST["pertanyaan"];
    $jawaban1 = $_POST["jawaban1"];
    $jawaban2 = $_POST["jawaban2"];
    $jawaban3 = $_POST["jawaban3"];
    $jawaban_benar = $_POST["jawaban_benar"]; // Akan berisi '1', '2', atau '3'

    // Pilih jawaban benar sesuai pilihan user
    if ($jawaban_benar == "1") $jawaban_benar_val = $jawaban1;
    elseif ($jawaban_benar == "2") $jawaban_benar_val = $jawaban2;
    elseif ($jawaban_benar == "3") $jawaban_benar_val = $jawaban3;
    else $jawaban_benar_val = "";

    // Simpan ke tabel ipas
    $stmt = $mysqli->prepare("INSERT INTO ipas (mapel, pertanyaan, jawaban1, jawaban2, jawaban3, jawaban_benar) VALUES ('ipas', ?, ?, ?, ?, ?)");
    $stmt->bind_param("sssss", $pertanyaan, $jawaban1, $jawaban2, $jawaban3, $jawaban_benar_val);
    if ($stmt->execute()) {
        $pesan = "<span style='color:green;'>Soal berhasil ditambahkan!</span>";
    } else {
        $pesan = "<span style='color:red;'>Gagal menambah soal: " . $stmt->error . "</span>";
    }
    $stmt->close();
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Input Soal IPAS</title>
    <link rel="stylesheet" href="style.css">
    <style>
        .input-form {
            max-width: 420px;
            margin: 40px auto;
            background: #fffbe7;
            border-radius: 18px;
            padding: 28px 24px;
            box-shadow: 0 4px 18px #ffe08255;
            border: 2px solid #ffe082;
        }
        .input-form label {
            display: block;
            margin-top: 12px;
            font-weight: bold;
            color: #ff7f50;
        }
        .input-form input[type="text"], .input-form textarea {
            width: 100%;
            padding: 8px 10px;
            margin-top: 4px;
            border-radius: 8px;
            border: 1.5px solid #ffb347;
            font-size: 1em;
        }
        .input-form .opsi-jawaban {
            display: flex;
            align-items: center;
            margin-top: 6px;
        }
        .input-form .opsi-jawaban input[type="radio"] {
            margin-right: 8px;
        }
        .input-form button {
            margin-top: 18px;
            padding: 10px 28px;
            background: linear-gradient(90deg, #ffb347 0%, #ffcc80 100%);
            color: #fff;
            border: none;
            border-radius: 22px;
            font-size: 1.1em;
            font-weight: bold;
            cursor: pointer;
        }
        .input-form button:hover {
            background: linear-gradient(90deg, #ffcc80 0%, #ffb347 100%);
            color: #ff7f50;
        }
    </style>
</head>
<body>
<div class="input-form">
    <h2>Input Soal IPAS</h2>
    <?= $pesan ?>
    <form method="post" action="">
        <label>Pertanyaan:</label>
        <textarea name="pertanyaan" required rows="3"></textarea>
        <label>Jawaban 1:</label>
        <div class="opsi-jawaban">
            <input type="radio" name="jawaban_benar" value="1" required> 
            <input type="text" name="jawaban1" required>
            <span style="margin-left:8px;color:#888;">(Pilih jika ini jawaban benar)</span>
        </div>
        <label>Jawaban 2:</label>
        <div class="opsi-jawaban">
            <input type="radio" name="jawaban_benar" value="2" required>
            <input type="text" name="jawaban2" required>
            <span style="margin-left:8px;color:#888;">(Pilih jika ini jawaban benar)</span>
        </div>
        <label>Jawaban 3:</label>
        <div class="opsi-jawaban">
            <input type="radio" name="jawaban_benar" value="3" required>
            <input type="text" name="jawaban3" required>
            <span style="margin-left:8px;color:#888;">(Pilih jika ini jawaban benar)</span>
        </div>
        <button type="submit">Simpan Soal</button>
    </form>
    <div style="margin-top:18px;">
        <a href="home.php">Kembali ke Home</a>
    </div>
</div>
</body>
</html>