<?php
// filepath: /opt/lampp/htdocs/soal_online/rekap_akm.php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!isset($_SESSION["user"])) {
    header("Location: login.php");
    exit();
}

$pesan_error = "";
$peserta = [];

// Koneksi database
$mysqli = new mysqli("localhost", "lnibbicy_kka5", "magetan#2", "lnibbicy_kka5");
if ($mysqli->connect_error) {
    $pesan_error = "Koneksi gagal: " . $mysqli->connect_error;
} else {
    // Ambil semua peserta unik
    $sql = "SELECT DISTINCT username FROM (
        SELECT username FROM hasil_ganda_b
        UNION
        SELECT username FROM hasil_komplek
        UNION
        SELECT username FROM hasil_jodoh
        UNION
        SELECT username FROM hasil_bs
    ) as all_user";
    $res = $mysqli->query($sql);
    if (!$res) {
        $pesan_error = "Gagal mengambil data peserta: " . $mysqli->error;
    } else {
        while ($row = $res->fetch_assoc()) {
            $peserta[] = $row['username'];
        }
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Rekap Skor Peserta AKM</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body { 
        font-family: Arial, sans-serif; 
        background: linear-gradient(135deg, #5763efff 0%, #071728ff 100%);
        .container { max-width: 900px; 
            margin: 40px auto; background: #fff; border-radius: 16px; box-shadow: 0 4px 16px #1976d233; 
            padding: 32px 24px;
        align: center;
     }}
        h2 { color: #1976d2; text-align: center; margin-bottom: 24px; }
        .error { color: red; text-align: center; margin-bottom: 18px; font-weight: bold; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 24px; }
        th, td { border: 1px solid #b3c6e0; padding: 10px 8px; text-align: center; }
        th { background: #bbdefb; color: #1976d2; }
        tr:nth-child(even) { background: #f7fbff; }
        tr:hover { background: #e3f2fd; }
        td { font-weight: normal; }
        th { font-weight: bold; }
        .btn-login {
            background: #0c812fff;
            align: center;
            color: #fff;
            border: none;
            border-radius: 8px;
            padding: 10px 32px;
            font-size: 1.1em;
            cursor: pointer;
            margin-top: 18px;
        }
        .btn-login:hover { background: #3cec71ff; }

        @media (max-width: 400px) {
            .conhhhtainer { 
                
            padding: 12px 2vw 12px 2vw; 
                margin: 20px auto; 
                box-shadow: 0 2px 8px #1976d233;
                border-radius: 12px;

            }}

            h2 { font-size: 1.5em; }
            table { font-size: 0.9em; 
                margin-bottom: 16px; 
            }
            th, td { padding: 8px 4px;
                text-align: center; 
            }
            .btn-login { 
                display: block; 
                padding: 8px 24px;
                width: 25%; 
                font-size: 1em;
                background-color: #1eb12aff; 

        }

            table, th, td { font-size: 0.95em; }
        th { font-weight: bold; }
        td { font-weight: normal; }
        tr:nth-child(even) { background-color: #f2f2f2; }
        tr:hover { background-color: #e0f7fa; }
        .btn-login { 
            display: block; 
            width: 50%; 
            text-align: center;
            background-color: #1eb12aff; 
            color: white; 
            padding: 10px; 
            border: none; 
            border-radius: 5px; 
            cursor: pointer; 
        }
        .btn-login:focus, .btn-login:active { outline: none; }
        .btn-login:focus { box-shadow: 0 0 0 2px rgba(20, 226, 38, 0.5); }
        .btn-login:hover { background-color: #0ea033ff; }
    
    </style>
</head>
<body>
    <div class="container">
        <h2>Rekap Skor Peserta AKM</h2>
        <?php if ($pesan_error): ?>
            <div class="error"><?= htmlspecialchars($pesan_error) ?></div>
        <?php endif; ?>
        <table>
            <tr>
                <th>No</th>
                <th>Username</th>
                <th>Skor Ganda B</th>
                <th>Skor Komplek</th>
                <th>Skor Jodoh</th>
                <th>Skor Benar/Salah</th>
                <th>Total Skor</th>
            </tr>
            <?php
            if (!$pesan_error && count($peserta) > 0) {
                $no = 1;
                foreach ($peserta as $user) {
                    // Skor tiap jenis
                    $skor_ganda = $mysqli->query("SELECT SUM(skor) FROM hasil_ganda_b WHERE username='$user'");
                    $skor_komplek = $mysqli->query("SELECT SUM(skor) FROM hasil_komplek WHERE username='$user'");
                    $skor_jodoh = $mysqli->query("SELECT SUM(skor) FROM hasil_jodoh WHERE username='$user'");
                    $skor_bs = $mysqli->query("SELECT SUM(skor) FROM hasil_bs WHERE username='$user'");

                    // Ambil hasil query sekali saja dan simpan di variabel
                    $row_ganda = $skor_ganda->fetch_row();
                    $row_komplek = $skor_komplek->fetch_row();
                    $row_jodoh = $skor_jodoh->fetch_row();
                    $row_bs = $skor_bs->fetch_row();

                    // Gunakan variabel tadi untuk mengecek dan mengambil nilai.
                    // Jika hasilnya NULL (tidak ada skor), maka nilainya 0.
                    $sg = $row_ganda[0] ?? 0;
                    $sk = $row_komplek[0] ?? 0;
                    $sj = $row_jodoh[0] ?? 0;
                    $sb = $row_bs[0] ?? 0;
                    
                    $total = $sg + $sk + $sj + $sb;
                    
                    echo "<tr>
                        <td>$no</td>
                        <td>".htmlspecialchars($user)."</td>
                        <td>$sg</td>
                        <td>$sk</td>
                        <td>$sj</td>
                        <td>$sb</td>
                        <td><b>$total</b></td>
                    </tr>";
                    $no++;
                }
            } else if (!$pesan_error) {
                echo "<tr><td colspan='7'>Tidak ada data peserta.</td></tr>";
            }
            ?>
        </table>
        <form method="get" action="login.php">
            <button type="submit" class="btn-login">Kembali ke Login</button>
        </form>
        </div>
    </div>
</body>
</html>