<?php
session_start();
if (!isset($_SESSION["user"])) {
    header("Location: login.php");
    exit();
}
$user = $_SESSION["user"];

// Koneksi database
$mysqli = new mysqli("localhost", "lnibbicy_kka5", "magetan#2", "lnibbicy_kka5");
if ($mysqli->connect_error) {
    die("Koneksi gagal: " . $mysqli->connect_error);
}

// Cek status kuis
$stmt_status = $mysqli->prepare("SELECT status_kuis_komplek FROM users WHERE username = ?");
$stmt_status->bind_param("s", $user);
$stmt_status->execute();
$result_status = $stmt_status->get_result();
$user_data = $result_status->fetch_assoc();
$stmt_status->close();

if ($user_data && $user_data['status_kuis_komplek'] == 'selesai') {
    // Hitung total skor dari semua soal komplek
    $stmt_total = $mysqli->prepare("SELECT SUM(skor) AS total_skor FROM hasil_komplek WHERE username = ?");
    $stmt_total->bind_param("s", $user);
    $stmt_total->execute();
    $result_total = $stmt_total->get_result();
    $total_row = $result_total->fetch_assoc();
    $total_skor = $total_row['total_skor'] ?? 0;
    $stmt_total->close();

    if ($total_skor > 0) {
        // Jika total skor > 0, redirect ke jodoh.php
        header("Location: jodoh.php?status=sudah_selesai");
        exit();
    } else {
        // Jika total skor <= 0, reset kuis: hapus hasil dan status, izinkan dikerjakan lagi
        $stmt_delete = $mysqli->prepare("DELETE FROM hasil_komplek WHERE username = ?");
        $stmt_delete->bind_param("s", $user);
        $stmt_delete->execute();
        $stmt_delete->close();

        $stmt_reset = $mysqli->prepare("UPDATE users SET status_kuis_komplek = '' WHERE username = ?");
        $stmt_reset->bind_param("s", $user);
        $stmt_reset->execute();
        $stmt_reset->close();

        // Hapus session terkait soal
        unset($_SESSION['komplek_soal_urut']);
        unset($_SESSION['komplek_soal_index']);
    }
}

// Ambil semua soal sekali saja, lalu simpan urutannya di session
if (!isset($_SESSION['komplek_soal_urut'])) {
    $sql = "SELECT * FROM komplek_soal ORDER BY id ASC";
    $result = $mysqli->query($sql);
    $semua_soal = [];
    while ($row = $result->fetch_assoc()) {
        $semua_soal[] = $row;
    }
    $_SESSION['komplek_soal_urut'] = $semua_soal;
    $_SESSION['komplek_soal_index'] = 0;
}

$soal_list = $_SESSION['komplek_soal_urut'];
$total_soal = count($soal_list);

// Ambil semua id soal untuk navigasi
$all_soals = array_column($soal_list, 'id');

// Ambil semua id soal yang sudah dijawab user
$answered = [];
$sql_jawab = "SELECT id_soal FROM hasil_komplek WHERE username=?";
$stmt_jawab = $mysqli->prepare($sql_jawab);
$stmt_jawab->bind_param("s", $user);
$stmt_jawab->execute();
$result_jawab = $stmt_jawab->get_result();
while ($row_jawab = $result_jawab->fetch_assoc()) {
    $answered[] = $row_jawab['id_soal'];
}
$stmt_jawab->close();

// Jika memilih soal pada navigator, kembalikan ke soal terakhir yang sudah dikerjakan
if (isset($_GET['no']) && is_numeric($_GET['no'])) {
    $selected_no = intval($_GET['no']);
    // Cari soal terakhir yang sudah dijawab
    $sql_last = "SELECT id_soal FROM hasil_komplek WHERE username=? ORDER BY waktu DESC LIMIT 1";
    $stmt_last = $mysqli->prepare($sql_last);
    $stmt_last->bind_param("s", $user);
    $stmt_last->execute();
    $result_last = $stmt_last->get_result();
    if ($row_last = $result_last->fetch_assoc()) {
        // Temukan index soal terakhir yang dijawab
        $last_id = $row_last['id_soal'];
        foreach ($soal_list as $idx => $soal_item) {
            if ($soal_item['id'] == $last_id) {
                $_SESSION['komplek_soal_index'] = $idx;
                break;
            }
        }
    } else {
        // Jika belum ada jawaban, tetap ke soal yang dipilih
        $_SESSION['komplek_soal_index'] = $selected_no;
    }
    $stmt_last->close();
}

$index = $_SESSION['komplek_soal_index'];

// Jika indeks soal sudah mencapai akhir, cek apakah semua soal sudah dijawab
if ($index >= $total_soal && $total_soal > 0) {
    // Cek apakah semua soal sudah dijawab oleh user
    $stmt_cek = $mysqli->prepare("SELECT COUNT(*) AS jumlah FROM hasil_komplek WHERE username = ?");
    $stmt_cek->bind_param("s", $user);
    $stmt_cek->execute();
    $result_cek = $stmt_cek->get_result();
    $row_cek = $result_cek->fetch_assoc();
    $stmt_cek->close();

    if ($row_cek['jumlah'] < $total_soal) {
        // Jika masih ada soal yang belum dijawab, kembalikan ke soal pertama yang belum dijawab
        foreach ($soal_list as $i => $soal_item) {
            $stmt_cek2 = $mysqli->prepare("SELECT COUNT(*) AS jumlah FROM hasil_komplek WHERE username = ? AND id_soal = ?");
            $stmt_cek2->bind_param("si", $user, $soal_item['id']);
            $stmt_cek2->execute();
            $result_cek2 = $stmt_cek2->get_result();
            $row_cek2 = $result_cek2->fetch_assoc();
            $stmt_cek2->close();
            if ($row_cek2['jumlah'] == 0) {
                $_SESSION['komplek_soal_index'] = $i;
                header("Location: komplek.php");
                exit();
            }
        }
    } else {
        // Semua soal sudah dijawab, baru boleh lanjut ke jodohkan
        $stmt_update = $mysqli->prepare("UPDATE users SET status_kuis_komplek = 'selesai' WHERE username = ?");
        $stmt_update->bind_param("s", $user);
        $stmt_update->execute();
        $stmt_update->close();

        unset($_SESSION['komplek_soal_urut']);
        unset($_SESSION['komplek_soal_index']);

        header("Location: jodoh.php");
        exit();
    }
}

// Proses jawaban
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $jawaban_user = isset($_POST['jawaban']) ? $_POST['jawaban'] : [];
    $id_soal_dijawab = $soal_list[$index]['id'];

    $jawaban_benar = explode(",", $soal_list[$index]['jawaban_benar']);
    sort($jawaban_benar);
    $jawaban_user_sorted = $jawaban_user;
    sort($jawaban_user_sorted);

    // Hitung skor: jumlah skorN untuk setiap jawaban user yang benar
    $total_skor = 0;
    foreach ($jawaban_user as $jawab) {
        if (in_array($jawab, $jawaban_benar)) {
            $skor_field = 'skor' . $jawab;
            if (isset($soal_list[$index][$skor_field])) {
                $total_skor += intval($soal_list[$index][$skor_field]);
            }
        }
    }

    $status = ($jawaban_user_sorted == $jawaban_benar) ? 'benar' : 'salah';

    // Hapus jawaban lama (jika ada)
    $stmt = $mysqli->prepare("DELETE FROM hasil_komplek WHERE username=? AND id_soal=?");
    $stmt->bind_param("si", $user, $id_soal_dijawab);
    $stmt->execute();
    $stmt->close();

    // Simpan jawaban baru
    $jawaban_user_str = implode(",", $jawaban_user);
    $stmt = $mysqli->prepare("INSERT INTO hasil_komplek (username, id_soal, jawaban_user, skor, status, waktu) VALUES (?, ?, ?, ?, ?, NOW())");
    $stmt->bind_param("sisis", $user, $id_soal_dijawab, $jawaban_user_str, $total_skor, $status);
    $stmt->execute();
    $stmt->close();

    $_SESSION['komplek_soal_index']++;
    echo "<script>window.location.href=window.location.pathname;</script>";
    exit();
}

$soal = $soal_list[$index];

$opsi = [];
for ($i = 1; $i <= 4; $i++) {
    if (!empty($soal["jawaban$i"])) {
        $opsi[] = [
            'value' => $i,
            'text' => $soal["jawaban$i"]
        ];
    }
}
shuffle($opsi);

// Ambil jawaban yang sudah diisi user untuk soal ini
$jawaban_terisi = [];
$stmt_jawab = $mysqli->prepare("SELECT jawaban_user FROM hasil_komplek WHERE username=? AND id_soal=?");
$stmt_jawab->bind_param("si", $user, $soal['id']);
$stmt_jawab->execute();
$result_jawab = $stmt_jawab->get_result();
if ($row_jawab = $result_jawab->fetch_assoc()) {
    $jawaban_terisi = explode(',', $row_jawab['jawaban_user']);
}
$stmt_jawab->close();
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Soal Pilihan Ganda Kompleks</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body {
            background: linear-gradient(135deg, #5763efff 0%, #071728ff 100%);
            font-family: 'Open Sans', 'Comic Sans MS', Arial;
            margin: 0;
            padding: 0;
            color: #333;
            line-height: 1.6;
        }
        .container-komplek {
            max-width: 1100px;
            width: 95vw;
            min-height: 100vh;
            margin: 40px auto;
            background-image: url('images/logo hp.png');
            background-size: cover;
            background-repeat: no-repeat;
            -webkit-backdrop-filter: blur(9px);
            border-radius: 9px;
            box-shadow: 0 12px 24px rgba(0, 0, 0, 0.08);
            padding: 36px 24px;
            background-color: rgba(255, 255, 255, 0.85);
            display: flex;
            flex-direction: column;
            justify-content: flex-start;
        }
        h2 {
            color: #1976d2;
            text-align: center;
            margin-bottom: 18px;
            letter-spacing: 1px;
        }
        .user-info {
            color: #1976d2;
            font-size: 1em;
            margin-bottom: 18px;
        }
        .soal-komplek-row {
            display: flex;
            flex-direction: row;
            gap: 32px;
            align-items: flex-start;
            justify-content: space-between;
        }
        .komplek-kiri {
            flex: 1 1 55%;
        }
        .komplek-kanan {
            flex: 1 1 45%;
            text-align: left;
        }
        .gambar-soal img {
            width: 100%;
            max-width: 800px;
            height: auto;
            border-radius: 9px;
            display: block;
            margin: 0 auto 24px;
        }
        .judul-komplek, .pertanyaan-komplek, .tanya-komplek {
            margin-bottom: 18px;
            color: #333;
        }
        .judul-komplek {
            font-size: 1.2em;
            font-weight: bold;
            text-align: center;
        }
        .pertanyaan-komplek {
            font-size: 1.3em;
            text-align: justify;
        }
        .tanya-komplek {
            font-size: 1.3em;
            font-weight: bold;
        }
        .opsi-komplek label {
            display: block;
            background: #f5faff;
            font-size: 1.3em;
            border-radius: 8px;
            padding: 10px 14px;
            margin-bottom: 10px;
            border: 1px solid #e3eafc;
            cursor: pointer;
        }
        .opsi-komplek input[type="checkbox"] {
            margin-right: 12px;
            accent-color: #1976d2;
        }
        .opsi-komplek label:hover {
            background: #e3f2fd;
            border-color: #90caf9;
        }
        button[type="submit"] {
            background: #1f8efdff;
            color: #fff;
            border: none;
            border-radius: 8px;
            padding: 12px 32px;
            font-size: 1.1em;
            font-weight: 500;
            cursor: pointer;
            margin-top: 18px;
            display: block;
            margin-left: auto;
            margin-right: auto;
        }
        button[type="submit"]:hover {
            background: #005bc4ff;
        }
        .navigasi-soal {
            margin-bottom: 24px;
            text-align: center;
        }
        .navigasi-soal a, .navigasi-soal span {
            display: inline-block;
            padding: 10px 12px;
            font-size: 20px;
            width: 32px;
            height: 32px;
            line-height: 32px;
            margin: 2px 3px;
            border-radius: 15%;
            font-weight: bold;
            text-decoration: none;
        }
        .navigasi-soal a {
            background: #e3f2fd;
            color: #1976d2;
            border: 1.5px solid #1976d2;
        }
        .navigasi-soal a.dijawab {
            background: #43cea2;
            color: #fff;
            border-color: #18A57A;
        }
        .navigasi-soal span.aktif {
            background: orange;
            color: #fff;
            border: 1.5px solid #E69500;
        }
        @media (max-width: 900px) {
            .container-komplek {
                max-width: 98vw;
                padding: 10px 2vw;
                margin: 0;
                border-radius: 0;
            }
            .soal-komplek-row {
                flex-direction: column;
                gap: 0;
            }
            .komplek-kiri, .komplek-kanan {
                width: 100%;
                flex: unset;
            }
        }
        @media (max-width: 400px) {
            body {
                background: white;
            }
            .container-komplek {
                margin: 24px 12px;
                padding: 1px 1px;
            }
            .navigasi-soal a, .navigasi-soal span {
                padding: 15px 12px;
                font-size: 18px;
            }
            .gambar-soal img {
                height: 240px;
                max-width: 100%;
                max-height: 300px;
            }
            .pertanyaan-komplek {
                text-align: justify;
            }
        }
    </style>
</head>
<body>
    <div class="container-komplek">
        <h2>Soal Pilihan Ganda Kompleks</h2>
        <div class="user-info">User: <b><?= htmlspecialchars($user) ?></b></div>
        <div style="margin-bottom:12px; color:#1976d2; font-size:1.08em;">
            Soal <?= ($index + 1) ?> dari <?= $total_soal ?>
        </div>
        <div class="navigasi-soal">
            Navigasi Soal<br>
            <?php foreach ($soal_list as $nav_index => $s): 
                $classes = [];
                // Cek jika soal sudah dijawab
                $stmt_check = $mysqli->prepare("SELECT COUNT(*) AS cnt FROM hasil_komplek WHERE username=? AND id_soal=?");
                $stmt_check->bind_param("si", $user, $s['id']);
                $stmt_check->execute();
                $result_check = $stmt_check->get_result();
                $row_check = $result_check->fetch_assoc();
                if ($row_check['cnt'] > 0) {
                    $classes[] = "dijawab";
                }
                if ($nav_index == $index) {
                    $classes[] = "aktif";
                }
                $class_attr = count($classes) > 0 ? 'class="' . implode(" ", $classes) . '"' : '';
                $stmt_check->close();
            ?>
                <a href="?no=<?= $nav_index ?>" <?= $class_attr ?>><?= $nav_index + 1 ?></a>
            <?php endforeach; ?>
        </div>
        <form method="post" action="" autocomplete="off">
            <div class="soal-komplek-row">
                <div class="komplek-kanan">
                    <div class="judul-komplek"><?= htmlspecialchars($soal['judul']) ?></div>
                    <?php if (!empty($soal['gambar'])): ?>
                    <div class="gambar-soal">
                        <img src="<?= htmlspecialchars($soal['gambar']) ?>" alt="">
                    </div>
                    <?php endif; ?>
                    <div class="pertanyaan-komplek"><?= nl2br(htmlspecialchars($soal['pertanyaan'])) ?></div>
                </div>
                <div class="komplek-kiri">
                    <div class="tanya-komplek"><?= htmlspecialchars($soal['tanya']) ?></div>
                    <div class="opsi-komplek">
                        <?php foreach ($opsi as $ops): ?>
                        <label>
                            <input type="checkbox" name="jawaban[]" value="<?= $ops['value'] ?>"
                                   <?= in_array($ops['value'], $jawaban_terisi) ? 'checked' : '' ?>>
                            <?= htmlspecialchars($ops['text']) ?>
                        </label>
                        <?php endforeach; ?>
                    </div>
                    <button type="submit">Kirim Jawaban</button>
                </div>
            </div>
        </form>
    </div>
</body>
</html>