
<?php
$pesan = "";
$mysqli = new mysqli("localhost", "lnibbicy_kka5", "magetan#2", "lnibbicy_kka5");
if ($mysqli->connect_error) {
    die("Koneksi gagal: " . $mysqli->connect_error);
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (isset($_POST['hapus_semua'])) {
        // Hapus hasil_jodoh terlebih dahulu agar tidak melanggar foreign key
        $mysqli->query("DELETE FROM hasil_jodoh");
        // Hapus semua data jodoh_soal
        $del = $mysqli->query("DELETE FROM jodoh_soal");
        if ($del) {
            $pesan = "<span style='color:green;'>Seluruh data soal & hasil berhasil dihapus!</span>";
        } else {
            $pesan = "<span style='color:red;'>Gagal menghapus data: " . $mysqli->error . "</span>";
        }
    } else {
        $judul = $_POST["judul"];
        $pertanyaan = $_POST["pertanyaan"];
        $kolom_kiri = array_filter(array_map('trim', $_POST["kolom_kiri"]));
        $kolom_kanan = array_filter(array_map('trim', $_POST["kolom_kanan"]));
        $jawaban_benar = [];

        foreach ($_POST["jawaban_benar"] as $i => $j) {
            if ($j !== "") {
                $jawaban_benar[$i] = is_numeric($j) ? intval($j) : $j;
            }
        }

        // Tambahkan input skor_j
        $skor_j = isset($_POST["skor_j"]) ? intval($_POST["skor_j"]) : 0;

        // Upload gambar jika ada
        $gambar = '';
        if (isset($_FILES['gambar']) && $_FILES['gambar']['error'] == UPLOAD_ERR_OK) {
            $upload_dir = 'uploads/';
            if (!is_dir($upload_dir)) {
                mkdir($upload_dir, 0777, true);
            }
            $gambar = $upload_dir . basename($_FILES['gambar']['name']);
            move_uploaded_file($_FILES['gambar']['tmp_name'], $gambar);
        }

        $stmt = $mysqli->prepare("INSERT INTO jodoh_soal (judul, pertanyaan, kolom_kiri, kolom_kanan, jawaban_benar, gambar, skor_j) VALUES (?, ?, ?, ?, ?, ?, ?)");
        $json_kiri = json_encode(array_values($kolom_kiri));
        $json_kanan = json_encode(array_values($kolom_kanan));
        $json_jawab = json_encode($jawaban_benar);
        $stmt->bind_param("ssssssi", $judul, $pertanyaan, $json_kiri, $json_kanan, $json_jawab, $gambar, $skor_j);

        if ($stmt->execute()) {
            $pesan = "<span style='color:green;'>Soal menjodohkan berhasil ditambahkan!</span>";
        } else {
            $pesan = "<span style='color:red;'>Gagal menambah soal: " . $stmt->error . "</span>";
        }
        $stmt->close();
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Input Soal Menjodohkan</title>
    <style>
/* Tambahkan di bagian <style> pada file input_jodoh.php */
body {
    background: linear-gradient(135deg, #e0f7fa 0%, #80deea 100%);
    font-family: 'Segoe UI', Arial, sans-serif;
    margin: 0;
    padding: 0;
    min-height: 100vh;
    color: #333;
}
.container-jodoh {
    background: #fff;
    max-width: 700px;
    margin: 40px auto;
    border-radius: 14px;
    box-shadow: 0 8px 32px rgba(0,0,0,0.18);
    padding: 32px 24px;
}
h2 {
    color: #00796b;
    text-align: center;
    margin-bottom: 20px;
    letter-spacing: 1px;
}
label {
    font-weight: 600;
    color: #00796b;
    margin-top: 10px;
    margin-bottom: 6px;
    display: block;
}
.msg {
    text-align: center;
    margin-bottom: 20px;
    font-size: 1.1em;
}
input[type="text"], input[type="number"], textarea {
    width: 98%;
    padding: 8px;
    border: 1px solid #b2dfdb;
    border-radius: 6px;
    margin-bottom: 10px;
    font-size: 1em;
}
input[type="file"] {
    margin-bottom: 10px;
}
.jodoh-table {
    width: 100%;
    border-collapse: collapse;
    margin-bottom: 18px;
}
.jodoh-table th, .jodoh-table td {
    border: 1px solid #b2dfdb;
    padding: 8px;
    text-align: left;
}
.jodoh-table th {
    background: #e0f2f1;
    color: #00796b;
}
.jodoh-table td {
    background: #f1f8e9;
}
select {
    width: 100%;
    padding: 6px;
    border-radius: 6px;
    border: 1px solid #b2dfdb;
}
button[type="submit"] {
    background: #00796b;
    color: #fff;
    border: none;
    border-radius: 8px;
    padding: 12px 20px;
    font-size: 1.1em;
    font-weight: 600;
    cursor: pointer;
    margin-top: 18px;
}
button[type="submit"]:hover {
    background: #004d40;
}
button[type="button"] {
    background: #80cbc4;
    color: #333;
    border: none;
    border-radius: 8px;
    padding: 8px 16px;
    font-size: 1em;
    font-weight: 500;
    cursor: pointer;
    margin-right: 8px;
    margin-top: 8px;
}
button[type="button"]:hover {
    background: #26a69a;
    color: #fff;
}
@media (max-width: 600px) {
    .container-jodoh {
        padding: 16px 6px;
    }
    h2 {
        font-size: 1.1em;
    }
    .jodoh-table th, .jodoh-table td {
        font-size: 0.95em;
        padding: 6px;
    }
    button[type="submit"], button[type="button"] {
        width: 100%;
        margin-top: 10px;
    }
}    </style>
    <script>
    // Fungsi untuk menambah baris baru (kolom kiri, kolom kanan, dan select jodoh)
    function tambahBaris() {
        const tbody = document.getElementById('tbody-jodoh');
        const rowCount = tbody.rows.length;
        const row = tbody.insertRow();
        // Kolom kiri
        let cell1 = row.insertCell(0);
        cell1.innerHTML = '<input type="text" name="kolom_kiri[]" required>';
        // Kolom kanan
        let cell2 = row.insertCell(1);
        cell2.innerHTML = '<input type="text" name="kolom_kanan[]" required>';
        // Select jodohkan
        let cell3 = row.insertCell(2);
        cell3.innerHTML = '<select name="jawaban_benar['+rowCount+']" required><option value="">-- Pilih Jodoh --</option></select>';
        updatePilihanJodoh();
    }

    // Fungsi untuk menambah satu kolom kanan (input) di baris terakhir saja
    function tambahKolomKanan() {
        const tbody = document.getElementById('tbody-jodoh');
        if (tbody.rows.length === 0) return;
        let lastRow = tbody.rows[tbody.rows.length - 1];
        let cell = lastRow.cells[1];
        let input = document.createElement('input');
        input.type = 'text';
        input.name = 'kolom_kanan[]';
        input.required = true;
        cell.appendChild(document.createElement('br'));
        cell.appendChild(input);
        updatePilihanJodoh();
    }

    // Fungsi untuk update pilihan pada select jodohkan
    function updatePilihanJodoh() {
        const tbody = document.getElementById('tbody-jodoh');
        // Ambil semua kolom kanan
        let kolomKanan = [];
        for (let i = 0; i < tbody.rows.length; i++) {
            let inputs = tbody.rows[i].cells[1].querySelectorAll('input[type="text"]');
            inputs.forEach(input => {
                if (input.value.trim() !== '') kolomKanan.push(input.value.trim());
            });
        }
        // Update semua select
        for (let i = 0; i < tbody.rows.length; i++) {
            let select = tbody.rows[i].cells[2].querySelector('select');
            let selected = select.value;
            select.innerHTML = '<option value="">-- Pilih Jodoh --</option>';
            kolomKanan.forEach((val, idx) => {
                let opt = document.createElement('option');
                opt.value = idx+1;
                opt.text = val;
                select.appendChild(opt);
            });
            // Kembalikan pilihan jika masih valid
            if (selected && select.querySelector('option[value="'+selected+'"]')) {
                select.value = selected;
            }
        }
    }

    // Update pilihan jodoh saat input kolom kanan berubah
    document.addEventListener('input', function(e) {
        if (e.target && e.target.name === 'kolom_kanan[]') {
            updatePilihanJodoh();
        }
    });
    </script>
</head>
<body>
    <div class="container-jodoh">
        <h2>Input Soal Menjodohkan</h2>
        <div class="msg"><?= $pesan ?></div>
    <form method="post" autocomplete="off" enctype="multipart/form-data">
            <label>Judul:</label>
            <input type="text" name="judul" required><br>
            <label>Pertanyaan:</label>
            <textarea name="pertanyaan" required rows="3"></textarea><br>
            <label>Gambar:</label>
            <input type="file" name="gambar" accept="image/*"><br>
            <label>Skor Menjodohkan (skor_j):</label>
            <input type="number" name="skor_j" value="0" required><br>
            <table class="jodoh-table">
                <thead>
                    <tr>
                        <th>Kolom Kiri</th>
                        <th>Kolom Kanan</th>
                        <th>Jodohkan</th>
                    </tr>
                </thead>
                <tbody id="tbody-jodoh">
                    <?php for($i=0;$i<3;$i++): ?>
                    <tr>
                        <td><input type="text" name="kolom_kiri[]" required></td>
                        <td><input type="text" name="kolom_kanan[]" required></td>
                        <td>
                            <select name="jawaban_benar[<?= $i ?>]" required>
                                <option value="">-- Pilih Jodoh --</option>
                            </select>
                        </td>
                    </tr>
                    <?php endfor; ?>
                </tbody>
            </table>
            <button type="button" onclick="tambahBaris()">Tambah Baris</button>
            <button type="button" onclick="tambahKolomKanan()">Tambah Kolom Kanan Saja</button>
            <button type="submit">Simpan Soal</button>
        </form>
        <form method="post" onsubmit="return confirm('Yakin ingin menghapus semua data soal?');" style="margin-top:18px; text-align:center;">
            <input type="hidden" name="hapus_semua" value="1">
            <button type="submit" style="background:#d32f2f; color:#fff; border:none; border-radius:8px; padding:10px 32px; font-size:1.1em; font-weight:500; cursor:pointer;">Hapus Semua Data</button>
        </form>
    </div>
</body>
</html>