<?php
// filepath: /opt/lampp/htdocs/soal_online/input_bs.php
$pesan = "";
$mysqli = new mysqli("localhost", "lnibbicy_kka5", "magetan#2", "lnibbicy_kka5");
if ($mysqli->connect_error) {
    die("Koneksi gagal: " . $mysqli->connect_error);
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (isset($_POST['hapus_semua'])) {
        // Hapus semua data benar_salah
        $del = $mysqli->query("DELETE FROM benar_salah");
        if ($del) {
            $pesan = "<span style='color:green;'>Seluruh data soal berhasil dihapus!</span>";
        } else {
            $pesan = "<span style='color:red;'>Gagal menghapus data: " . $mysqli->error . "</span>";
        }
    } else {
        $pernyataan = $_POST["pernyataan"];
        $jawaban_benar = $_POST["jawaban_benar"];

        // Upload gambar jika ada
        $gambar = "";
        if (isset($_FILES["gambar"]) && $_FILES["gambar"]["error"] == UPLOAD_ERR_OK) {
            $target_dir = "uploads/";
            if (!is_dir($target_dir)) mkdir($target_dir, 0777, true);
            $target_file = $target_dir . basename($_FILES["gambar"]["name"]);
            if (move_uploaded_file($_FILES["gambar"]["tmp_name"], $target_file)) {
                $gambar = $target_file;
            }
        }

        $stmt = $mysqli->prepare("INSERT INTO benar_salah (pernyataan, jawaban_benar, gambar) VALUES (?, ?, ?)");
        $stmt->bind_param("sss", $pernyataan, $jawaban_benar, $gambar);

        if ($stmt->execute()) {
            $pesan = "<span style='color:green;'>Soal berhasil ditambahkan!</span>";
        } else {
            $pesan = "<span style='color:red;'>Gagal menambah soal: " . $stmt->error . "</span>";
        }
        $stmt->close();
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Input Soal Benar/Salah</title>
    <style>
        body { font-family: Arial, sans-serif; background: #f7fbff; }
        .container { max-width: 600px; margin: 40px auto; background: #fff; border-radius: 12px; box-shadow: 0 4px 16px #1976d233; padding: 32px 24px; }
        h2 { color: #1976d2; text-align: center; }
        label { font-weight: 500; color: #1976d2; margin-top: 10px; display: block; }
        input[type="text"], textarea, select {
            width: 95%;
            padding: 8px;
            margin: 6px 0 12px 0;
            border: 1px solid #b3c6e0;
            border-radius: 6px;
            font-size: 1em;
            background: #f7fbff;
        }
        input[type="file"] {
            margin: 6px 0 12px 0;
        }
        button[type="submit"] {
            background: #1976d2;
            color: #fff;
            border: none;
            border-radius: 8px;
            padding: 10px 32px;
            font-size: 1.1em;
            font-weight: 500;
            cursor: pointer;
            margin-top: 18px;
        }
        button[type="submit"]:hover {
            background: #1565c0;
        }
        .msg { text-align: center; margin-bottom: 18px; font-size: 1.08em; }
    </style>
</head>
<body>
    <div class="container">
        <h2>Input Soal Benar/Salah</h2>
        <div class="msg"><?= $pesan ?></div>
    <form method="post" autocomplete="off" enctype="multipart/form-data">
            <label>Upload Gambar (opsional):</label>
            <input type="file" name="gambar" accept="image/*">
            <label>Pernyataan:</label>
            <textarea name="pernyataan" required rows="3"></textarea>
            <label>Jawaban Benar:</label>
            <select name="jawaban_benar" required>
                <option value="">-- Pilih Jawaban --</option>
                <option value="Benar">Benar</option>
                <option value="Salah">Salah</option>
            </select>
            <button type="submit">Simpan Soal</button>
        </form>
        <form method="post" onsubmit="return confirm('Yakin ingin menghapus semua data soal?');" style="margin-top:18px; text-align:center;">
            <input type="hidden" name="hapus_semua" value="1">
            <button type="submit" style="background:#d32f2f; color:#fff; border:none; border-radius:8px; padding:10px 32px; font-size:1.1em; font-weight:500; cursor:pointer;">Hapus Semua Data</button>
        </form>
    </div>
</body>
</html>