<?php
session_start();
if (!isset($_SESSION["user"])) {
    header("Location: login.php");
    exit();
}
$user = htmlspecialchars($_SESSION["user"]);

// Koneksi database
$mysqli = new mysqli("localhost", "root", "", "matematika");
if ($mysqli->connect_error) {
    die("Koneksi gagal: " . $mysqli->connect_error);
}

// Cek jika mapel dipilih
$mapel = $_GET['mapel'] ?? null;
$no = isset($_GET['no']) ? (int)$_GET['no'] : 1;
$selesai = false;

// Konfigurasi tabel dan filter mapel
$tabel = '';
$filter_mapel = '';
if ($mapel == 'matematika') {
    $tabel = 'mat';
    $filter_mapel = "mapel='matematika'";
} elseif ($mapel == 'bindo') {
    $tabel = 'bind';
    $filter_mapel = "mapel='bindo'";
} elseif ($mapel == 'pancasila') {
    $tabel = 'pancasila';
    $filter_mapel = "mapel='pancasila'";
} elseif ($mapel == 'ipas') {
    $tabel = 'ipas';
    $filter_mapel = "mapel='ipas'";
} elseif ($mapel == 'bing') {
    $tabel = 'bing';
    $filter_mapel = "mapel='bing'";
} elseif ($mapel == 'jawa') {
    $tabel = 'jawa';
    $filter_mapel = "mapel='jawa'";
} elseif ($mapel == 'seni') {
    $tabel = 'seni';
    $filter_mapel = "mapel='seni'";
} elseif ($mapel == 'inggris') {
    $tabel = 'inggris';
    $filter_mapel = "mapel='inggris'";
} elseif ($mapel == 'akm') {
    $tabel = 'akm';
    $filter_mapel = "mapel='akm'";
} else {
    $tabel = null; // Tidak ada mapel yang valid
}

// Variabel untuk skor dan total soal (agar tetap bisa diakses setelah session di-unset)
$skor = 0;
$total_soal = 0;

if ($tabel) {
    // Ambil semua id soal BERURUTAN, simpan di session per mapel
    $session_key = 'soal_ids_' . $mapel;
    $session_skor = 'skor_' . $mapel;
    if (!isset($_SESSION[$session_key])) {
        $result = $mysqli->query("SELECT id FROM $tabel WHERE $filter_mapel ORDER BY id ASC LIMIT 15");
        if (!$result) {
            die("Query error: " . $mysqli->error . "
            <br>
            SQL: SELECT id FROM $tabel WHERE $filter_mapel ORDER BY id ASC LIMIT 15");
        }
        $ids = [];
        while ($row = $result->fetch_assoc()) {
            $ids[] = $row['id'];
        }
        if (empty($ids)) {
            die('<div style="text-align:center; font-size:2.2em; font-weight:bold; line-height:1.3; background: #fff; color:#222; border-radius:18px; box-shadow:0 4px 32px #72757499; padding:48px 32px; margin:60px auto; max-width:600px;">
                <span style="font-size:2.5em;display:block;margin-bottom:18px;">😔</span>
                <span style="font-size:1.2em; color:#222; letter-spacing:1px;">Oops!</span><br>
                <span style="font-size:1.1em; color:#222;">Maaf, ... untuk soal mapel <b>' . strtoupper($tabel) . '</b> belum tersedia.</span>
                <br><br>
                <span style="font-size:1.1em; color:#222;">.............</span>
                <br><br>
                <a href="index.php" class="login-btn" style="margin-top:16px; background:linear-gradient(90deg,#fff700 0%,#ffe259 100%); color:#222; border:2px solid #1157eeff; padding:12px 32px; border-radius:10px; font-size:1.1em; font-weight:bold; box-shadow:0 4px 16px #596cff99; text-decoration:none; display:inline-block;">
                    ⬅️ Kembali ke Home
                </a>
            </div>');
            
        }
        $_SESSION[$session_key] = $ids;
        $_SESSION[$session_skor] = 0;
    }
    $soal_ids = $_SESSION[$session_key];
    $total = count($soal_ids);
}

// --- Ambil jawaban user dari session untuk soal ini ---
$session_jawab_key = 'jawaban_user_' . $mapel;
$session_skor = 'skor_' . $mapel;
if (!isset($_SESSION[$session_jawab_key])) {
    $_SESSION[$session_jawab_key] = [];
}
if (!isset($_SESSION[$session_skor])) {
    $_SESSION[$session_skor] = 0;
}

// Simpan jawaban user jika submit
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["jawaban"])) {
    $_SESSION[$session_jawab_key][$no-1] = $_POST["jawaban"];

    // Cek jawaban benar untuk soal ini
    $id_soal = $soal_ids[$no-1];
    $jawaban_user_db = $_POST["jawaban"];
    $username = $user;
    $mapel_db = $mapel;

    // Ambil jawaban benar dari database
    $stmt = $mysqli->prepare("SELECT jawaban_benar FROM $tabel WHERE id=?");
    $stmt->bind_param("i", $id_soal);
    $stmt->execute();
    $stmt->bind_result($jawaban_benar);
    $stmt->fetch();
    $stmt->close();

   

    // Simpan jawaban ke database
    $stmt = $mysqli->prepare("INSERT INTO jawaban_user (username, mapel, id_soal, jawaban) VALUES (?, ?, ?, ?) ON DUPLICATE KEY UPDATE jawaban=?");
    if ($stmt) {
        $stmt->bind_param("ssiss", $username, $mapel_db, $id_soal, $jawaban_user_db, $jawaban_user_db);
        $stmt->execute();
        $stmt->close();
    }

    // Redirect agar tidak resubmit
    header("Location: index.php?mapel=$mapel&no=" . ($no + 1));
    exit();
}

$jawaban_user = $_SESSION[$session_jawab_key];
$jawaban_terpilih = isset($jawaban_user[$no-1]) ? $jawaban_user[$no-1] : '';

// Ambil soal ke-$no dari session, hanya jika $no masih dalam range soal
if ($tabel && !isset($soal) && $no <= $total) {
    $id_soal = $soal_ids[$no-1];
    $stmt = $mysqli->prepare("SELECT * FROM $tabel WHERE id=?");
    $stmt->bind_param("i", $id_soal);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result->num_rows > 0) {
        $soal = $result->fetch_assoc();
    } else {
        die("Soal dengan ID $id_soal tidak ditemukan.");
    }
    $stmt->close();
}

if ($tabel && $no > $total) {
    // Hitung skor dari jawaban terakhir peserta
    $skor = 0;
    $total_soal = isset($_SESSION[$session_key]) ? count($_SESSION[$session_key]) : (isset($total) ? $total : 0);
    $soal_ids_hasil = isset($soal_ids) ? $soal_ids : [];
    for ($i = 0; $i < $total_soal; $i++) {
        $id_soal = isset($soal_ids_hasil[$i]) ? $soal_ids_hasil[$i] : null;
        if (!$id_soal) continue;
        $stmt = $mysqli->prepare("SELECT jawaban_benar FROM $tabel WHERE id=?");
        $stmt->bind_param("i", $id_soal);
        $stmt->execute();
        $stmt->bind_result($jawaban_benar);
        $stmt->fetch();
        $stmt->close();
        $jawaban_peserta = isset($_SESSION[$session_jawab_key][$i]) ? $_SESSION[$session_jawab_key][$i] : '';
        if (trim(strtolower($jawaban_peserta)) == trim(strtolower($jawaban_benar))) {
            $skor++;
        }
    }
    $selesai = true;
    // Simpan hasil ke database
    $stmt = $mysqli->prepare("INSERT INTO hasil_user (username, mapel, skor, total_soal) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("ssii", $user, $mapel, $skor, $total_soal);
    $stmt->execute();
    $stmt->close();
    
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Home Kelas 5 Soal Online</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="style.css">


    
</head>
<body>

<!-- Alert Container -->
<div class="alert-container">
  <div id="custom-alert" style="display:none;">
    <div class="custom-alert-content" id="custom-alert-content"></div>
  </div>
</div>

<style>
.alert-container {
  width: 100vw;
  display: flex;
  justify-content: center;
  position: fixed;
  top: 0; left: 0; right: 0;
  z-index: 9999;
}
#custom-alert {
  width: 100%;
  display: flex;
  justify-content: center;
}
.custom-alert-content {
  margin-top: 32px;
  background: linear-gradient(90deg, #43e97b 0%, #38f9d7 100%);
  color: #fff;
    font-family: 'Arial', sans-serif;
    font-size: 1.2em;
    padding: 16px 32px;
  font-size: 1.15em;
  line-height: 1.4;
  border-radius: 12px;
  box-shadow: 0 4px 24px #38f9d799;
  font-weight: bold;
  letter-spacing: 0.5px;
  animation: fadeInDown 0.5s;
  min-width: 280px;
  max-width: 90vw;
  text-align: center;
  transition: box-shadow 0.2s;
}
.custom-alert-content:hover {
  box-shadow: 0 8px 32px #38f9d7cc;
    transform: translateY(-2px);
    transition: transform 0.2s, box-shadow 0.2s;
    cursor: pointer;
    animation: fadeInDown 0.5s;

}
@keyframes fadeInDown {
  from { opacity: 0; transform: translateY(-40px);}
  to   { opacity: 1; transform: translateY(0);}

}
.custom-alert-content:before {
  font-size: 1.5em;
    color: #fff;
    font-weight: bold;
    display: inline-block;
    vertical-align: middle;
    margin-top: -2px;
    margin-left: -8px;
    margin-top: -2px;
    margin-left: -8px;
    margin-top: -2px;
}
.custom-alert-content:after {
    color: #fff;
    font-weight: bold;
    display: inline-block;
    vertical-align: middle;
    margin-top: -2px;
    margin-left: -8px;
    margin-top: -2px;
    margin-left: -8px;
    margin-top: -2px;
}
.custom-alert-content:after {
    color: #fff;
    font-weight: bold;
    display: inline-block;
    vertical-align: middle;
    margin-top: -2px;
    margin-left: -8px;
    margin-top: -2px;
}
.custom-alert-content:before,
.custom-alert-content:after {
  font-size: 1.5em;
    color: #fff;
    font-weight: bold;
    display: inline-block;
    vertical-align: middle;
    margin-top: -2px;
    margin-left: -8px;
    margin-top: -2px;
    margin-left: 8px;
}
.custom-alert-content:hover:before,
.custom-alert-content:hover:after {
    color: #fff;
    }
.custom-alert-content:hover {
    box-shadow: 0 8px 32px #38f9d7cc;
    transform: translateY(-2px);
    transition: transform 0.2s, box-shadow 0.2s;
    animation: fadeInDown 0.5s;
}

</style>

<script>
let alertTimeout = null;
function showCustomAlert(msg, timeout = 2500) {
  const alertBox = document.getElementById('custom-alert');
  const alertContent = document.getElementById('custom-alert-content');
  alertContent.innerHTML = msg;
  alertBox.style.display = 'flex';

  // Clear timeout jika ada
  if (alertTimeout) clearTimeout(alertTimeout);

  // Sembunyikan alert setelah timeout, kecuali mouse di atas alert
  function hideAlert() {
    alertBox.style.display = 'none';
  }

  alertContent.onmouseenter = function() {
    if (alertTimeout) clearTimeout(alertTimeout);
  };
  alertContent.onmouseleave = function() {
    alertTimeout = setTimeout(hideAlert, 1200);
  };

  alertTimeout = setTimeout(hideAlert, timeout);
}
</script>

<div class="container">
    <div class="user-info">
        <strong style="font-size:1.3em;"><?= htmlspecialchars($user) ?></strong>
    </div>

    <div id="timer" style="font-size:1.2em; color:#d32f2f; font-weight:bold; margin-bottom:16px;"></div>
    <script>
    let timerKey = "timer_<?= $mapel ?>_<?= $user ?>";
    let timeLeft = localStorage.getItem(timerKey) ? parseInt(localStorage.getItem(timerKey)) : 1800; // 30 menit = 1800 detik
    const timerElement = document.getElementById('timer');

    function formatWaktu(s) {
        let m = Math.floor(s / 60);
        let d = s % 60;
        return (m < 10 ? "0" : "") + m + ":" + (d < 10 ? "0" : "") + d;
    }

    function updateTimer() {
        if (timeLeft <= 0) {
            timerElement.textContent = "Waktu Habis!";
            localStorage.removeItem(timerKey);
            showCustomAlert('Waktu habis, jawaban otomatis dikirim!', 3500);
            // Otomatis submit jika waktu habis
            if (document.getElementById('formJawaban')) {
                setTimeout(() => document.getElementById('formJawaban').submit(), 1200);
            } else {
                setTimeout(() => { window.location.href = "index.php?mapel=<?= $mapel ?>&no=<?= $no+1 ?>"; }, 1200);
            }
            return;
        }
        timerElement.textContent = "Sisa waktu: " + formatWaktu(timeLeft);
        localStorage.setItem(timerKey, timeLeft);
        timeLeft--;
    }

    updateTimer();
    let timerInterval = setInterval(updateTimer, 1000);

    // Reset timer jika user selesai/keluar mapel
    <?php if ($selesai || !$mapel): ?>
    localStorage.removeItem(timerKey);
    <?php endif; ?>
    </script>

<?php if (
    $mapel == 'matematika' ||
    $mapel == 'bindo' ||
    $mapel == 'pancasila' ||
    $mapel == 'ipas' ||
    $mapel == 'jawa'||
    $mapel == 'seni'||
    $mapel == 'bing' ||
    $mapel == 'akm' ||
    $mapel == 'inggris'
): ?>
    <h3>
        <?php
        if ($mapel == 'matematika') echo 'Matematika';
        elseif ($mapel == 'bindo') echo 'Bahasa Indonesia';
        elseif ($mapel == 'pancasila') echo 'Pendidikan Pancasila';
        elseif ($mapel == 'ipas') echo 'IPAS';
        elseif ($mapel == 'jawa') echo 'Bahasa Jawa';
        elseif ($mapel == 'seni') echo 'Seni Budaya';
        elseif ($mapel == 'bing') echo 'Bahasa Inggris';
        elseif ($mapel == 'akm') echo 'AKM (Asesmen Kompetensi Minimum)';
        elseif ($mapel == 'inggris') echo 'Bahasa Inggris';
        ?>
    </h3>
    <?php if ($selesai): ?>
    <div class="pertanyaan-besar" style="color:#007bff;font-size:1.3em;">
        <i class="fa fa-check-circle" style="color:green;"></i> Laporan/ Report Hasil Pengerjaan Soal
    </div>
    <div class="pertanyaan-besar" style="font-size:1.2em;">
        <i class="fa fa-trophy" style="color:gold;"></i> Ini adalah hasil pengerjaan semua pertanyaan:
    </div>
    <div class="pertanyaan-besar" style="font-size:1.1em;">
        <i class="fa fa-star" style="color:orange;"></i>
        <i class="fa fa-star" style="color:orange;"></i>
        <i class="fa fa-star" style="color:orange;"></i>
        <i class="fa fa-star" style="color:orange;"></i>
        <i class="fa fa-star" style="color:orange;"></i>
        <br>
        <i class="fa fa-check" style="color:green;"></i> Kamu telah menyelesaikan Soal ini! 🎉<br>
        <style>
        .score-display {
  max-width: 90%;
  width: 400px;
  margin: 40px auto;
  padding: 24px 20px;
  font-size: 2.2em;
  font-weight: 600;
  color: #1a237e;
  text-align: center;
  background-color: #fffbe7;
  border: 8px solid #c50000ff;
  border-radius: 16px;
  box-shadow: 0 4px 16px rgba(255, 160, 0, 0.2);
  transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.score-display:hover {
  transform: scale(1.03);
  box-shadow: 0 6px 24px rgba(255, 160, 0, 0.3);
}
        </style>
        <div class="score-display">
  Skor/Nilai kamu: <br>
  <strong><?= $skor ?></strong><br>
  dari <?= $total_soal ?> soal.
</div>
        <br>
        <i class="fa fa-list-alt" style="color:blue;"></i>
        <br>
        <strong>Rincian Skor:</strong><br>
        <ul>
            <li>Total Soal: <?= $total_soal ?></li>
            <li>Jawaban Benar: <?= $skor ?></li>
            <li>Jawaban Salah: <?= $total_soal - $skor ?></li>
        </ul>
        <?php
        if ($skor == $total_soal) {
            echo "Luar biasa! SEMUA JAWABAN BENAR! 🏆";
        } elseif ($skor >= ceil($total_soal/2)) {
            echo "Kerja bagus! Coba lagi untuk skor sempurna!";
        } else {
            echo "Jangan menyerah, terus berlatih ya!";
        }
        ?>
        <br><br>
        <strong>Detail Jawaban Peserta:</strong>
        <table border="1" cellpadding="6" cellspacing="0" style="margin:12px auto; border-collapse:collapse; background:#fff;">
            <tr style="background:#e3eaff;">
                <th>No</th>
                <th>Pertanyaan</th>
                <th>Jawaban Peserta</th>
                <th>Jawaban Benar</th>
                <th>Status</th>
            </tr>
            <?php
            // Ambil ulang id soal
            $soal_ids_hasil = isset($soal_ids) ? $soal_ids : [];
            for ($i = 0; $i < $total_soal; $i++) {
                $id_soal = $soal_ids_hasil[$i];
                // Ambil soal dan kunci
                $stmt = $mysqli->prepare("SELECT pertanyaan, jawaban_benar FROM $tabel WHERE id=?");
                $stmt->bind_param("i", $id_soal);
                $stmt->execute();
                $stmt->bind_result($pertanyaan, $jawaban_benar);
                $stmt->fetch();
                $stmt->close();
                $jawaban_peserta = isset($_SESSION[$session_jawab_key][$i]) ? $_SESSION[$session_jawab_key][$i] : '';
                $benar = (trim(strtolower($jawaban_peserta)) == trim(strtolower($jawaban_benar)));
                
                
echo '<tr>';
echo '<td style="text-align:center;">'.($i+1).'</td>';
echo '<td>'.htmlspecialchars($pertanyaan).'</td>';
echo '<td style="color:'.($benar ? 'green' : 'red').';word-break:break-word;white-space:pre-line;max-width:220px;">'.htmlspecialchars($jawaban_peserta).'</td>';
echo '<td>'.htmlspecialchars($jawaban_benar).'</td>';
echo '<td style="text-align:center;">'.($benar ? '<span style="color:green;">Benar</span>' : '<span style="color:red;">Salah</span>').'</td>';
echo '</tr>';
            }
            ?>
        </table>
        <?php unset($_SESSION[$session_jawab_key]); ?>
    </div>
    <div style="margin-top:24px;">
        <a href="index.php?mapel=<?= $mapel ?>&no=1" class="login-btn">Ulangi Kuis</a>
    </div>
    <div style="margin-top:32px;text-align:center;">
        <a href="logout.php" class="logout-button">Logout</a>
    </div>
    <script>
        function prevQuestion() {
            let currentNo = <?= isset($_GET['no']) ? (int) $_GET['no'] : 1 ?>;
            if (currentNo > 1) {
                window.location.href = "index.php?mapel=<?= $mapel ?>&no=" + (currentNo - 1);
            } else {
                showCustomAlert("Anda sudah berada di soal pertama.");
            }
        }
    </script>
    <?php elseif (isset($soal)): ?>
        <div class="container-flex-soal" style="display: flex; justify-content: center; align-items: flex-start; gap: 32px; flex-wrap: wrap;">
            <!-- Soal dan Form Jawaban -->
            <form method="post" action="index.php?mapel=<?= $mapel ?>&no=<?= $no ?>" class="form-opsi-jawaban" style="flex:1;" id="formJawaban">
                <div style="height: 32px;"></div>

                <!-- NOMOR SOAL DITAMPILKAN DI SINI SEBELUM PERTANYAAN -->
                <div style="font-size:1.1em; color:#007bff; font-weight:bold; margin-bottom:8px;">
                    Soal Nomor: <?= $no ?> dari <?= $total ?>
                </div>



                <div class="pertanyaan-besar">
<div style="text-align: center;">
  <strong><?= htmlspecialchars($soal['judul']) ?></strong>
</div>

<?php if (!empty($soal['gambar'])): ?>
    <div style="margin:18px 0; text-align:center;">
        <img src="<?= htmlspecialchars($soal['gambar']) ?>" alt="Gambar Soal"
             style="
             display:block;
             width:100%;
             height:auto;
             max-width:100%;
             object-fit:contain;
             box-shadow:0 4px 24px #0003;
             border-radius:12px;
             border:2px solid #eee;">
    </div>
    <?php endif; ?>

<span style="color: black;">
    <?= htmlspecialchars($soal['pertanyaan']) ?>
</span>
                    <br><br>
                    <strong><?= htmlspecialchars($soal['tanya']) ?></strong>


                </div>


                <?php
                // Acak urutan jawaban
                $opsi_jawaban = [
                    $soal['jawaban1'],
                    $soal['jawaban2'],
                    $soal['jawaban3'],
                    $soal['jawaban4'] // Tambahkan jawaban4 ke opsi
                ];
                // Hapus opsi kosong (jika ada)
                $opsi_jawaban = array_filter($opsi_jawaban, function($v) { return trim($v) !== ''; });
                shuffle($opsi_jawaban);
                foreach ($opsi_jawaban as $opsi):
                ?>
                <label>
                    <input type="radio" name="jawaban" value="<?= htmlspecialchars($opsi) ?>" <?= ($jawaban_terpilih == $opsi) ? 'checked' : '' ?>>
                    <?= htmlspecialchars($opsi) ?>
                </label>
                <?php endforeach; ?>
                <br>
                <button type="submit" class="login-btn" id="btnKirimJawaban"
                    style="background: 
                    linear-gradient(90deg, #43e97b 0%, #38f9d7 100%); 
                    color: #000; 
                    border: 2px solid #43e97b; 
                    padding: 10px 28px; border-radius: 8px; 
                    font-size: 1.0em; 
                    margin-right: 12px; 
                    cursor: pointer; 
                    box-shadow: 0 4px 16px #38f9d799, 0 2px 8px #38f9d733; transition: box-shadow 0.2s, border 0.2s;">
                    <?= ($no == $total) ? "Selesai" : "Kirim" ?>
                </button>
                    
                <script>
                document.getElementById('btnKirimJawaban').onclick = function(e) {
                    // Cek apakah ada radio yang dipilih
                    var radios = document.getElementsByName('jawaban');
                    var checked = false;
                    for (var i = 0; i < radios.length; i++) {
                        if (radios[i].checked) {
                            checked = true;
                            break;
                        }
                    }
                    if (!checked) {
                        e.preventDefault();
                        showCustomAlert('Silakan pilih jawaban terlebih dahulu sebelum mengirim!');
                        return false;
                    }
                    // Jika sudah dipilih, biarkan submit berjalan normal
                };
                </script>

                
                

                    

                    <style>
                    .alert-btn {
                        background: linear-gradient(90deg, #43e97b 0%, #38f9d7 100%);
                        color: #fff;
                        text-decoration: none;
                        display: inline-block;
                        padding: 10px 28px;
                        margin: 8px 8px 0 0;
                        border: none;
                        border-radius: 8px;
                        font-size: 1em;
                        font-weight: bold;
                        cursor: pointer;
                        box-shadow: 0 2px 8px #0002;
                        transition: background 0.2s, box-shadow 0.2s, transform 0.15s;
                        outline: none;
                    }
                    .alert-btn-confirm {
                        background: linear-gradient(90deg, #43e97b 0%, #38f9d7 100%);
                        color: #fff;
                        text-decoration: none;
                        display: inline-block;
                        padding: 10px 32px;
                        margin: 8px 8px 0 0;
                        border: none;
                        border-radius: 10px;
                        font-size: 1em;
                        font-weight: 600;
                        letter-spacing: 0.5px;
                        cursor: pointer;
                        box-shadow: 0 4px 16px #38f9d799, 0 2px 8px #38f9d633;
                        transition: box-shadow 0.2s, background 0.2s, transform 0.15s;
                        outline: none;
                        display: inline-flex;
                        align-items: center;
                    }
                    .alert-btn-confirm:hover {
                        background: linear-gradient(90deg, #38f9d7 0%, #43e97b 100%);
                        box-shadow: 0 4px 16px #38f9d799;
                        transform: translateY(-2px) scale(1.04);
                    }
                    .alert-btn-cancel {
                        background: #fff;
                        color: #222;
                        border: 2px solid #bbb;
                    }
                    .alert-btn-cancel:hover {
                        box-shadow: 0 2px 8px #0002;
                        transform: translateY(-2px) scale(1.04);
                        background: #f5f5f5;
                        border-color: #43e97b;
                        color: #43e97b;


                    }


                    </style>

                    <script>
                    function showCustomAlert(msg, timeout = 2500) {
                        const alertBox = document.getElementById('custom-alert');
                        const alertContent = document.getElementById('custom-alert-content');
                        alertContent.innerHTML = msg;
                        alertBox.style.display = 'flex';

                        // Clear timeout jika ada
                        if (alertTimeout) clearTimeout(alertTimeout);

                        // Sembunyikan alert setelah timeout, kecuali mouse di atas alert
                        function hideAlert() {
                            alertBox.style.display = 'none';
                        }

                        alertContent.onmouseenter = function() {
                            if (alertTimeout) clearTimeout(alertTimeout);
                        };
                        alertContent.onmouseleave = function() {
                            alertTimeout = setTimeout(hideAlert, 1200);
                        };

                        alertTimeout = setTimeout(hideAlert, timeout);
                    }
                    function customResetKuis() {
                        // Hapus jawaban user di localStorage (timer) dan reload ke soal pertama
                        let timerKey = "timer_<?= $mapel ?>_<?= $user ?>";
                        localStorage.removeItem(timerKey);

                        // Tampilkan konfirmasi
                        
                        
                    }
                    function confirmResetKuis() {
                        // Hapus jawaban user di localStorage (timer)
                        let timerKey = "timer_<?= $mapel ?>_<?= $user ?>";
                        localStorage.removeItem(timerKey);

                        // Redirect ke reset.php untuk hapus session jawaban dan mulai ulang
                        window.location.href = "reset.php?mapel=<?= $mapel ?>";
                    }
                    function hideCustomAlert() {
                        document.getElementById('custom-alert').style.display = 'none';
                    }
                    function confirmResetKuis() {
                        // Hapus jawaban user di localStorage (timer)
                        let timerKey = "timer_<?= $mapel ?>_<?= $user ?>";
                        localStorage.removeItem(timerKey);

                        // Redirect ke reset.php untuk hapus session jawaban dan mulai ulang
                        window.location.href = "reset.php?mapel=<?= $mapel ?>";
                    }
                    function hideCustomAlert() {
                        document.getElementById('custom-alert').style.display = 'none';
                    }
                    </script>
                
        
                    <style>
                    .reset-btn {
                        background: linear-gradient(90deg, #ff5858 0%, #f857a6 100%);
                        color: #fff;
                        border: none;
                        padding: 10px 32px;
                        border-radius: 10px;
                        font-size: 0.8em;
                        margin-right: 12px;
                        cursor: pointer;
                        box-shadow: 0 4px 16px #f857a699, 0 2px 8px #f857a633;
                        transition: box-shadow 0.2s, border 0.2s, transform 0.15s;
                        font-weight: 600;
                        letter-spacing: 0.5px;
                        outline: none;
                        display: inline-block;
                    }
                    .reset-btn:hover, .reset-btn:focus {
                        color: #fff;
                        background: linear-gradient(90deg, #f857a6 0%, #ff5858 100%);
                        box-shadow: 0 8px 32px #f857a6cc;
                        border: none;
                        transform: translateY(-2px) scale(1.04);
                    }
                    </style>
                    <script>
                    function customResetKuis() {
                        showCustomAlert(
                            `<div style="font-size:1.1em; padding:8px 0;">
                                <b>Cek Jawaban?</b><br>
                                Pastikan semua jawaban sudah benar sebelum mengirim.<br><br>
                                <button onclick="confirmResetKuis()" style="
                                    background: linear-gradient(90deg,#ff5858 0%,#f857a6 100%);
                                    color: #fff;
                                    border: none;
                                    padding: 10px 32px;
                                    border-radius: 10px;
                                    font-size: 1em;
                                    font-weight: 600;
                                    letter-spacing: 0.5px;
                                    margin-right: 12px;
                                    cursor: pointer;
                                    box-shadow: 0 4px 16px #f857a699, 0 2px 8px #f857a633;
                                    transition: box-shadow 0.2s, background 0.2s, transform 0.15s;
                                    outline: none;
                                    display: inline-flex;
                                    align-items: center;
                                    gap: 8px;
                                " onmouseover="this.style.background='linear-gradient(90deg,#f857a6 0%,#ff5858 100%)';this.style.transform='scale(1.04)';"
                                  onmouseout="this.style.background='linear-gradient(90deg,#ff5858 0%,#f857a6 100%)';this.style.transform='scale(1)';">
                                    <svg width="20" height="20" viewBox="0 0 22 22" fill="none" style="margin-right:4px;" xmlns="http://www.w3.org/2000/svg">
                                        <circle cx="11" cy="11" r="10" stroke="#fff" stroke-width="2" fill="url(#resetGradientBtn)"/>
                                        <path d="M7 11a4 4 0 1 1 4 4" stroke="#fff" stroke-width="2" fill="none"/>
                                        <polyline points="7,11 7,7 11,7" stroke="#fff" stroke-width="2" fill="none"/>
                                        <defs>
                                            <linearGradient id="resetGradientBtn" x1="0" y1="0" x2="22" y2="22" gradientUnits="userSpaceOnUse">
                                                <stop stop-color="#ff5858"/>
                                                <stop offset="1" stop-color="#f857a6"/>
                                            </linearGradient>
                                        </defs>
                                    </svg>
                                    Ya, cek jawaban
                                </button>
                                <button onclick="hideCustomAlert()" style="
                                    background: #fff;
                                    color: #222;
                                    border: 2px solid #bbb;
                                    padding: 10px 32px;
                                    border-radius: 10px;
                                    font-size: 1em;
                                    font-weight: 600;
                                    letter-spacing: 0.5px;
                                    cursor: pointer;
                                    transition: background 0.2s, border 0.2s, color 0.2s, transform 0.15s;
                                    outline: none;
                                    display: inline-block;
                                " onmouseover="this.style.background='#f5f5f5';this.style.borderColor='#43e97b';this.style.color='#43e97b';this.style.transform='scale(1.04)';"
                                  onmouseout="this.style.background='#fff';this.style.borderColor='#bbb';this.style.color='#222';this.style.transform='scale(1)';">
                                    Batal
                                </button>
                            </div>`, 10000
                        );
                    }
                        
                    function confirmResetKuis() {
                        showCustomAlert('<b>Jawaban akan kamu cek!</b> Mulai dari awal...', 1800);
                        setTimeout(function(){ window.location.href='index.php?mapel=<?= $mapel ?>&no=1'; }, 1200);
                    }
                    function hideCustomAlert() {
                        document.getElementById('custom-alert').style.display = 'none';
                    }
                    </script>

            </form>



            <?php if ($no == $total): ?>

                <!-- Modal Konfirmasi Kirim Jawaban -->
                <div id="modalConfirm" style="
                    display:none;
                    justify-content:center;
                    align-items:center;
                    position:fixed;
                    overflow-y:auto;
                    padding: 16px;
                    background: rgba(0, 0, 0, 0.48);
                    backdrop-filter: blur(16px);
                    -webkit-backdrop-filter: blur(16px);
                    top:0; left:0; right:0; bottom:0;
                    height:100%;
                    width:100%;
                    z-index:10000;
                    

">
<div style="background:#fff; border-radius:12px; padding:24px; box-shadow:0 4px 24px rgba(0,0,0,0.2); width:100%; max-width:500px; text-align:center;">


    
    
    <div style="font-size:1.15em; color:#222; margin-bottom:18px;">
      <b>Konfirmasi Kirim Jawaban</b><br>
      Apakah Anda benar-benar akan mengirim jawaban untuk soal terakhir dan menyelesaikan kuis?
    </div>
    <button id="btnConfirmYes" style="background:linear-gradient(90deg,#43e97b,#38f9d7);color:#fff;border:none;padding:10px 28px;border-radius:8px;font-size:1em;margin-right:12px;cursor:pointer;">Ya, Kirim</button>

    <button id="btnConfirmMaybe" style="background:#ffeb3b;color:#222;border:none;padding:10px 28px;border-radius:8px;font-size:1em;margin-right:12px;cursor:pointer;">Mungkin Nanti</button>
    <script>
    document.getElementById('btnConfirmMaybe').onclick = function() {
        document.getElementById('modalConfirm').style.display = 'none';
        showCustomAlert('Silakan lanjutkan mengerjakan soal.', 1500);
    };
    </script>

    <br>

    <button id="btnConfirmNo" style="background:#eee;color:#222;border:none;padding:10px 28px;border-radius:8px;font-size:1em;cursor:pointer; margin-top:12px;">Batal</button>
  </div>
</div>
            <script>
            const form = document.getElementById('formJawaban');
            if (form) {
              form.addEventListener('submit', function(e) {
                e.preventDefault();
                document.getElementById('modalConfirm').style.display = 'flex';
                document.getElementById('btnConfirmYes').onclick = function() {
                  document.getElementById('modalConfirm').style.display = 'none';
                  showCustomAlert('Jawaban terkirim. Terima kasih!', 1800);
                  setTimeout(() => form.submit(), 1200);
                };
                document.getElementById('btnConfirmNo').onclick = function() {
                  document.getElementById('modalConfirm').style.display = 'none';
                  showCustomAlert('Pengiriman dibatalkan.', 1500);
                };
              });
            }
            </script>
            <?php endif; ?>

            <!-- Navigasi Nomor Soal di Samping Kanan -->
            <div id="navigation" style="min-width:90px;">
            <?php for ($i = 1; $i <= $total; $i++):
    $status = '';
    $jawab = isset($jawaban_user[$i-1]) ? $jawaban_user[$i-1] : '';
    if (!empty($jawab)) {
        $status = 'sudah'; // Sudah dikerjakan, hijau
    } elseif ($i == $no) {
        $status = 'aktif'; // Soal aktif, oranye
    } else {
        $status = 'belum'; // Belum dikerjakan, abu-abu
    }
    $class = 'nav-btn-' . $status;
    $enable = ($status == 'aktif' || $status == 'sudah' || ($i == $total && $no > $total)) ? '' : 'disabled';
?>

<a href="index.php?mapel=<?= $mapel ?>&no=<?= $i ?>" style="text-decoration:none;"
   onclick="return cekSoalSudahDikerjakan(this.querySelector('button'));">
    <button
        type="button"
        class="<?= $class ?>"
        style="margin:4px 0; width:48px; height:48px; font-size:22px;"
        <?= $enable ?>
        data-status="<?= $status ?>"
        data-no="<?= $i ?>"
    >
        <?= $i ?>
    </button>
</a>
<?php endfor; ?>


            </div>
            <script>
function showCustomAlert(msg, timeout = 2500) {
    const alertBox = document.getElementById('custom-alert');
    const alertContent = document.getElementById('custom-alert-content');
    alertContent.innerHTML = msg;
    alertBox.style.display = 'flex';

    // Clear timeout jika ada
    if (alertTimeout) clearTimeout(alertTimeout);

    // Sembunyikan alert setelah timeout, kecuali mouse di atas alert
    function hideAlert() {
        alertBox.style.display = 'none';
    }

    alertContent.onmouseenter = function() {
        if (alertTimeout) clearTimeout(alertTimeout);
    };
    alertContent.onmouseleave = function() {
        alertTimeout = setTimeout(hideAlert, 1200);
    };

    alertTimeout = setTimeout(hideAlert, timeout);
}
function cekSoalSudahDikerjakan(btn) {
    var status = btn.getAttribute('data-status');
    var no = btn.getAttribute('data-no');
    if (status === 'sudah') {
        showCustomAlert('Nomor soal ' + no + ' sudah dikerjakan. Kamu bisa mengubah jawaban jika ingin.');
        // Tidak return false, biarkan link berjalan normal
    }
    return true; // Selalu lanjutkan pindah halaman
}
</script>
        </div>
        <script>
        function prevQuestion() {
            let urlParams = new URLSearchParams(window.location.search);
            let currentNo = parseInt(urlParams.get("no")) || 1;
            if (currentNo > 1) {
                window.location.href = "index.php?mapel=<?= $mapel ?>&no=" + (currentNo - 1);
            } else {
                showCustomAlert("Anda sudah berada di soal pertama.");
            }
        }
        </script>
        <div style="margin-top:32px;text-align:center;">
            <a href="logout.php" class="logout-button">Logout</a>
        </div>
    <?php endif; ?>
<?php else: ?>
    <h2 style="text-align:center;">Selamat datang! 👋</h2>
    <h3 style="text-align:center;">Pilih Mata Pelajaran yang kamu inginkan!:</h3>
    <div class="mapel-list">

        <div class="mapel-card">
        <?php if (!empty($data['gambar'])): ?>
        <img src="<?php echo $data['gambar']; ?>" alt="Matematika" style="width:100%; border-radius:8px; margin-bottom:10px;">
        <?php endif; ?>

        <span class="emoji">🔢</span>
        <a href="mat_b.php">Matematika</a>
    </div>

        <div class="mapel-card">
            <?php if (!empty($data['gambar'])): ?>
        <img src="<?php echo $data['gambar']; ?>" alt="Bahasa Indonesia" style="width:100%; border-radius:8px; margin-bottom:10px;">
        <?php endif; ?>
            <span class="emoji">📖</span>
            <a href="index.php?mapel=bindo&no=1">Bahasa Indonesia</a>
        </div>

        <div class="mapel-card">
            <?php if (!empty($data['gambar'])): ?>
        <img src="<?php echo $data['gambar']; ?>" alt="Pendidikan Pancasila" style="width:100%; border-radius:8px; margin-bottom:10px;">
        <?php endif; ?>
            <span class="emoji">🌏</span>
            <a href="index.php?mapel=pancasila&no=1">Pendidikan Pancasila</a>
        </div>
        <div class="mapel-card">
            <?php if (!empty($data['gambar'])): ?>
        <img src="<?php echo $data['gambar']; ?>" alt="IPAS" style="width:100%; border-radius:8px; margin-bottom:10px;">
        <?php endif; ?>
            <span class="emoji">🔬</span>
            <a href="index.php?mapel=ipas&no=1">IPAS</a>
        </div>
        <div class="mapel-card">
            <?php if (!empty($data['gambar'])): ?>
        <img src="<?php echo $data['gambar']; ?>" alt="Bahasa Inggris" style="width:100%; border-radius:8px; margin-bottom:10px;">
        <?php endif; ?>
            <span class="emoji">🇬🇧</span>
            <a href="index.php?mapel=inggris&no=1">Bahasa Inggris</a>
        </div>
        <div class="mapel-card">
            <?php if (!empty($data['gambar'])): ?>
        <img src="<?php echo $data['gambar']; ?>" alt="Bahasa Jawa" style="width:100%; border-radius:8px; margin-bottom:10px;">
        <?php endif; ?>
            <span class="emoji">🎭</span>
            <a href="index.php?mapel=jawa&no=1">Bahasa Jawa</a>
        </div>
        <div class="mapel-card">
            <?php if (!empty($data['gambar'])): ?>
        <img src="<?php echo $data['gambar']; ?>" alt="Seni Budaya" style="width:100%; border-radius:8px; margin-bottom:10px;">
        <?php endif; ?>
            <span class="emoji">🎨</span>
            <a href="index.php?mapel=seni&no=1">Seni Budaya</a>
        </div>

    <div class="mapel-card">
        <span class="emoji">📝</span>
        <a href="ganda_B.php">AKM</a>
    </div>
        
    <div class="mapel-card">
        <span class="emoji"> 
            🏆
        </span>
        <a href="jawaban.php">Jawaban Kamu!</a>
    </div>

    </div>
    <div style="margin-top:32px;text-align:center;">
        <a href="logout.php" class="logout-button">Logout</a>

    </div>
    <p style="text-align:center; font-size:0.9em; color:#666;">Semangat Belajarku - 2025</p>
<?php endif; ?>
</div>

</body>
</html>