
<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!isset($_SESSION["user"])) {
    header("Location: login.php");
    exit();
}

$user = $_SESSION["user"];

// Pastikan path ke autoload.php Dompdf sudah benar
require_once __DIR__ . '/vendor/autoload.php';
use Dompdf\Dompdf;

// Mulai output buffering, sertakan template laporan
ob_start();
include __DIR__ . '/cetak_template.php';
$html = ob_get_clean();

// Inisialisasi Dompdf dan set HTML
$dompdf = new Dompdf();
$dompdf->loadHtml($html);

// Set ukuran kertas A4 dan orientasi portrait
$dompdf->setPaper('A4', 'portrait');

// Render HTML ke PDF
$dompdf->render();

// Output PDF ke browser (Attachment: 0 = tampil, 1 = download)
$dompdf->stream($user . "_laporan.pdf", array("Attachment" => 0));
exit;
?>