<?php
session_start();
if (!isset($_SESSION["user"])) {
    header("Location: login.php");
    exit();
}
$user = $_SESSION["user"];

// Koneksi database
$mysqli = new mysqli("localhost", "lnibbicy_kka5", "magetan#2", "lnibbicy_kka5");
if ($mysqli->connect_error) {
    die("Koneksi gagal: " . $mysqli->connect_error);
}

// Ambil total soal
$total_soal_db = $mysqli->query("SELECT COUNT(id) as total FROM ganda_b")->fetch_assoc()['total'];

// Ambil jumlah soal yang sudah dijawab pengguna
$stmt_check = $mysqli->prepare("SELECT COUNT(id) as dijawab FROM hasil_ganda_b WHERE username = ?");
$stmt_check->bind_param("s", $user);
$stmt_check->execute();
$result_check = $stmt_check->get_result();
$jawaban_user_count = $result_check->fetch_assoc()['dijawab'];
$stmt_check->close();

// Jika jumlah jawaban sama dengan total soal, redirect ke halaman komplek
if ($jawaban_user_count >= $total_soal_db && $total_soal_db > 0) {
    header("Location: komplek.php");
    exit();
}

// Jika ada navigasi soal melalui parameter GET, gunakan soal tersebut, jika tidak ambil soal selanjutnya yang belum dijawab
if (isset($_GET['question'])) {
    $question_id = intval($_GET['question']);
    $stmt = $mysqli->prepare("SELECT * FROM ganda_b WHERE id = ?");
    $stmt->bind_param("i", $question_id);
} else {
    $stmt = $mysqli->prepare(
        "SELECT * FROM ganda_b 
         WHERE id NOT IN (SELECT id_soal FROM hasil_ganda_b WHERE username = ?) 
         ORDER BY id ASC 
         LIMIT 1"
    );
    $stmt->bind_param("s", $user);
}
$stmt->execute();
$result = $stmt->get_result();
$soal = $result->fetch_assoc();
$stmt->close();

// Jika soal ada, periksa apakah user sudah pernah menjawab soal ini, untuk menampilkan jawaban yang tersimpan
$existing_answer = null;
if ($soal) {
    $stmt_existing = $mysqli->prepare("SELECT jawaban_user FROM hasil_ganda_b WHERE username = ? AND id_soal = ?");
    $stmt_existing->bind_param("si", $user, $soal['id']);
    $stmt_existing->execute();
    $result_existing = $stmt_existing->get_result();
    if ($row_existing = $result_existing->fetch_assoc()) {
        $existing_answer = $row_existing['jawaban_user'];
    }
    $stmt_existing->close();
}

// Proses kirim jawaban
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['id_soal'])) {
    $id_soal = $_POST['id_soal'];
    $jawaban_user = $_POST['jawaban'] ?? '';

    // Ambil jawaban benar dari database
    $stmt_jawaban = $mysqli->prepare("SELECT jawaban_benar FROM ganda_b WHERE id = ?");
    $stmt_jawaban->bind_param("i", $id_soal);
    $stmt_jawaban->execute();
    $result_jawaban = $stmt_jawaban->get_result();
    $soal_dijawab = $result_jawaban->fetch_assoc();
    $stmt_jawaban->close();

    if ($soal_dijawab) {
        $jawaban_benar = $soal_dijawab['jawaban_benar'];
        $skor = ($jawaban_user == $jawaban_benar) ? 1 : 0;

        // Simpan hasil ke database:
        // Jika soal sudah dijawab sebelumnya, lakukan UPDATE agar jawaban tetap tersimpan, jika belum INSERT
        $stmt_exists = $mysqli->prepare("SELECT id FROM hasil_ganda_b WHERE username = ? AND id_soal = ?");
        $stmt_exists->bind_param("si", $user, $id_soal);
        $stmt_exists->execute();
        $result_exists = $stmt_exists->get_result();
        if ($result_exists->num_rows > 0) {
            $stmt_update = $mysqli->prepare("UPDATE hasil_ganda_b SET jawaban_user = ?, skor = ?, waktu = NOW() WHERE username = ? AND id_soal = ?");
            $stmt_update->bind_param("sisi", $jawaban_user, $skor, $user, $id_soal);
            $stmt_update->execute();
            $stmt_update->close();
        } else {
            $stmt_insert = $mysqli->prepare("INSERT INTO hasil_ganda_b (username, id_soal, jawaban_user, skor, waktu) VALUES (?, ?, ?, ?, NOW())");
            $stmt_insert->bind_param("sisi", $user, $id_soal, $jawaban_user, $skor);
            $stmt_insert->execute();
            $stmt_insert->close();
        }
        $stmt_exists->close();
    }
    
    // Ambil soal berikutnya (unanswered) untuk redirect
    $next_stmt = $mysqli->prepare("SELECT id FROM ganda_b WHERE id NOT IN (SELECT id_soal FROM hasil_ganda_b WHERE username = ?) ORDER BY id ASC LIMIT 1");
    $next_stmt->bind_param("s", $user);
    $next_stmt->execute();
    $result_next = $next_stmt->get_result();
    if($row_next = $result_next->fetch_assoc()){
        $next_question_id = $row_next['id'];
        $next_url = "ganda_B.php?question=" . $next_question_id;
    } else {
        $next_url = "ganda_B.php"; // atau halaman selanjutnya jika semua soal telah dijawab.
    }
    $next_stmt->close();
    
    // Redirect ke soal berikutnya agar navigasi warna menyesuaikan
    header("Location: " . $next_url);
    exit();
}

// Ambil semua soal dan soal yang sudah dijawab untuk navigasi
$all_soals = [];
$result_all = $mysqli->query("SELECT id FROM ganda_b ORDER BY id ASC");
while ($row = $result_all->fetch_assoc()) {
    $all_soals[] = $row['id'];
}

$answered = [];
$result_ans = $mysqli->query("SELECT id_soal FROM hasil_ganda_b WHERE username = '$user'");
while ($row = $result_ans->fetch_assoc()) {
    $answered[] = $row['id_soal'];
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Soal Pilihan Ganda Biasa</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body {
            font-family: 'Open Sans', 'Comic Sans MS', Arial, sans-serif;
            background: linear-gradient(135deg, #5763ef, #071728);
            margin: 0;
            padding: 0;
            color: #222;
        }
        /* Ganti bagian .container pada CSS Anda: */
.container {
    max-width: 1100px;
    width: 95vw;
    min-height: 100vh;
    margin: 40px auto;
    background-image: url('images/logo hp.png');
    background-size: cover;
    background-repeat: no-repeat;
    -webkit-backdrop-filter: blur(9px);
    border-radius: 9px;
    box-shadow: 0 12px 24px rgba(0, 0, 0, 0.08);
    padding: 36px 24px;
    background-color: rgba(255, 255, 255, 0.85);
    display: flex;
    flex-direction: column;
    justify-content: flex-start;
}

        h2 {
            color: #1976d2;
            text-align: center;
            margin-bottom: 24px;
            font-size: 1.75em;
            font-weight: 700;
            letter-spacing: 0.05em;
        }
        .user-info {
            color: #1976d2;
            margin-bottom: 18px;
            font-size: 1.5em;
            font-weight: 600;
        }
        .judul {
            font-size: 1.5em;
            margin-bottom: 24px;
            color: #2c3e50;
            font-weight: 700;
            text-align: center;
            letter-spacing: 0.03em;
        }
        .soal-row {
            display: flex;
            flex-direction: row;
            gap: 32px;
            align-items: flex-start;
            justify-content: space-between;
        }
        .soal-kanan {
            flex: 1 1 55%;
            text-align: left;
        }
        .opsi-kiri {
            flex: 1 1 45%;
        }
        .gambar-soal img {
            width: 100%;
            max-width: 1000px;
            height: auto;
            border-radius: 7px;
            display: block;
            margin: 0 auto 24px;
        }
        label {
            display: block;
            margin-bottom: 14px;
            font-size: 1.2em;
            background: #f0f5ff;
            border-radius: 10px;
            padding: 14px 18px;
            border: 1.5px solid #b3c6e0;
            cursor: pointer;
            user-select: none;
        }
        label:hover {
            background-color: #e3f2fd;
            border-color: #1976d2;
        }
        input[type="radio"] {
            margin-right: 12px;
            accent-color: #1976d2;
            cursor: pointer;
        }
        button[type="submit"] {
            display: block;
            margin: 32px auto 0;
            background: #3374ffff;
            color: #fff;
            border: none;
            border-radius: 8px;
            padding: 14px 40px;
            font-size: 1.2em;
            font-weight: 700;
            cursor: pointer;
        }
        button[type="submit"]:hover {
            background: #0048e4ff;
        }
        .soal-text, .tanya {
            font-size: 1.35em;
            color: #2c3e50;
            margin-bottom: 20px;
            line-height: 1.7;
            text-align: justify;
        }
        .tanya {
            font-weight: 700;
        }
        .progress-info {
            text-align: center;
            margin-bottom: 24px;
            color: #555;
            font-size: 1.9em;
            font-style: italic;
        }
        /* Navigasi Soal */
        .nav-soal {
            text-align: center;
            margin-top: 30px;
                        font-size: 1.5em;

        }
        .nav-soal a {
            display: inline-block;
            margin: 4px;
            padding: 10px 15px;
            text-decoration: none;
            font-size: 0.7em;
            border-radius: 7px;
            border: 2px solid #e09900ff;
            color: #1976d2;
            transition: background 0.2s, color 0.2s;
        }
        .nav-soal a:hover {
            background: #ff5e00ff;
            color: #fff;
        }
        .nav-soal a.answered {
            background: #ff9100ff;
            color: #000000ff;
        }
        .nav-soal a.current {
            background: #96a0fcff;
            border: 1px solid #ffffffff;
            padding: 10px 15px;
            font-weight: bold;
        }
        @media (max-width: 900px) {
            .container {
                max-width: 98vw;
                padding: 10px 2vw;
            }
            .soal-row {
                flex-direction: column;
                gap: 0;
            }
            .soal-kanan, .opsi-kiri {
                width: 100%;
                flex: unset;
            }
        }
        @media (max-width: 400px) {
            body {
                background: #ffffffff;
                padding: 1px;
            }
            .container {
                margin: 20px auto;
                padding: 15px 15px;
            }
            .judul {
                font-size: 1.3em;
                margin-bottom: 20px;
            }
            h2 {
                font-size: 1.5em;
                margin-bottom: 20px;
            }
            .soal-text, .tanya {
                font-size: 1.1em;
                padding: 0px 20px;
            }
            label {
                font-size: 1em;
                padding: 12px 14px;
            }
            button[type="submit"] {
                font-size: 1em;
                padding: 12px 30px;
            }
            .gambar-soal img {
                max-width: 100%;
                height: auto;
                border-radius: 5px;
                display: block;
                margin-bottom: 16px;
            }
            .soal-text, .tanya {
                padding: 0px 1px;
            }
            .nav-soal a {
                padding: 10px 15px;
                font-size: 18px;
            }
            .nav-soal a.current {
                padding: 10px 15px;
            }

            @media (max-width: 900px) {
    .container {
        max-width: 98vw;
        width: 98vw;
        min-height: 100vh;
        padding: 10px 2vw;
        margin: 0;
        border-radius: 0;
    }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="user-info">User: <b><?= htmlspecialchars($user) ?></b></div>
        <h2>Soal Pilihan Ganda Biasa</h2>
        
        <!-- Navigasi Soal -->
        <div class="nav-soal">
            Navigasi Soal:</b><br>
            </b><br>
            <?php foreach ($all_soals as $index => $qid): 
                // Tandai soal yang sudah dijawab dan soal yang sedang aktif
                $classes = [];
                if (in_array($qid, $answered)) {
                    $classes[] = "answered";
                }
                if ($soal && $qid == $soal['id']) {
                    $classes[] = "current";
                }
                $class_attr = count($classes) > 0 ? 'class="' . implode(" ", $classes) . '"' : '';
            ?>
                <a href="ganda_B.php?question=<?= $qid ?>" <?= $class_attr ?>><?= $index + 1 ?></a>
            <?php endforeach; ?>
        </div>
        </b><br></b><br>
        <?php if ($soal): ?>
            </b><br></b><br>
            
<form method="post" action="ganda_B.php?question=<?= $soal['id'] ?>">
    <input type="hidden" name="id_soal" value="<?= htmlspecialchars($soal['id']) ?>">
    </b><br></b><br>
    <div class="soal-row">
        <div class="soal-kanan">
            <br><div class="judul"><?= htmlspecialchars($soal['judul']) ?></div>

            <?php if (!empty($soal['gambar'])): ?>
                <div class="gambar-soal">
                    <img src="<?= htmlspecialchars($soal['gambar']) ?>" alt="">
                </div>
            <?php endif; ?>
            <div class="soal-text"><?= nl2br(htmlspecialchars($soal['pertanyaan'])) ?></div>
        </div>
        <div class="opsi-kiri">
            <div class="tanya"><?= htmlspecialchars($soal['tanya']) ?></div>
            <div class="opsi">
                <?php for ($i = 1; $i <= 4; $i++): 
                    $opsi = $soal["opsi_$i"];
                    if (!empty($opsi)): ?>
                        <label>
                            <input type="radio" name="jawaban" value="<?= $i ?>" required <?php if(isset($existing_answer) && $existing_answer == $i) echo "checked"; ?>>
                            <?= htmlspecialchars($opsi) ?>
                        </label>
                <?php endif; endfor; ?>
            </div>
            <button type="submit">Kirim Jawaban</button>
        </div>
    </div>
</form>
<!-- ...existing code... -->
        <?php else: ?>
            <h2>Semua soal telah dijawab!</h2>
            <p>Terima kasih telah menyelesaikan kuis.</p>
        <?php endif; ?>
    </div>
</body>
</html>