<?php
session_start();
if (!isset($_SESSION["user"])) {
    header("Location: login.php");
    exit();
}

header("Content-Type: application/vnd.ms-excel; charset=UTF-8");
header("Content-Disposition: attachment; filename=rekap_skor_akm.xls");
header("Content-Transfer-Encoding: binary");
header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
header("Pragma: public");
header("Expires: 0");

$mysqli = new mysqli("localhost", "lnibbicy_kka5", "magetan#2", "lnibbicy_kka5");
if ($mysqli->connect_error) {
    die("Koneksi gagal: " . $mysqli->connect_error);
}

echo "<html xmlns:x='urn:schemas-microsoft-com:office:excel'>
<head>
<meta http-equiv='Content-Type' content='text/html; charset=UTF-8' />
</head>
<body>
<table border='1'>
<tr>
    <th>No</th>
    <th>Username</th>
    <th>Nama Mapel</th>
    <th>Skor Ganda B</th>
    <th>Skor Komplek</th>
    <th>Skor Jodoh</th>
    <th>Skor Benar/Salah</th>
    <th>Total Skor</th>
    <th>Skor Mak</th>
    <th>Nilai</th>
</tr>";

$sql = "SELECT DISTINCT username FROM (
    SELECT username FROM hasil_ganda_b
    UNION
    SELECT username FROM hasil_komplek
    UNION
    SELECT username FROM hasil_jodoh
    UNION
    SELECT username FROM hasil_bs
) as all_user";
$res = $mysqli->query($sql);

if ($res && $res->num_rows > 0) {
    $no = 1;
    while ($row = $res->fetch_assoc()) {
        $user = htmlspecialchars($row['username']);

        $skor_ganda = $mysqli->query("SELECT SUM(skor) FROM hasil_ganda_b WHERE username='$user'");
        $skor_komplek = $mysqli->query("SELECT SUM(skor) FROM hasil_komplek WHERE username='$user'");
        $skor_jodoh = $mysqli->query("SELECT SUM(skor) FROM hasil_jodoh WHERE username='$user'");
        $skor_bs = $mysqli->query("SELECT SUM(skor) FROM hasil_bs WHERE username='$user'");

        $sg = $skor_ganda->fetch_row()[0] ?? 0;
        $sk = $skor_komplek->fetch_row()[0] ?? 0;
        $sj = $skor_jodoh->fetch_row()[0] ?? 0;
        $sb = $skor_bs->fetch_row()[0] ?? 0;

    $total = $sg + $sk + $sj + $sb;
    // Hitung skor maksimum
    $qmax = $mysqli->query("
        SELECT
        (SELECT SUM(skor_b) FROM ganda_b) +
        (SELECT SUM(skor_k) FROM komplek_soal) +
        (SELECT SUM(skor_j) FROM jodoh_soal) +
        (SELECT SUM(skor_bs) FROM benar_salah) AS total_skor_max
    ");
    $rowmax = $qmax ? $qmax->fetch_assoc() : ["total_skor_max"=>0];
    $total_skor_max = $rowmax["total_skor_max"] ? $rowmax["total_skor_max"] : 0;
    $nilai = $total_skor_max > 0 ? round(($total / $total_skor_max) * 100, 1) : 0;

    $nama_mapel = 'Matematika';
    echo "<tr>
        <td>$no</td>
        <td>$user</td>
        <td>$nama_mapel</td>
        <td>$sg</td>
        <td>$sk</td>
        <td>$sj</td>
        <td>$sb</td>
        <td>$total</td>
        <td>$total_skor_max</td>
        <td>$nilai</td>
          </tr>";
    $no++;
    }
} else {
    echo "<tr><td colspan='7'>Tidak ada data peserta.</td></tr>";
}

echo "</table></body></html>";
?>
