
<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!isset($_SESSION["user"])) {
    header("Location: login.php");
    exit();
}
$user = $_SESSION["user"];

// Koneksi database
$mysqli = new mysqli("localhost", "lnibbicy_kka5", "magetan#2", "lnibbicy_kka5");
if ($mysqli->connect_error) {
    die("Koneksi gagal: " . $mysqli->connect_error);
}

// Inisialisasi total_skor agar tidak undefined
$total_skor = 0;

// Pilihan Ganda Biasa (hindari duplikat jawaban)
$sql = "SELECT SUM(skor) as skor FROM (
    SELECT MAX(skor) as skor FROM hasil_ganda_b WHERE username = '$user' GROUP BY id_soal
) as sub";
$res = $mysqli->query($sql);
$skor_ganda = ($res && $row = $res->fetch_assoc()) ? (int)$row['skor'] : 0;
$total_skor += $skor_ganda;

// Pilihan Ganda Komplek
$sql = "SELECT SUM(skor) as skor FROM (
    SELECT MAX(skor) as skor FROM hasil_komplek WHERE username = '$user' GROUP BY id_soal
) as sub";
$res = $mysqli->query($sql);
$skor_komplek = ($res && $row = $res->fetch_assoc()) ? (int)$row['skor'] : 0;
$total_skor += $skor_komplek;

// Menjodohkan
$sql = "SELECT SUM(skor) as skor FROM (
    SELECT MAX(skor) as skor FROM hasil_jodoh WHERE username = '$user' GROUP BY id_soal
) as sub";
$res = $mysqli->query($sql);
$skor_jodoh = ($res && $row = $res->fetch_assoc()) ? (int)$row['skor'] : 0;
$total_skor += $skor_jodoh;

// Benar/Salah
$sql = "SELECT SUM(skor) as skor FROM (
    SELECT MAX(skor) as skor FROM hasil_bs WHERE username = '$user' GROUP BY id_soal
) as sub";
$res = $mysqli->query($sql);
$skor_bs = ($res && $row = $res->fetch_assoc()) ? (int)$row['skor'] : 0;
$total_skor += $skor_bs;

// ...existing code...

// Ambil total skor maksimum dari masing-masing jenis soal
$sql = "
    SELECT
        (SELECT SUM(skor_b) FROM ganda_b) +
        (SELECT SUM(skor_k) FROM komplek_soal) +
        (SELECT SUM(skor_j) FROM jodoh_soal) +
        (SELECT SUM(skor_bs) FROM benar_salah) AS total_skor_max
";
$result = $mysqli->query($sql);
if ($result && $row = $result->fetch_assoc()) {
    $total_skor_max = $row['total_skor_max'] ? $row['total_skor_max'] : 0;
} else {
    $total_skor_max = 0;
}


// Hitung nilai akhir (maksimal 100)
$nilai_akhir = 0;
// Pastikan $total_skor_max sudah didapat dari query SUM skor di atas
if ($total_skor_max > 0) {
    $nilai_akhir = round(($total_skor / $total_skor_max) * 100, 2);
}

// Ambil data pengguna dari tabel users
$sql_user = "SELECT nama, tempat_lahir, tanggal_lahir, kelas, absensi FROM users WHERE username = '$user'";
$res_user = $mysqli->query($sql_user);
$user_data = ($res_user && $res_user->num_rows > 0) ? $res_user->fetch_assoc() : null;
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Laporan AKM</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        /* Base styles */
        body {
            font-family: Arial, sans-serif;
            background: linear-gradient(135deg, #3240d3, #071728);
            margin: 20px;
        }
        h1, h2 {
            text-align: center;
            color: #1976d2;
            margin-bottom: 10px;
        }
        .container {
            max-width: 900px;
            margin: 0 auto;
            background: #fff;
            padding: 20px;
            border-radius: 10px;
        }
        .rekap {
            width: 100%;
            margin: 20px auto;
            border: 1px solid #1976d2;
            border-collapse: collapse;
            border-radius: 8px;
            overflow: hidden;
        }
        .rekap th, .rekap td {
            padding: 12px;
            text-align: left;
        }
        .rekap th {
            background: #1976d2;
            color: #fff;
        }
        .rekap td {
            background: #f7fbff;
        }
        .rekap tr:nth-child(even) td {
            background: #e9f7ff;
        }
        .rekap-total {
            font-weight: bold;
            color: #1976d2;
        }
        .rekap-nilai {
            font-size: 1.3em;
            color: #388e3c;
            font-weight: bold;
        }
        table.result {
            width: 100%;
            margin: 20px 0;
            border-collapse: collapse;
        }
        table.result th, table.result td {
            padding: 10px;
            border: 1px solid #ccc;
        }
        table.result th {
            background: #ddd;
        }
        .section {
            margin-bottom: 40px;
        }
        .print-btn {
            display: inline-block;
            width: 150px;
            margin: 30px auto;
            padding: 12px;
            background: #28d219ff;
            color: white;
            text-align: center;
            text-decoration: none;
            border-radius: 6px;
            border-size: border-box;
            cursor: pointer;
            font-weight: bold;
            font-size: 16px;
        }
        .no-print {
            text-align: center;
            margin-top: 20px;
            border-top: 1px solid #ffffffff;
            padding-top: 10px;
        }
        @media print {
            .no-print { display: none; }
        }
        @media screen and (max-width: 400px) {
            body {
                background: none;
                padding: 1px;
            }
            .container {
                width: 100%;
                padding: 15px;
                box-sizing: border-box;
                margin: 10px;
                background: #fff;
                border-radius: 8px;
                box-shadow: 0 4px 12px rgba(0,0,0,0.1);
            }
            .rekap {
                width: 100%;
                box-sizing: border-box;
            }
            .rekap th, .rekap td {
                padding: 8px;
            }
            table.result {
                width: 100%;
                box-sizing: border-box;
            }
            table.result th, table.result td {
                padding: 6px;
            }
        }
        .section h2 {
            border-bottom: 2px solid #1976d2;
            padding-bottom: 6px;
            margin-bottom: 12px;
        }
        /* Share button styles */
        .share-btn {
            background-color: #25D366;
            color: white;
            text-decoration: none;
            padding: 10px 22px;
            border-radius: 6px;
            font-size: 16px;
            font-weight: bold;
            display: inline-flex;
            align-items: center;
            border: none;
            box-shadow: 0 2px 8px rgba(37, 211, 102, 0.18);
            transition: background 0.2s, transform 0.2s, box-shadow 0.2s;
            margin: 10px 5px;
        }
        
        /* Style tombol login */
        .login-btn {
            background: linear-gradient(90deg, #1976d2, #42a5f5);
            color: #fff;
            border: none;
            padding: 12px 28px;
            border-radius: 6px;
            font-size: 16px;
            font-weight: bold;
            cursor: pointer;
            margin-left: 10px;
            box-shadow: 0 2px 8px rgba(25, 118, 210, 0.15);
            transition: background 0.2s, transform 0.2s;
        }
        .login-btn:hover {
            background: linear-gradient(90deg, #1565c0, #1976d2);
            transform: translateY(-2px);
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Laporan Detail Peserta</h1>
        <?php if ($user_data): ?>
            <table class="rekap" style="margin-bottom: 30px;">
                <tr>
                    <th>Nama</th>
                    <td><?= htmlspecialchars($user_data['nama']) ?></td>
                </tr>
                <tr>
                    <th>Tempat Lahir</th>
                    <td><?= htmlspecialchars($user_data['tempat_lahir']) ?></td>
                </tr>
                <tr>
                    <th>Tanggal Lahir</th>
                    <td><?= htmlspecialchars($user_data['tanggal_lahir']) ?></td>
                </tr>
                <tr>
                    <th>Kelas</th>
                    <td><?= htmlspecialchars($user_data['kelas']) ?></td>
                </tr>
                <tr>
                    <th>Absensi</th>
                    <td><?= htmlspecialchars($user_data['absensi']) ?></td>
                </tr>
            </table>
        <?php else: ?>
            <p>Data pengguna tidak ditemukan.</p>
        <?php endif; ?>
        
        <h2>User / Pengguna: <?= htmlspecialchars($user) ?></h2>
        <table class="rekap">
            <tr>
                <th>Kategori</th>
                <th>Skor</th>
            </tr>
            <tr>
                <td>Pilihan Ganda Biasa</td>
                <td><?= $skor_ganda ?></td>
            </tr>
            <tr>
                <td>Pilihan Ganda Komplek</td>
                <td><?= $skor_komplek ?></td>
            </tr>
            <tr>
                <td>Menjodohkan</td>
                <td><?= $skor_jodoh ?></td>
            </tr>
            <tr>
                <td>Pernyataan Benar/Salah</td>
                <td><?= $skor_bs ?></td>
            </tr>
            <tr class="rekap-total">
                <td>Jumlah Skor</td>
                <td><?= $total_skor ?></td>
            </tr>
            <tr class="rekap-nilai">
                <td>Nilai</td>
                <td><?= $nilai_akhir ?></td>
            </tr>
        </table>

        <!-- Laporan detail per kategori soal -->
        <div class="section">
            <h2>Pilihan Ganda Biasa</h2>
            <?php
            $sql = "SELECT h.skor, h.jawaban_user, h.waktu
                    FROM hasil_ganda_b h
                    WHERE h.username = '$user'
                    ORDER BY h.waktu ASC";
            $result = $mysqli->query($sql);
            if($result && $result->num_rows > 0) {
                echo "<table class='result'>";
                echo "<tr><th>No</th><th>Jawaban Anda</th><th>Skor</th><th>Waktu</th></tr>";
                $no = 1;
                while($row = $result->fetch_assoc()){
                    echo "<tr>";
                    echo "<td>" . $no++ . "</td>";
                    echo "<td>" . htmlspecialchars($row['jawaban_user']) . "</td>";
                    echo "<td>" . $row['skor'] . "</td>";
                    echo "<td>" . $row['waktu'] . "</td>";
                    echo "</tr>";
                }
                echo "</table>";
            } else {
                echo "<p>Tidak ada data Pilihan Ganda Biasa.</p>";
            }
            ?>
        </div>
        <div class="section">
            <h2>Pilihan Ganda Komplek</h2>
            <?php
            $sql = "SELECT h.skor, h.jawaban_user, h.waktu
                    FROM hasil_komplek h
                    WHERE h.username = '$user'
                    ORDER BY h.waktu ASC";
            $result = $mysqli->query($sql);
            if($result && $result->num_rows > 0) {
                echo "<table class='result'>";
                echo "<tr><th>No</th><th>Jawaban Anda</th><th>Skor</th><th>Waktu</th></tr>";
                $no = 1;
                while($row = $result->fetch_assoc()){
                    echo "<tr>";
                    echo "<td>" . $no++ . "</td>";
                    echo "<td>" . htmlspecialchars($row['jawaban_user']) . "</td>";
                    echo "<td>" . $row['skor'] . "</td>";
                    echo "<td>" . $row['waktu'] . "</td>";
                    echo "</tr>";
                }
                echo "</table>";
            } else {
                echo "<p>Tidak ada data Pilihan Ganda Komplek.</p>";
            }
            ?>
        </div>
        <div class="section">
            <h2>Menjodohkan</h2>
            <?php
            $sql = "SELECT h.skor, h.jawaban_user, h.waktu
                    FROM hasil_jodoh h
                    WHERE h.username = '$user'
                    ORDER BY h.waktu ASC";
            $result = $mysqli->query($sql);
            if($result && $result->num_rows > 0) {
                echo "<table class='result'>";
                echo "<tr><th>No</th><th>Jawaban Anda</th><th>Skor</th><th>Waktu</th></tr>";
                $no = 1;
                while($row = $result->fetch_assoc()){
                    echo "<tr>";
                    echo "<td>" . $no++ . "</td>";
                    echo "<td>" . htmlspecialchars($row['jawaban_user']) . "</td>";
                    echo "<td>" . $row['skor'] . "</td>";
                    echo "<td>" . $row['waktu'] . "</td>";
                    echo "</tr>";
                }
                echo "</table>";
            } else {
                echo "<p>Tidak ada data Menjodohkan.</p>";
            }
            ?>
        </div>
        <div class="section">
            <h2>Benar/Salah</h2>
            <?php
            $sql = "SELECT h.skor, h.jawaban_user, h.waktu
                    FROM hasil_bs h
                    WHERE h.username = '$user'
                    ORDER BY h.waktu ASC";
            $result = $mysqli->query($sql);
            if($result && $result->num_rows > 0) {
                echo "<table class='result'>";
                echo "<tr><th>No</th><th>Jawaban Anda</th><th>Skor</th><th>Waktu</th></tr>";
                $no = 1;
                while($row = $result->fetch_assoc()){
                    echo "<tr>";
                    echo "<td>" . $no++ . "</td>";
                    echo "<td>" . htmlspecialchars($row['jawaban_user']) . "</td>";
                    echo "<td>" . $row['skor'] . "</td>";
                    echo "<td>" . $row['waktu'] . "</td>";
                    echo "</tr>";
                }
                echo "</table>";
            } else {
                echo "<p>Tidak ada data Benar/Salah.</p>";
            }
            ?>
        </div>

        <div class="no-print">
            <button onclick="window.print()" class="print-btn">Print Laporan</button>
            <button onclick="window.location.href='login.php'" class="login-btn">Logout</button>
            <a id="wa-share-btn" class="share-btn" href="#" target="_blank" rel="noopener noreferrer">
                Share ke WhatsApp
            </a>
            <script>
            // WhatsApp share logic
            document.addEventListener('DOMContentLoaded', function() {
                var nama = "<?= isset($user_data['nama']) ? addslashes($user_data['nama']) : $user ?>";
                var nilai = "<?= $nilai_akhir ?>";
                var skor = "<?= $total_skor ?>";
                var link = window.location.origin + window.location.pathname;
                var pesan = `Laporan AKM\nNama: ${nama}\nSkor: ${skor}\nNilai: ${nilai}\nCek detail: ${link}`;
                var waUrl = `https://wa.me/?text=${encodeURIComponent(pesan)}`;
                var btn = document.getElementById('wa-share-btn');
                btn.setAttribute('href', waUrl);
            });
            </script>
        </div>
    <?php $mysqli->close(); ?>
</body>
</html>