<?php
// filepath: /opt/lampp/htdocs/soal_online/bs.php
session_start();
if (!isset($_SESSION["user"])) {
    header("Location: login.php");
    exit();
}
$user = $_SESSION["user"];

// File: report_hasil_bs.php
// Description: Menampilkan laporan hasil kuis dari tabel hasil_bs

// Database configuration
$host = 'localhost';
$dbname = 'lnibbicy_kka5';
$username = 'lnibbicy_kka5';
$password = 'magetan#2';

try {
    // Create connection
    $conn = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Query to get data from hasil_bs table
    $query = "SELECT username, jawaban_user, skor FROM hasil_komplek ORDER BY skor DESC";
    $stmt = $conn->prepare($query);
    $stmt->execute();
    
    // Fetch all results
    $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
} catch(PDOException $e) {
    die("Koneksi database gagal: " . $e->getMessage());
}

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Hasil Soal Pilihan Ganda Komplek</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            background-color: #f8fafc;
        }
        .header {
            background-color: #4f46e5;
            color: white;
        }
        .highlight {
            background-color: #e0f2fe;
        }
        table {
            min-width: 600px;
        }
    </style>
</head>
<body>
    <div class="container mx-auto py-8 px-4">
        <h1 class="text-3xl font-bold text-center mb-8 text-gray-800">Laporan Hasil Soal Pilihan Ganda Komplek</h1>
        
        <div class="bg-white rounded-lg shadow-lg overflow-hidden mb-8">
            <div class="header px-6 py-4">
                <h2 class="text-xl font-semibold">Data Hasil Kuis</h2>
            </div>
            
            <div class="overflow-x-auto">
                <table class="w-full table-auto">
                    <thead>
                        <tr class="bg-gray-100 text-gray-600 uppercase text-sm leading-normal">
                            <th class="py-3 px-6 text-left">No</th>
                            <th class="py-3 px-6 text-left">Nama Peserta</th>
                            <th class="py-3 px-6 text-left">Jawaban</th>
                            <th class="py-3 px-6 text-center">Skor</th>
                            <th class="py-3 px-6 text-center">Status</th>
                        </tr>
                    </thead>
                    <tbody class="text-gray-600 text-sm">
                        <?php 
                        $no = 1;
                        foreach($results as $row): 
                            $status = ($row['skor'] >= 1) ? 'Lulus' : 'Tidak Lulus';
                            $statusClass = ($row['skor'] >= 70) ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800';
                        ?>
                        <tr class="border-b border-gray-200 hover:bg-gray-50 <?php echo ($no % 2 == 0) ? 'highlight' : ''; ?>">
                            <td class="py-3 px-6"><?= $no; ?></td>
                            <td class="py-3 px-6"><?= htmlspecialchars($row['username']); ?></td>
                            <td class="py-3 px-6 max-w-xs truncate" title="<?= htmlspecialchars($row['jawaban_user']); ?>">
                                <?= htmlspecialchars(substr($row['jawaban_user'], 0, 50)); ?>...
                            </td>
                            <td class="py-3 px-6 text-center font-semibold"><?= $row['skor']; ?></td>
                            <td class="py-3 px-6 text-center">
                                <span class="rounded-full py-1 px-3 text-xs font-semibold <?= $statusClass; ?>">
                                    <?= $status; ?>
                                </span>
                            </td>
                        </tr>
                        <?php 
                        $no++;
                        endforeach; 
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
        
        <div class="bg-white rounded-lg shadow-lg p-6">
            <div class="flex flex-col md:flex-row justify-between items-center mb-6">
                <h2 class="text-xl font-semibold text-gray-800 mb-4 md:mb-0">Ringkasan Hasil</h2>
                
                <div class="flex space-x-4">
                    <div class="bg-blue-50 p-4 rounded-lg">
                        <p class="text-blue-800 font-semibold">Total Peserta: <?= count($results); ?></p>
                    </div>
                    <?php
                    $passed = array_filter($results, function($row) {
                        return $row['skor'] >= 70;
                    });
                    ?>
                    <div class="bg-green-50 p-4 rounded-lg">
                        <p class="text-green-800 font-semibold">Lulus: <?= count($passed); ?></p>
                    </div>
                </div>
            </div>
            
            <div class="border-t border-gray-200 pt-6">
                <h3 class="text-lg font-semibold mb-4">Statistik Skor</h3>
                <?php if(count($results) > 0): 
                    $scores = array_column($results, 'skor');
                    $average = array_sum($scores) / count($scores);
                    $max = max($scores);
                    $min = min($scores);
                ?>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                    <div class="bg-indigo-50 p-4 rounded-lg">
                        <p class="text-indigo-600">Skor Tertinggi</p>
                        <p class="text-2xl font-bold text-indigo-800"><?= $max; ?></p>
                    </div>
                    <div class="bg-purple-50 p-4 rounded-lg">
                        <p class="text-purple-600">Rata-rata Skor</p>
                        <p class="text-2xl font-bold text-purple-800"><?= round($average, 2); ?></p>
                    </div>
                    <div class="bg-pink-50 p-4 rounded-lg">
                        <p class="text-pink-600">Skor Terendah</p>
                        <p class="text-2xl font-bold text-pink-800"><?= $min; ?></p>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</body>
</html>
<?php 
// Close connection
$conn = null;
?>
