<?php
session_start();

// Cek login admin
if (isset($_SESSION["user"]) && isset($_SESSION["level"]) && $_SESSION["level"] === "admin") {
    $user = htmlspecialchars($_SESSION["user"]);
    $is_admin = true;
} else {
    $is_admin = false;
}

$host = "localhost";
$user = "lnibbicy_kka5";
$pass = "magetan#2";
$db   = "lnibbicy_kka5";

$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    die("Koneksi gagal: " . $conn->connect_error);
}

// Fungsi hapus token yang lebih dari 10 menit
function hapusTokenLebihDari10Menit($conn) {
    $sql = "DELETE FROM token_soal WHERE created_at < (NOW() - INTERVAL 10 MINUTE)";
    $conn->query($sql);
}

// Fungsi hapus token yang sudah nonaktif (aktif=0)
function hapusTokenNonAktif($conn) {
    $conn->query("DELETE FROM token_soal WHERE aktif = 0");
}

// Fungsi generate token otomatis setiap 10 menit
function generateAutoToken($length = 6) {
    $timeSlot = floor(time() / 600); // 600 detik = 10 menit
    $seed = hash('sha256', $timeSlot);
    $characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ123456789"; // tanpa angka 0
    $token = '';
    for ($i = 0; $i < $length; $i++) {
        $index = ord($seed[$i]) % strlen($characters);
        $token .= $characters[$index];
    }
    return strtoupper($token);
}

// Fungsi untuk mengaktifkan token (status aktif=1)
function startToken($conn, $token) {
    $conn->query("UPDATE token_soal SET aktif = 0 WHERE aktif = 1");
    $stmt = $conn->prepare("INSERT INTO token_soal (token, aktif, created_at) VALUES (?, 1, NOW())");
    $stmt->bind_param("s", $token);
    $stmt->execute();
    $stmt->close();
}

// Fungsi untuk menonaktifkan token (status aktif=0)
function stopToken($conn) {
    $conn->query("UPDATE token_soal SET aktif = 0 WHERE aktif = 1");
}

// Hapus token lama dan nonaktif setiap akses
hapusTokenLebihDari10Menit($conn);
hapusTokenNonAktif($conn);

$token = generateAutoToken();

$token_status = "";
if (isset($_POST['start_token'])) {
    startToken($conn, $token);
    $token_status = "Token telah diaktifkan!";
} elseif (isset($_POST['stop_token'])) {
    stopToken($conn);
    $token_status = "Token telah dinonaktifkan!";
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>Token Soal</title>
<style>
body {
    font-family: 'Segoe UI', Arial, sans-serif;
    background: linear-gradient(135deg, #5763ef 0%, #071728 100%);
    margin: 0;
    padding: 0;
    color: #222;
}
.container {
    max-width: 420px;
    margin: 48px auto 24px auto;
    background: rgba(255,255,255,0.95);
    border-radius: 12px;
    box-shadow: 0 8px 32px rgba(0,0,0,0.12);
    padding: 32px 24px 24px 24px;
    text-align: center;
}
h2 {
    color: #1976d2;
    margin-bottom: 18px;
    font-size: 1.5em;
    font-weight: 700;
    letter-spacing: 0.03em;
}
.token-box {
    font-size: 2.2em;
    font-weight: bold;
    letter-spacing: 0.25em;
    background: #e3f2fd;
    color: #1976d2;
    border-radius: 8px;
    padding: 18px 0;
    margin-bottom: 18px;
    box-shadow: 0 2px 8px #1976d233;
    user-select: all;
}
button, .btn-back {
    background: #1976d2;
    color: #fff;
    border: none;
    border-radius: 8px;
    padding: 10px 24px;
    font-size: 1em;
    font-weight: 600;
    margin: 8px 4px 0 4px;
    cursor: pointer;
    transition: background 0.2s;
}
button[name="stop_token"] {
    background: #dc3545;
}
button:hover, .btn-back:hover {
    background: #0048e4;
}
.btn-back {
    background: #0ea03a;
    margin-top: 12px;
}
.btn-back:hover {
    background: #08832d;
}
.info {
    font-size: 0.95em;
    color: #555;
    margin-top: 18px;
    background: #f5f5f5;
    border-radius: 6px;
    padding: 10px;
}
@media (max-width: 600px) {
    .container {
        max-width: 98vw;
        padding: 12px 4vw 18px 4vw;
        margin: 12px auto;
    }
    .token-box {
        font-size: 1.5em;
        padding: 12px 0;
    }
    h2 {
        font-size: 1.1em;
    }
    button, .btn-back {
        font-size: 0.95em;
        padding: 8px 12px;
    }
}
</style>
</head>
<body>
  <div class="container" role="main">
    <h2>🔑 Token Soal Otomatis</h2>
    <div id="countdown" style="font-size: 1.2rem; text-align: center; margin-top: 10px;">
      Token akan berganti dalam: <span id="time-left">00:00</span>
    </div>
    <br>
    <div class="token-box" id="token"><?php echo $token; ?></div>
    <?php if ($token_status): ?>
      <div style="color:#0ea03a; font-weight:bold; margin-bottom:10px;"><?= $token_status ?></div>
    <?php endif; ?>
    <form method="post" style="display:inline;">
      <button type="submit" name="start_token">▶️ Start Token</button>
      <button type="submit" name="stop_token" style="background:#dc3545;color:#fff;">⏹️ Stop Token</button>
    </form>
    <button onclick="copyToken()">📋 Copy Token</button>
    <button class="btn-back" onclick="goBack()">⬅️ Kembali</button>
    <p class="info">Token ini otomatis ter-generate dan token lama yang lebih dari 10 menit dihapus serta tidak pernah mengandung angka 0 (nol). Token yang sudah nonaktif juga otomatis dihapus dari database.</p>
  </div>

<script>
  function copyToken() {
    const tokenText = document.getElementById('token').innerText;
    navigator.clipboard.writeText(tokenText).then(() => {
      alert('Token berhasil disalin: ' + tokenText);
    }).catch(() => {
      alert('Gagal menyalin token. Silakan salin secara manual.');
    });
  }
  function goBack() {
    window.location.href = 'admin.php';
  }

  // Countdown timer untuk menunjukkan sisa waktu token
  function updateCountdown() {
    const now = Math.floor(Date.now() / 1000);
    const slot = Math.floor(now / 600);
    const nextSlotTime = (slot + 1) * 600;
    const secondsLeft = nextSlotTime - now;

    const minutes = Math.floor(secondsLeft / 60);
    const seconds = secondsLeft % 60;
    const formatted = `${String(minutes).padStart(2, '0')}:${String(seconds).padStart(2, '0')}`;
    document.getElementById('time-left').textContent = formatted;

    return secondsLeft;
  }

  setInterval(updateCountdown, 1000);

  const timeUntilRefresh = updateCountdown();
  setTimeout(() => {
    location.reload();
  }, timeUntilRefresh * 1000);
</script>
</body>
</html>