<?php
session_start();

// Jika sudah login sebagai admin, tampilkan menu input soal
if (isset($_SESSION["user"]) && isset($_SESSION["level"]) && $_SESSION["level"] === "admin") {
    $user = htmlspecialchars($_SESSION["user"]);
    $is_admin = true;
} else {
    $is_admin = false;
}





// Proses login admin
$login_error = "";
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["login_admin"])) {
    $username = $_POST["username"];
    $password = $_POST["password"];

    // Ganti username dan password di bawah sesuai kebutuhan
    if ($username === "admin" && $password === "admin123") {
        $_SESSION["user"] = $username;
        $_SESSION["level"] = "admin";
        header("Location: admin.php");
        exit();
    } else {
        $login_error = "Username atau password salah!";
        // Hapus session jika login gagal
        unset($_SESSION["user"]);
        unset($_SESSION["level"]);
        // Hapus cookie jika ada
        if (isset($_COOKIE["user"])) {
            setcookie("user", "", time() - 3600, "/");
        }
        if (isset($_COOKIE["level"])) {
            setcookie("level", "", time() - 3600, "/");
        }
        // Hapus session
        session_unset();
        session_destroy();
        // Redirect ke halaman login
        header("Location: admin.php");
        exit();
    }
    // Simpan username dan level di cookie jika login berhasil
    if ($is_admin) {
        setcookie("user", $username, time() + (86400 * 30), "/"); // 30 hari
        setcookie("level", "admin", time() + (86400 * 30), "/"); // 30 hari
    } else {
        // Hapus cookie jika login gagal
        setcookie("user", "", time() - 3600, "/");
        setcookie("level", "", time() - 3600, "/");
        // Hapus session
        session_unset();
        session_destroy();
        // Redirect ke halaman login
        header("Location: admin.php");
        exit();
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
      <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin - Input Soal</title>
    <link rel="stylesheet" href="style.css">
    <style>
        .mapel-card {
            background: linear-gradient(135deg, #ffffffff 0%, #dfeeffff 100%);
            border-radius: 22px;
            box-shadow: 0 4px 18px #00000055;
            margin: 12px;
            cursor: pointer;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            text-align: center;
            font-family: 'Comic Sans MS', 'Comic Sans', cursive, Arial, sans-serif;
            font-size: 0.3em;
            color:rgb(106, 57, 39);
            border: 2.5px solid #f6f2edff;
        }
        .mapel-card:hover {
            transform: scale(1.05) rotate(-2deg);
            box-shadow: 0 8px 32px #ffb34755;
            background: linear-gradient(120deg, #ffffffff 60%, #c5c2b4ff 100%);
            color: #007bff;
        }
        .mapel-card a {
            text-decoration: none;
            font-size: 3.02em;
            color: inherit;
            font-weight: bold;
            display: block;
        }
        .emoji {
            font-size: 3.02em;
            margin-top: 12px;
            display: block;
            margin-bottom: 12px;
            transition: transform 0.2s;
            color: #ff7f50;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.2);
            margin-bottom: 0px;
        }
        .mapel-card:hover .emoji {
            transform: scale(1.1) rotate(5deg);
            margin-bottom: 10px;
            display: block;
        }
        .login-form {
            max-width: 340px;
            margin: 60px auto;
            background: #ffffffff;
            border-radius: 18px;
            padding: 28px 24px;
            box-shadow: 0 4px 18px #06054755;
            border: 2px solid #0202ceff;
        }
        .login-form label {
            display: block;
            margin-top: 12px;
            font-weight: bold;
            color: #080808ff;
        }
        .login-form input[type="text"], .login-form input[type="password"] {
            width: 100%;
            padding: 8px 10px;
            margin-top: 1px;
            border-radius: 8px;
            border: 1.5px solid #ffb347;
            font-size: 1em;
        }
        .login-form button {
            margin-top: 18px;
            padding: 10px 28px;
            background: linear-gradient(90deg, #ffb347 0%, #ffcc80 100%);
            color: #fff;
            border: none;
            border-radius: 22px;
            font-size: 1.1em;
            font-weight: bold;
            cursor: pointer;
        }
        .login-form button:hover {
            background: linear-gradient(90deg, #ffffffff 0%, #f4e7d5ff 100%);
            color: #ff7f50;
        }
        .error-msg {
            color: red;
            margin-top: 10px;
            text-align: center;
        }
        body {
            background: linear-gradient(135deg, #0062ecff 0%, #ebf2faff 100%);
            font-family: 'Comic Sans MS', 'Comic Sans', cursive, Arial, sans-serif;
            color: #333;
            margin: 0;
            padding: 0;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            background-blend-mode: overlay;
            background-attachment: fixed;
            overflow-x: hidden;
            scroll-behavior: smooth;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
        }
        .tabel-peserta {
            margin: 32px auto 0 auto;
            background: #fffbe7;
            border-radius: 18px;
            box-shadow: 0 4px 18px #ffe08255;
            padding: 18px 12px;
            max-width: 600px;
        }
        .tabel-peserta th, .tabel-peserta td {
            padding: 8px 12px;
            text-align: center;
        }
        .btn-hapus {
            background: linear-gradient(90deg, #ff5858 0%, #f857a6 100%);
            color: #fff;
            border: none;
            border-radius: 8px;
            padding: 4px 14px;
            font-weight: bold;
            cursor: pointer;
        }
        .btn-hapus:hover {
            background: linear-gradient(90deg, #f857a6 0%, #ff5858 100%);
            color: #fff;
        }
        @media screen and (max-width: 800px) {
            .mapel-card {
                width: 70%;
                padding: 40px 50px;
            }
        }
        @media screen and (max-width: 600px) {
            .mapel-card {
                width: 89%;
                padding: 30px 40px;
            }
        }
        @media screen and (max-width: 400px) {
            .mapel-card {
                flex: inherit;           /* Lebar minimum 220px, fleksibel */
    margin: 0;
    box-sizing: border-box;
    padding: 28px 28px 28px 28px; /* Padding tetap */
    width: 110px;           /* Lebar tetap 220px */
    height: 100px;          /* Tinggi tetap 220px */
    font-family: 'Comic Sans MS', 'Comic Sans', cursive, Arial, sans-serif;
    font-size: 0.3em;
    color: #1a237e; /* Warna teks */
    border-radius: 16px;
    box-shadow: 0 2px 10px #ffe08255;
    background: linear-gradient(120deg, #fffbe7 80%, #ffe082 100%);
    border: 2px solid #ffb347;
    transition: background 0.2s, color 0.2s, box-shadow 0.2s;
    text-align: center;
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    position: relative;
    overflow: hidden; /* Mencegah konten meluap */
    color: #1a237e; /* Warna teks default */
    text-decoration: none; /* Menghilangkan garis bawah pada link */
    font-weight: 500; /* Berat font default */
   
    </style>
<body>
<?php if ($is_admin): ?>
    <h2 style="text-align:center;">Selamat datang, <?= $user ?>! 👋</h2>
    <h2 style="text-align:center;">Menu Input Soal Mapel:</h2>
    <div class="container">
        <div class="mapel-list">
        <div class="mapel-card">
            <span class="emoji">🔑</span>
            <a href="admin_token.php">Token</a>
        </div>
       
        
        <div class="mapel-card">
            <span class="emoji">🖊️</span>
            <a href="input_ganda_b.php">Ganda Biasa</a>
        </div>
        <div class="mapel-card">
            <span class="emoji">🧩</span>
            <a href="insert_komplek.php">Ganda Komplek</a>
        </div>
        <div class="mapel-card">
            <span class="emoji">🔗</span>
            <a href="input_jodoh.php">Menjodohkan</a>
        </div>
        <div class="mapel-card">
            <span class="emoji">📚</span>
            <a href="input_bs.php">Benar atau Salah</a>
        </div>
        <div class="mapel-card">
            <span class="emoji">📋</span>
            <a href="admin_status.php">STATUS-AKM</a>
        </div>
        <div class="mapel-card">
            <span class="emoji">👀</span>
            <a href="monitoring.php">PANTAU_AKM</a>
        </div>
        <div class="mapel-card">
            <span class="emoji">📈</span>
            <a href="rekap_individu.php">REKAP-AKM</a>
        </div>
        <div class="mapel-card">
            <span class="emoji">👤</span>
            <a href="insert_user.php">Input Peserta</a>
        </div>
        <div class="mapel-card">
            <span class="emoji">✅</span>
            <a href="verifikasi_user.php">Verifikasi Peserta</a>
        </div>
        <div class="mapel-card">
            <span class="emoji">❌</span>
            <a href="daftar_peserta.php">Hapus Peserta</a>
        </div>
    </div>

    


    <div style="margin-top:32px;margin-bottom: 32px;text-align:center;">
        <a href="login.php" class="logout-button">Logout</a>
    </div>
    <footer>
        <p>&copy; 2025-Kelas 5. All rights reserved.</p>
        <p>Dibuat dan dikembangkan oleh tim IT SDN Magetan 2</p>
        <br>
    </footer>
<?php else: ?>
    <form method="post" class="login-form" autocomplete="off">
        <h2 style="text-align:center;">Login Admin</h2>
        <?php if ($login_error): ?>
            <div class="error-msg"><?= $login_error ?></div>
        <?php endif; ?>
        <label>Username:</label>
        <input type="text" name="username" required autofocus>
        <label>Password:</label>
        <input type="password" name="password" required>
        <button type="submit" name="login_admin">Login</button>
    </form>
    <div style="text-align:center; margin-top: 20px;">
<a href="login.php" style="color: yellow;">Kembali ke Halaman Utama</a>
    </div>
    <style>
        body {
            background: linear-gradient(135deg, #5763efff 0%, #071728ff 100%);
            font-family: 'Comic Sans MS', 'Comic Sans', cursive, Arial, sans-serif;
        }
        h2 {
            color: #ff7f50;
            text-align: center;
            margin-top: 24px;
        }
        .logout-button {
            background: linear-gradient(90deg, #ffb347, #ffcc80);
            color: #fff;
            padding: 10px 20px;
            border-radius: 22px;
            text-decoration: none;
            font-weight: bold;
        }
        .logout-button:hover {
            background: linear-gradient(90deg, #ffcc80, #ffb347);
            color: #ff7f50;
        }
    </style>
<?php endif; ?>
</body>
</html>